/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class GetIdpIconServlet
extends HttpServlet {
    private final IdpConfManager idpConfManager;
    private final HomeDirectoryResolver homeDirectoryResolver;

    @Inject
    public GetIdpIconServlet(RequireAdminServletDependencyBucket bucket) {
        this.idpConfManager = bucket.getIdpConfManager();
        this.homeDirectoryResolver = bucket.getKerbConfManager().getHomeDirectoryResolver();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.setContentType("text/html");
            resp.sendError(404);
            return;
        }
        ServletOutputStream out = resp.getOutputStream();
        File[] iconDirectory = new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/").listFiles(pathname -> pathname.toString().contains(id));
        if (iconDirectory == null || iconDirectory.length <= 0) {
            return;
        }
        String iconPath = iconDirectory[0].toString();
        String fileExtension = iconPath.substring(iconPath.lastIndexOf(".") + 1);
        String imageType = "svg".equals(fileExtension) ? "svg+xml" : fileExtension;
        resp.setContentType("image/" + imageType);
        FileInputStream fin = new FileInputStream(iconPath);
        BufferedInputStream bin = new BufferedInputStream(fin);
        BufferedOutputStream bout = new BufferedOutputStream((OutputStream)out);
        int ch = 0;
        while ((ch = bin.read()) != -1) {
            bout.write(ch);
        }
        bin.close();
        fin.close();
        bout.close();
        out.close();
    }
}

