/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class IdpConfigureUserAgentRestrictionsAction
extends RequireAdminServlet {
    public static final Set<String> lastUserAgents = Collections.synchronizedSet(new LinkedHashSet());
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public IdpConfigureUserAgentRestrictionsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restrictionList", this.kerbConfManager.getIdpDisabledUserAgents());
        model.put("topMenu", "SAML");
        model.put("lastTenUserAgents", lastUserAgents);
        model.put("menuItem", "idp-useragentrestrict");
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/idp-useragent_restrict.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String removeUserAgent;
        String addUserAgent = req.getParameter("addUserAgent");
        if (StringUtils.isNotBlank((CharSequence)addUserAgent)) {
            addUserAgent = addUserAgent.trim();
            this.kerbConfManager.addIdpDisabledUserAgent(addUserAgent);
        }
        if (StringUtils.isNotBlank((CharSequence)(removeUserAgent = req.getParameter("removeUserAgent")))) {
            this.kerbConfManager.removeIdpDisabledUserAgent(removeUserAgent);
        }
        resp.sendRedirect("idp-useragentrestrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLastUserAgentsList(String userAgent) {
        Set<String> set = lastUserAgents;
        synchronized (set) {
            lastUserAgents.add(userAgent);
            if (lastUserAgents.size() > 10) {
                Iterator<String> it = lastUserAgents.iterator();
                while (lastUserAgents.size() > 10 && it.hasNext()) {
                    String oldest = it.next();
                    lastUserAgents.remove(oldest);
                }
            }
        }
    }
}

