/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.BambooHostApp;
import org.kantega.atlaskerb.hostapp.BitbucketHostApp;
import org.kantega.atlaskerb.hostapp.ConfluenceHostApp;
import org.kantega.atlaskerb.hostapp.FecruHostApp;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.springframework.stereotype.Component;

@Component
public class HostAppFactory {
    private final HostApp hostApp;

    @Inject
    public HostAppFactory(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport EventPublisher eventPublisher, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        String platformId = applicationProperties.getPlatformId();
        if (platformId.equals("jira")) {
            this.hostApp = new JiraHostApp(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        } else if (platformId.equals("conf")) {
            this.hostApp = new ConfluenceHostApp(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        } else if (platformId.equals("bitbucket")) {
            this.hostApp = new BitbucketHostApp(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        } else if (platformId.equals("fisheye")) {
            this.hostApp = new FecruHostApp(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        } else if (platformId.equals("bamboo")) {
            this.hostApp = new BambooHostApp(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        } else {
            throw new IllegalStateException("This plugin does not work on " + applicationProperties.getDisplayName());
        }
        kerbConfManager.setHomeDirectoryResolver(this.hostApp::getHomeDirectory);
    }

    public HostApp getInstance() {
        return this.hostApp;
    }
}

