/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update.data;

import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdateResult;
import org.kantega.atlaskerb.utils.Version;

@JsonMapping.JsonMapper
public final class UpdatePluginSettingsEntryResult
implements UpdateResult {
    @JsonMapping.JsonProperty
    private final String previousVersion;
    @JsonMapping.JsonProperty(value="resultCode")
    private final KssoUpdateManager.ResultCode resultCode;
    @JsonMapping.JsonProperty(value="message")
    private final String message;
    @JsonMapping.JsonProperty(value="oldConfigurationKey")
    private final KerbConfManager.KEYS oldConfigurationKey;
    @JsonMapping.JsonProperty(value="configPageUrl")
    private final String configPageUrl;
    @JsonMapping.JsonProperty(value="configPageName")
    private final String configPageName;
    @JsonMapping.JsonProperty(value="dataWithErrorMessages")
    private final String dataWithErrorMessages;

    public UpdatePluginSettingsEntryResult(Version previousVersion, KssoUpdateManager.ResultCode resultCode, String message, KerbConfManager.KEYS configurationKey, String configPageUrl, String configPageName) {
        this.previousVersion = (String)Option.of((Object)previousVersion).map(Version::stringValue).getOrNull();
        this.resultCode = resultCode;
        this.message = message;
        this.oldConfigurationKey = configurationKey;
        this.configPageUrl = configPageUrl;
        this.configPageName = configPageName;
        this.dataWithErrorMessages = null;
    }

    private UpdatePluginSettingsEntryResult() {
        this.previousVersion = null;
        this.resultCode = null;
        this.message = null;
        this.oldConfigurationKey = null;
        this.configPageUrl = null;
        this.configPageName = null;
        this.dataWithErrorMessages = null;
    }

    public UpdatePluginSettingsEntryResult(@JsonMapping.JsonProperty(value="previousVersion") String previousVersion, @JsonMapping.JsonProperty(value="resultCode") KssoUpdateManager.ResultCode resultCode, @JsonMapping.JsonProperty(value="message") String message, @JsonMapping.JsonProperty(value="oldConfigurationKey") KerbConfManager.KEYS oldConfigurationKey, @JsonMapping.JsonProperty(value="configPageUrl") String configPageUrl, @JsonMapping.JsonProperty(value="configPageName") String configPageName, @JsonMapping.JsonProperty(value="dataWithErrorMessages") String dataWithErrorMessages) {
        this.previousVersion = (String)Option.of((Object)previousVersion).getOrNull();
        this.resultCode = resultCode;
        this.message = message;
        this.oldConfigurationKey = oldConfigurationKey;
        this.configPageUrl = configPageUrl;
        this.configPageName = (String)Option.of((Object)configPageName).getOrElse((Object)("Could not find the relevant configuration page. Configuration key: " + oldConfigurationKey.name() + ". Contact support to get help with this."));
        this.dataWithErrorMessages = dataWithErrorMessages;
    }

    @Override
    public boolean isSuccess() {
        return this.resultCode == KssoUpdateManager.ResultCode.SUCCESS;
    }

    @Override
    public boolean isFailure() {
        return this.resultCode == KssoUpdateManager.ResultCode.FAILURE;
    }

    @Override
    @JsonMapping.JsonProperty(value="previousVersion")
    public String getpreviousVersion() {
        return this.previousVersion;
    }

    public Option<Version> maybeVersion() {
        return Option.of((Object)this.previousVersion).map(Version::new);
    }

    @Override
    @JsonMapping.JsonProperty(value="resultCode")
    public KssoUpdateManager.ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    @JsonMapping.JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonMapping.JsonProperty(value="configPageUrl")
    public String getConfigPageUrl() {
        return this.configPageUrl;
    }

    @Override
    @JsonMapping.JsonProperty(value="configPageName")
    public String getConfigPageName() {
        return this.configPageName;
    }

    @JsonMapping.JsonProperty(value="oldConfigurationKey")
    public KerbConfManager.KEYS getOldConfigurationKey() {
        return this.oldConfigurationKey;
    }

    @Override
    @JsonMapping.JsonProperty(value="dataWithErrorMessages")
    public String getDataWithErrorMessages() {
        return StringUtils.trim((String)this.dataWithErrorMessages);
    }
}

