/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class IdpIconServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HomeDirectoryResolver homeDirectoryResolver;
    private final List<String> allowedFileExtensions = List.of((Object[])new String[]{"jpg", "jpeg", "png", "svg"});

    @Inject
    public IdpIconServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.homeDirectoryResolver = bucket.getKerbConfManager().getHomeDirectoryResolver();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        IdpConfiguration configuration = new ArrayList<IdpConfiguration>(this.idpConfManager.getIdentityProviders()).get(0);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        HashMap<String, Boolean> hasCustomIcon = this.createHashMapOverCustomIcons();
        boolean requestIsFromIdentityProviderTab = (Boolean)Option.of((Object)req.getHeader("Referer")).map(referer -> referer.contains("providers") || referer.contains("certs") || referer.contains("login-screen")).getOrElse((Object)false);
        boolean requestHasTopMenuAndTopMenuIsSaml = (Boolean)Option.of((Object)req.getParameter("topMenu")).map(topMenu -> topMenu.equals("SAML")).getOrElse((Object)false);
        if (requestIsFromIdentityProviderTab || requestHasTopMenuAndTopMenuIsSaml) {
            model.put("topMenu", "SAML");
        } else {
            model.put("topMenu", "dashboard");
        }
        model.put("menuItem", "idp-icon");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("providers", this.idpConfManager.getIdentityProviders());
        model.put("baseBackupUrl", req.getContextPath() + "/download/resources/" + this.kerbConfManager.getLicenseManager().getPluginKey() + "/images/svg/");
        model.put("useIcon", this.idpConfManager.isUseIcon());
        model.put("hasCustomIcon", hasCustomIcon);
        this.getTemplateRenderer().render("templates/saml/idp-icons.vm", model, (Writer)resp.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws IOException {
        MultipartHttpRequest req;
        block21: {
            req = null;
            try {
                req = this.getMultipartRequest(request, 512000L);
            }
            catch (IOException e) {
                Map<String, Object> model = this.newModel(request);
                model.put("fileTooLarge", true);
                this.renderPage(request, resp, model);
                return;
            }
            catch (IllegalArgumentException e) {
                if (!this.hostApp.isProductMatch("bamboo")) break block21;
                this.idpConfManager.setUseIcon(request.getParameter("useIcon") != null && "on".equals(request.getParameter("useIcon")));
                Map<String, Object> model = this.newModel(request);
                this.renderPage(request, resp, model);
                return;
            }
        }
        Map<String, Object> model = this.newModel((HttpServletRequest)req);
        String action = req.getParameter("action");
        model.put("action", action);
        if ("useIcon".equals(action)) {
            this.idpConfManager.setUseIcon(req.getParameter("useIcon") != null && "on".equals(req.getParameter("useIcon")));
            this.renderPage((HttpServletRequest)req, resp, model);
            return;
        }
        String id = req.getParameter("idpId");
        IdpConfiguration idp = this.idpConfManager.getIdentityProviderById(id);
        model.put("modifiedIdp", idp.getName());
        if ("uploadIcon".equals(action)) {
            String fileExtension = req.getFilename("file").substring(req.getFilename("file").lastIndexOf(".") + 1);
            if (!this.allowedFileExtensions.contains((Object)fileExtension)) {
                model.put("illegalFileExtension", true);
                this.renderPage((HttpServletRequest)req, resp, model);
                return;
            }
            ByteArrayInputStream iconStream = null;
            byte[] file = req.getFile("file");
            if (file == null || file.length <= 0) {
                model.put("missingFile", true);
                this.renderPage((HttpServletRequest)req, resp, model);
                return;
            }
            iconStream = new ByteArrayInputStream(file);
            try {
                boolean result = this.updateIcon(iconStream, id, fileExtension);
                if (result) {
                    model.put("successfullyUpdatedIcon", true);
                }
                model.put("failedToUpdateIcon", true);
            }
            catch (Exception e) {
                model.put("failedToUpdateIcon", true);
                this.renderPage((HttpServletRequest)req, resp, model);
                return;
            }
            finally {
                try {
                    ((InputStream)iconStream).close();
                }
                catch (Exception exception) {}
            }
        } else if ("deleteIcon".equals(action)) {
            this.removeOldIcon(id, "");
            model.put("successfullyDeletedIcon", true);
        }
        this.renderPage((HttpServletRequest)req, resp, model);
    }

    private void removeOldIcon(String id, String currentFileExtension) {
        File[] iconDirectory = new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/").listFiles(pathname -> pathname.toString().contains(id));
        if (iconDirectory != null) {
            for (File file : iconDirectory) {
                if (file.toString().contains(currentFileExtension) && !currentFileExtension.isEmpty()) continue;
                boolean bl = file.delete();
            }
        }
    }

    private boolean updateIcon(InputStream inputStream, String id, String fileExtension) {
        try {
            if (!new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/").exists()) {
                boolean bl = new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/").mkdir();
            }
            if (!"svg".equals(fileExtension)) {
                BufferedImage bf = ImageIO.read(inputStream);
                ImageIO.write((RenderedImage)bf, fileExtension, new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/" + id + "-icon." + fileExtension));
            } else {
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/" + id + "-icon." + fileExtension));
            }
            this.removeOldIcon(id, fileExtension);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private HashMap<String, Boolean> createHashMapOverCustomIcons() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        File[] iconDirectory = new File(this.homeDirectoryResolver.getHomeDirectory() + "/idp-icons/").listFiles();
        if (iconDirectory != null) {
            for (IdpConfiguration idp : this.idpConfManager.getIdentityProviders()) {
                if (Arrays.stream(iconDirectory).anyMatch(file -> file.toString().contains(idp.getId()))) {
                    hashMap.put(idp.getId(), true);
                    continue;
                }
                hashMap.put(idp.getId(), false);
            }
        }
        return hashMap;
    }
}

