/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.kantega.atlaskerb.DisableTraditionalLoginServlet;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.DiscoverIdpHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.UserManagerUtils;

public class DiscoverIdpServlet
extends HttpServlet {
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;
    private final UserManager userManager;
    private final HostApp hostApp;
    private DiscoverIdpHelper discoverIdpHelper;

    @Inject
    public DiscoverIdpServlet(IdpConfManager idpConfManager, KerbConfManager kerbConfManager, UserLookupService userLookupService, HostAppFactory hostAppFactory, @ComponentImport UserManager userManager) {
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = userLookupService;
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        resp.setContentType("application/json");
        Option maybeUsername = Option.of((Object)req.getParameter("username"));
        Option maybeIsJsmLogin = Option.of((Object)req.getParameter("isJsmLogin"));
        boolean isJsmLogin = Boolean.parseBoolean((String)maybeIsJsmLogin.getOrElse((Object)"false"));
        this.discoverIdpHelper = new DiscoverIdpHelper(this.hostApp, this.userLookupService, this.idpConfManager, isJsmLogin);
        HashMap data = ((HashMap)maybeUsername.map(username -> this.getProvidersByUsername(req, (String)username)).getOrElse(() -> this.getProviders(req))).merge((Map)(this.discoverIdpHelper.discoverIdpProviders((String)maybeUsername.getOrElse((Object)"")).isEmpty() ? HashMap.of((Object)"fallbacks", this.getIdentityProviders(req, this.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.FALLBACK))) : HashMap.empty())).merge((Map)(!this.hasPreviouslyKnownLogin(req) ? HashMap.of((Object)"manual", this.getIdentityProviders(req, this.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP)))) : HashMap.empty())).merge((Map)(this.hasPreviouslyKnownLogin(req) ? HashMap.of((Object)"last", (Object)((HashMap)((io.vavr.collection.List)CookieUtil.getPreviouslyKnownLoginId(req).map(this.idpConfManager::getEnabledIdentityProviderById).filter(Objects::nonNull).filter(idp -> this.discoverIdpHelper.getRedirectPolicy((IdpConfiguration)idp) != IdpConfiguration.RedirectPolicy.NONE).map(idp -> io.vavr.collection.List.ofAll(this.getIdentityProviders(req, io.vavr.collection.List.of((Object)idp).asJava()))).getOrElse((Object)io.vavr.collection.List.empty())).map(providerMap -> HashMap.ofAll((java.util.Map)providerMap).merge((Map)CookieUtil.getPreviouslyKnownLoginUsername(req).map(username -> HashMap.of((Object)"account", (Object)username)).getOrElse((Object)HashMap.empty()))).getOrElse((Object)HashMap.empty())).toJavaMap()) : HashMap.empty())).merge((Map)HashMap.of((Object)"allTraditionalLoginDisabledMessage", (Object)this.kerbConfManager.getAllTraditionalLoginDisabledMessage())).merge((Map)HashMap.of((Object)"useIdpPriority", (Object)this.idpConfManager.isUseIdpPriority()));
        JsonMapping.Write.mapAsJson((java.util.Map)data.toJavaMap()).mapTry(JSONObject::toString).andThenTry(jsonString -> {
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            PrintWriter w = resp.getWriter();
            w.print((String)jsonString);
        }).onSuccess(_jsonString -> resp.setStatus(200)).onFailure(_e -> resp.setStatus(204));
    }

    @NotNull
    private HashMap<String, Object> getProviders(HttpServletRequest req) {
        return HashMap.of((Object)"auto", this.getIdentityProviders(req, this.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.ALL)), (Object)"manual", this.getIdentityProviders(req, this.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP))), (Object)"visible", this.getIdentityProviders(req, this.discoverIdpHelper.getVisibleProviders()), (Object)"enableWorkAccount", (Object)(!this.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP, IdpConfiguration.RedirectPolicy.FALLBACK, IdpConfiguration.RedirectPolicy.ALL)).isEmpty() ? 1 : 0), (Object)"allowTraditionalLogin", (Object)(!DisableTraditionalLoginServlet.isBlockTraditionalLogin(this.kerbConfManager, this.userLookupService) && this.idpConfManager.getUsernamePasswordLinkEnabled() ? 1 : 0), (Object)"allowTraditionalLoginJsm", (Object)(!DisableTraditionalLoginServlet.isBlockTraditionalLoginJSM(this.kerbConfManager, this.userLookupService) && this.idpConfManager.getUsernamePasswordLinkEnabled() ? 1 : 0), (Object)"isAuthenticated", (Object)this.hostApp.isLoggedIn(req), (Object)"redirectProgressDelay", (Object)(1000 * this.idpConfManager.getRedirectProgressDelay()), (Object)"kssoAuthAnonymousBrowsingUser", (Object)req.getSession().getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER"));
    }

    @NotNull
    private HashMap<String, Object> getProvidersByUsername(HttpServletRequest req, String username) {
        return HashMap.of((Object)"matches", this.getIdentityProviders(req, this.discoverIdpHelper.discoverIdpProviders(username)), (Object)"isSystemAdmin", (Object)UserManagerUtils.isSystemAdmin(username, this.userManager), (Object)"allowTraditionalLogin", (Object)(!DisableTraditionalLoginServlet.isBlockTraditionalLogin(this.kerbConfManager, this.userLookupService) && this.idpConfManager.getUsernamePasswordLinkEnabled() ? 1 : 0), (Object)"allowTraditionalLoginJsm", (Object)(!DisableTraditionalLoginServlet.isBlockTraditionalLoginJSM(this.kerbConfManager, this.userLookupService) && this.idpConfManager.getUsernamePasswordLinkEnabled() ? 1 : 0));
    }

    private boolean hasPreviouslyKnownLogin(HttpServletRequest req) {
        return (Boolean)CookieUtil.getPreviouslyKnownLoginId(req).map(this.idpConfManager::getEnabledIdentityProviderById).filter(Objects::nonNull).filter(idpConfiguration -> this.discoverIdpHelper.getRedirectProperties((IdpConfiguration)idpConfiguration).isKnownAutoRedirect()).filter(idp -> this.discoverIdpHelper.getRedirectPolicy((IdpConfiguration)idp) != IdpConfiguration.RedirectPolicy.NONE).map(_idp -> true).getOrElse((Object)false);
    }

    private List<java.util.HashMap<String, String>> getIdentityProviders(HttpServletRequest req, List<IdpConfiguration> idpConfigurations) {
        return io.vavr.collection.List.ofAll(idpConfigurations).map(idp -> this.createProviderMap(req, (IdpConfiguration)idp)).asJava();
    }

    private java.util.HashMap<String, String> createProviderMap(HttpServletRequest req, IdpConfiguration idp) {
        RedirectProperties redirectProperties = this.discoverIdpHelper.getRedirectProperties(idp);
        return HashMap.of((Object)"id", (Object)idp.getId(), (Object)"loginUrl", (Object)this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId()), (Object)"name", (Object)idp.getName(), (Object)"useHostedDomain", (Object)Boolean.valueOf(idp.isHostedDomain()).toString(), (Object)"sendLoginHint", (Object)Boolean.valueOf(redirectProperties.isSendLoginHint()).toString(), (Object)"useIcon", (Object)Boolean.valueOf(this.idpConfManager.isUseIcon()).toString(), (Object)"pluginAdminPath", (Object)"/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin", (Object)"kssoPluginKey", (Object)this.kerbConfManager.getLicenseManager().getPluginKey(), (Object)"kind", (Object)idp.getKind().toString()).merge((Map)(!idp.getKnownDomains().isEmpty() ? HashMap.of((Object)"hostedDomain", (Object)idp.getKnownDomains().stream().findFirst().orElse("")) : HashMap.empty())).toJavaMap();
    }

    private List<IdpConfiguration> getProvidersByRedirectPolicy(EnumSet<IdpConfiguration.RedirectPolicy> redirectPolicies) {
        io.vavr.collection.List idpConfigs = io.vavr.collection.List.ofAll(this.idpConfManager.getSortedIdentityProviders());
        return idpConfigs.filter(idpConfig -> redirectPolicies.contains((Object)this.discoverIdpHelper.getRedirectProperties((IdpConfiguration)idpConfig).getRedirectPolicy())).filter(IdpConfiguration::isEnabled).asJava();
    }

    private List<IdpConfiguration> getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy) {
        return this.getProvidersByRedirectPolicy(EnumSet.of(redirectPolicy));
    }
}

