/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarServiceImpl;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import io.vavr.CheckedFunction0;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RemembermeUtils;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.UserdetailsInCommentRequestWrapper;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservableHeaderAwareResponse;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.SSOScriptLoginHookCondition;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHostApp
extends DefaultHostApp {
    private static final String COMMENT_REST_URL = "/rest/api/2/issue/.*/comment";
    private static final String COMMENT_POST_URL = "/secure/AddComment.jspa";
    private final Method recordLoginMethod;
    private final Object loginComponent;
    private final Method fromUser;
    private final AvatarServiceImpl avatarServiceImpl;
    private final UserManager userManager;
    private final Logger log;
    private boolean useApplicationUser;
    private Class<?> beforeUserAuthenticateClass;
    private final AvatarManager avatarManager;
    private final AvatarService avatarService;

    public JiraHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        Method fromUser;
        Object loginComponent;
        Method recordLoginMethod;
        block4: {
            super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
            this.log = LoggerFactory.getLogger(this.getClass());
            this.beforeUserAuthenticateClass = null;
            this.hasRestApi = true;
            recordLoginMethod = null;
            loginComponent = null;
            fromUser = null;
            this.avatarManager = ComponentAccessor.getAvatarManager();
            this.avatarService = ComponentAccessor.getAvatarService();
            this.userManager = ComponentAccessor.getUserManager();
            this.avatarServiceImpl = (AvatarServiceImpl)ComponentAccessor.getComponent(AvatarServiceImpl.class);
            try {
                ClassLoader ccl = this.getClass().getClassLoader().getParent();
                if (ccl == null) break block4;
                Class<?> loginStoreClass = ccl.loadClass("com.atlassian.jira.security.login.LoginStore");
                Class<?> applicationUserClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUser");
                Class<?> applicationUsersClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUsers");
                Class<User> crowdEmbeddedUserClass = User.class;
                this.beforeUserAuthenticateClass = ccl.loadClass("com.atlassian.jira.event.user.BeforeUserAuthenticate");
                try {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", applicationUserClass, Boolean.TYPE);
                    this.useApplicationUser = true;
                    fromUser = applicationUsersClass.getMethod("from", User.class);
                }
                catch (NoSuchMethodException e) {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", crowdEmbeddedUserClass, Boolean.TYPE);
                    this.useApplicationUser = false;
                }
                loginComponent = ComponentLocator.getComponent(loginStoreClass);
            }
            catch (Exception e) {
                this.log.warn("Could not load JIRA LoginStore. Login count / time update disabled", (Throwable)e);
            }
        }
        this.recordLoginMethod = recordLoginMethod;
        this.loginComponent = loginComponent;
        this.fromUser = fromUser;
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/issues/*");
        this.preemptivePathMappings.add("/browse/*");
        this.preemptivePathMappings.add("/secure/CreateIssue*");
        this.preemptivePathMappings.add("/secure/MyJiraHome.jspa");
        this.preemptivePathMappings.add("/secure/QuickSearch.jspa*");
        this.preemptivePathMappings.add("/secure/BrowseProjects.jspa*");
        this.preemptivePathMappings.add("/secure/BulkCreateSetupPage!default.jspa*");
        this.preemptivePathMappings.add("/secure/ConfigurePortalPages.jspa*");
        this.preemptivePathMappings.add("/secure/ManageFilters.jspa*");
        this.preemptivePathMappings.add("/sr/jira.issueviews:searchrequest-printable*");
        this.preemptivePathMappings.add("/secure/StructureBoard*");
        this.preemptivePathMappings.add("/plugins/servlet/jeditor_file_provider*");
        this.preemptivePathMappings.add("/secure/CommentAssignIssue*");
    }

    @Override
    public Try<Integer> getFailedLoginAttempts(Principal principal) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous(principal);
        return Try.of((CheckedFunction0 & Serializable)() -> Integer.parseInt(Objects.requireNonNull(this.getCrowdService().getUserWithAttributes(principal.getName()).getValue("login.currentFailedCount")))).onFailure(NullPointerException.class, e -> this.log.warn("Could not obtain failed login count for user " + usernameForLog, (Throwable)e)).onFailure(NumberFormatException.class, e -> this.log.debug("Failed to parse login attempts for user " + usernameForLog, (Throwable)e));
    }

    @Override
    public Try<Void> setFailedLoginAttempts(Principal principal, int count) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous(principal);
        return Try.run(() -> this.getCrowdService().setUserAttribute((User)principal, "login.currentFailedCount", String.valueOf(count))).onFailure(OperationNotPermittedException.class, e -> this.log.warn("An exception occurred while setting currentFailedCount after for user " + usernameForLog, (Throwable)e));
    }

    private boolean isRootRequest(HttpServletRequest req) {
        return req.getRequestURI().equals(req.getContextPath() + "/");
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"jira", (CharSequence)product);
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequest req) {
        return StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(req), (CharSequence)"/sr/jira.issueviews");
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return this.isPageWithLoginForm(req);
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req) {
        String requestUri = HttpUrlUtils.getInternalPath(req);
        return this.isMainLoginPage(req) || requestUri.equalsIgnoreCase("/secure/Dashboard.jspa") || requestUri.equals("/Dashboard.jspa") || requestUri.equals("/secure/MyJiraHome.jspa") || requestUri.equals("/secure/") || this.isRootRequest(req) || this.kerbConfManager.isKerberosJsmEnabled() && JiraHostApp.isJSMLoginPage(req) && !this.isServiceDeskLogout(req) || this.kerbConfManager.isUserdetailsInCommentsEnabled() && (requestUri.matches(COMMENT_REST_URL) || requestUri.startsWith(COMMENT_POST_URL));
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequest request) {
        String internalPath = HttpUrlUtils.getInternalPath(request);
        return internalPath.equals("/login.jsp") || JiraHostApp.isJSMLoginPage(internalPath);
    }

    @Override
    public boolean isServiceDeskLogout(HttpServletRequest r) {
        return JiraHostApp.isJSMLoginPage(r) && StringUtils.equals((CharSequence)r.getParameter("logout"), (CharSequence)"true") || HttpUrlUtils.getInternalPath(r).equals("/servicedesk/customer/user/logout");
    }

    private boolean isGadgetLoginRequest(HttpServletRequest req, String r) {
        return r.startsWith("/rest/gadget/") && r.endsWith("/login") && "POST".equals(req.getMethod());
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String r = HttpUrlUtils.getInternalPath(req);
        return super.isForceLoginRequestMapped(req) || r.startsWith("/issues/") || r.startsWith("/browse/") || r.startsWith("/secure/CreateIssue") || r.startsWith("/secure/QuickSearch.jspa") || r.startsWith("/secure/BrowseProjects.jspa") || r.startsWith("/secure/BulkCreateSetupPage!default.jspa") || r.startsWith("/secure/ConfigurePortalPages.jspa") || r.startsWith("/secure/ManageFilters.jspa") || r.startsWith("/sr/jira.issueviews:searchrequest-printable") || r.startsWith("/secure/StructureBoard") || r.startsWith("/plugins/servlet/jeditor_file_provider") || r.startsWith("/secure/CommentAssignIssue");
    }

    @Override
    public Option<String> getAnonymousBrowsingSettingsUrl() {
        return Option.of((Object)"/secure/admin/ViewPermissionSchemes.jspa");
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if ("POST".equals(req.getMethod()) && "/login.jsp".equals(requestPath)) {
            return true;
        }
        if (this.isGadgetLoginRequest(req, requestPath)) {
            return true;
        }
        return JiraHostApp.isJSMLoginPage(requestPath) && "POST".equals(req.getMethod());
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("os_username");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        String userAgent = Optional.ofNullable(req.getHeader("User-Agent")).orElse("");
        if ((JiraHostApp.isJSMLoginPage(r) || this.isForwardedServiceDesk(req)) && this.checkTempCookie(req, res, "krb_custport_logout") || this.isLogoutPage(req) || this.isServiceDeskLogout(req)) {
            return true;
        }
        return super.shouldLoginManually(req, res);
    }

    private boolean isForwardedServiceDesk(HttpServletRequest req) {
        String forwardedUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedUri == null) {
            return false;
        }
        return JiraHostApp.isJSMLoginPage(forwardedUri.substring(req.getContextPath().length()));
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String requestPath = HttpUrlUtils.getInternalPath(req);
        String qs = req.getQueryString();
        SanitizedLogStatement.of(qs).andThenLog(sanitizedQuery -> this.log.debug("dispatchToLogin() requestPath: '{}', qs: '{}'", (Object)requestPath, sanitizedQuery));
        this.log.debug("isKeytabConfigured: {}, isPreemptiveAuthEnabled: {}, isSendToLoginEnabled: {}, isTraditionalLoginDisabled: {}, isAnyProviderForcingReLoginAfterLogoutForJsm: {}", new Object[]{this.kerbConfManager.isKeytabConfigured(), this.kerbConfManager.isRequireLogin(), this.kerbConfManager.isForceLogin(), this.kerbConfManager.isTraditionalLoginPrevented(), this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()});
        if (requestPath.matches(COMMENT_REST_URL) || requestPath.startsWith(COMMENT_POST_URL)) {
            this.addUserdetailsInAnonymousJiraComment(chain, req, resp);
            return;
        }
        if (this.isForwarded(req) && "/login.jsp".equals(requestPath)) {
            this.log.debug("isForwarded()");
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (JiraHostApp.isJSMLoginPage(requestPath)) {
            String absolute;
            this.log.debug("isJSMServiceDesk()");
            String url = "login?nokerberos";
            String dest = req.getParameter("destination");
            if (this.isServiceDeskLogout(req)) {
                this.log.debug("isServiceDeskLogout()");
                if (!this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) {
                    url = url + "&noredirect";
                }
            }
            if (dest != null) {
                url = url + "&destination=" + HttpUrlUtils.urlEncode(dest);
            }
            if ("true".equals(absolute = req.getParameter("absolute"))) {
                url = url + "&absolute=true";
            }
            if (req.getParameter("nokerberos") != null) {
                this.log.debug("isServiceDesk() + nokerberos");
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                this.log.debug("isServiceDesk() + metaRefresh, url: '{}'", (Object)url);
                this.metaRefresh(resp, url);
            }
        } else if (!this.isForwarded(req) && requestPath.startsWith("/secure/") && !requestPath.startsWith("/secure/CreateIssue")) {
            this.log.debug("isDashboardOrJiraHome -> sendRedirect");
            resp.sendRedirect(req.getContextPath() + "/login.jsp?os_destination=" + HttpUrlUtils.urlEncode(requestPath) + "%3F" + HttpUrlUtils.urlEncode(qs));
        } else if (requestPath.equals("/")) {
            this.log.debug("is call to path /");
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else if (this.isRestApi(requestPath)) {
            this.log.debug("isRestApi()");
            chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservableHeaderAwareResponse(resp));
        } else if (JiraHostApp.shouldDispatchToLoginPage(this.kerbConfManager)) {
            this.log.debug("shouldDispatchToLoginPage()");
            String encodedQuery = HttpUrlUtils.urlEncode(qs);
            if (!"/login.jsp".equals(requestPath) && !requestPath.contains("logout%3FSAMLResponse")) {
                String queryStringPart;
                String string = queryStringPart = StringUtils.isNotBlank((CharSequence)encodedQuery) ? "%3F" + encodedQuery : "";
                if (requestPath.contains("/secure/MyJiraHome.jspa")) {
                    this.log.debug("/secure/MyJiraHome.jspa, encodedQuery: '{}'", (Object)encodedQuery);
                    resp.sendRedirect(req.getContextPath() + "/login.jsp?os_destination=" + HttpUrlUtils.urlEncode(requestPath) + queryStringPart);
                } else {
                    this.log.debug("shouldDispatchToLoginPage() + login.jsp, encodedQuery: '{}'", (Object)encodedQuery);
                    req.getRequestDispatcher("/login.jsp?os_destination=" + requestPath + queryStringPart).forward((ServletRequest)req, (ServletResponse)resp);
                }
            } else {
                this.log.debug("shouldDispatchToLoginPage() + else, encodedQuery: '{}'", (Object)encodedQuery);
                req.getRequestDispatcher("/login.jsp?" + encodedQuery).forward((ServletRequest)req, (ServletResponse)resp);
            }
        } else {
            this.log.debug("dispatchToLogin default");
            if ("/login.jsp".equals(requestPath) && StringUtils.contains((CharSequence)qs, (CharSequence)"logout%3FSAMLResponse")) {
                this.log.debug("login.jsp?os_destination={} qs: {}", (Object)requestPath, (Object)qs);
                req.getRequestDispatcher("/login.jsp?os_destination=").forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                this.log.debug("else doFilter: {}, qs: {}: ", (Object)requestPath, (Object)qs);
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String internalRequestPath = HttpUrlUtils.getInternalPath(req);
        if (JiraHostApp.isJSMLoginPage(internalRequestPath)) {
            this.preventCaching(res);
            String destination = req.getParameter("destination");
            if (destination != null) {
                String absolute = req.getParameter("absolute");
                String url = destination;
                if (!"true".equals(absolute)) {
                    url = req.getContextPath() + "/servicedesk/customer/" + url;
                }
                this.safeRedirect.sendRedirect(url, req, res, this);
            } else {
                res.sendRedirect(req.getContextPath() + "/servicedesk/customer/");
            }
        } else if (this.isRestApi(internalRequestPath)) {
            this.preventCaching(res);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            super.postSuccessfulLoginWithKerberosAction(user, req, res, chain);
        }
    }

    @Override
    public boolean shouldRequireCanLogin(HttpServletRequest req) {
        return !JiraHostApp.isJSMLoginPage(HttpUrlUtils.getInternalPath(req));
    }

    public static boolean isJSMLoginPage(HttpServletRequest req) {
        return JiraHostApp.isJSMLoginPage(HttpUrlUtils.getInternalPath(req));
    }

    public static boolean isJSMLoginPage(String requestPath) {
        return requestPath.startsWith("/servicedesk/customer/") && requestPath.endsWith("/user/login") || requestPath.equals("/servicedesk/customer/user/login");
    }

    @Override
    public String getRedirectTarget(HttpServletRequest req) {
        String destination;
        if (JiraHostApp.isJSMLoginPage(req.getRequestURI().substring(req.getContextPath().length())) && (destination = req.getParameter("destination")) != null) {
            if (StringUtils.startsWith((CharSequence)destination, (CharSequence)"/servicedesk/customer")) {
                return req.getContextPath() + destination;
            }
            return req.getContextPath() + "/servicedesk/customer/" + destination;
        }
        return super.getRedirectTarget(req);
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        if (CryptoUtils.secretIndicatesEncryptedValue(ldapPasswordParameter)) {
            String encryptorClassName = "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor";
            String componentManagerClassName = "com.atlassian.jira.component.pico.ComponentManager";
            return (String)this.decryptLdapPassword(ldapPasswordParameter, "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor", "com.atlassian.jira.component.pico.ComponentManager").getOrElse((Object)ldapPasswordParameter);
        }
        return super.optionallyDecryptLdapPassword(ldapPasswordParameter);
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        RemoteDirectory authoritativeDirectory = super.getAuthorativeDirectory(directoryInstance);
        try {
            Method getKeysMethod = authoritativeDirectory.getClass().getMethod("getKeys", new Class[0]);
            getKeysMethod.setAccessible(true);
            Method getValueMethod = authoritativeDirectory.getClass().getMethod("getValue", String.class);
            getValueMethod.setAccessible(true);
            HashMap<String, String> updatedAttributes = new HashMap<String, String>();
            for (String key : authoritativeDirectory.getKeys()) {
                String value = authoritativeDirectory.getValue(key);
                if ("ldap.password".equals(key)) {
                    value = this.optionallyDecryptLdapPassword(value);
                }
                updatedAttributes.put(key, value);
            }
            authoritativeDirectory.setAttributes(updatedAttributes);
        }
        catch (NoSuchMethodException e) {
            this.log.warn("Problem getting 'ldap.password' from RemoteDirectory");
        }
        catch (Exception e) {
            this.log.warn("Problem decrypting 'ldap.password' from RemoteDirectory");
        }
        return authoritativeDirectory;
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.seraphLikeInvalidateSession(req);
        this.publishBeforeUserAuthenticateEvent(user, req.getSession());
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)user);
        req.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        this.registerSuccessfulLoginInLoginStore(user);
        return user;
    }

    private void publishBeforeUserAuthenticateEvent(Principal user, HttpSession session) {
        if (this.hasBeforeUserAuthenticateSupport()) {
            try {
                if (this.beforeUserAuthenticateClass != null) {
                    Constructor<?>[] cons = this.beforeUserAuthenticateClass.getConstructors();
                    Object o = cons[0].newInstance(user.getName());
                    this.eventPublisher.publish(o);
                } else {
                    this.log.warn("Could not load beforeUserAuthenticateClass");
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to publish BeforeUserAuthenticate event during Jira login", (Throwable)e);
            }
        }
    }

    private void registerSuccessfulLoginInLoginStore(Principal user) {
        if (this.recordLoginMethod != null && this.loginComponent != null) {
            try {
                Object applicationUser = this.useApplicationUser && this.fromUser != null ? this.fromUser.invoke(null, user) : user;
                this.recordLoginMethod.invoke(this.loginComponent, applicationUser, true);
            }
            catch (Exception e) {
                this.log.warn("Failed invoking JIRA LoginStore.recordLoginAttempt with the following exception {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.jira.security.login.JiraSeraphAuthenticator";
    }

    @Override
    public String getUserManagerLink() {
        return "/secure/admin/user/UserBrowser.jspa";
    }

    @Override
    public String getLoginPage() {
        return "/login.jsp";
    }

    public static String getDashboardLoginPage() {
        return "/secure/Dashboard.jspa";
    }

    @Override
    public String getLogoutPage() {
        return "/secure/Logout!default.jspa";
    }

    @Override
    public boolean isLogoutPage(HttpServletRequest req) {
        String requestPath = HttpUrlUtils.getInternalPath(req);
        String requestPage = HttpUrlUtils.stripQueryStringFromInternalPath(requestPath).replaceAll("!default", "");
        return this.getLogoutPage().replaceAll("!default", "").equalsIgnoreCase(requestPage) || this.isServiceDeskLogout(req);
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5501;
    }

    @Override
    public boolean isJiraCrowdRequest(HttpServletRequest req) {
        String internalPath = HttpUrlUtils.getInternalPath(req);
        String authHeader = req.getHeader("Authorization");
        boolean isJiraCrowdAuth = StringUtils.startsWith((CharSequence)authHeader, (CharSequence)"Basic ") && !StringUtils.contains((CharSequence)authHeader, (CharSequence)":");
        return isJiraCrowdAuth && (Boolean)Option.of((Object)internalPath).map(path -> path.startsWith("/rest/usermanagement/1/")).getOrElse((Object)false) != false;
    }

    @Override
    public Map<String, String> mapNameToExternalId(java.util.List<User> userBatch, Map<String, String> userData) {
        userBatch.forEach(user -> userData.put(user.getName(), ((OfBizUser)user).getExternalId()));
        return userData;
    }

    @Override
    public String getLicenseEndpoint() {
        return "/rest/plugins/1.0/no.kantega.kerberosauth.kerberosauth-plugin-key/license";
    }

    @Override
    public void setRememberMeCookie(HttpServletRequest request, HttpServletResponse response, String username) {
        RemembermeUtils.setRememberMeCookie(request, response, username);
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("login.lastLoginMillis");
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("jira-administrators"))) {
            return "jira-administrators";
        }
        return null;
    }

    @Override
    public boolean shouldCheckUserAccess() {
        return true;
    }

    public boolean hasBeforeUserAuthenticateSupport() {
        Version version = new Version(this.applicationProperties.getVersion());
        boolean isJiraVersion8 = (Boolean)version.getMajor().map(m -> m == 8).getOrElse((Object)false);
        boolean isJiraHigherThan8 = (Boolean)version.getMajor().map(m -> m > 8).getOrElse((Object)false);
        boolean isJiraMinor22OrHigher = (Boolean)version.getMinor().map(m -> m >= 22).getOrElse((Object)false);
        return isJiraHigherThan8 || isJiraVersion8 && isJiraMinor22OrHigher;
    }

    @Override
    public boolean isSyncDirCompatible() {
        Version version = new Version(this.applicationProperties.getVersion());
        boolean isJiraVersionLowerThan8 = (Boolean)version.getMajor().map(m -> m < 8).getOrElse((Object)false);
        boolean isJiraVersion8 = (Boolean)version.getMajor().map(m -> m == 8).getOrElse((Object)false);
        boolean isJiraHigherThan8 = (Boolean)version.getMajor().map(m -> m > 8).getOrElse((Object)false);
        boolean isJiraMinorLowerThan14 = (Boolean)version.getMinor().map(m -> m < 14).getOrElse((Object)false);
        boolean isJiraMinor15OrHigher = (Boolean)version.getMinor().map(m -> m >= 15).getOrElse((Object)false);
        return isJiraVersionLowerThan8 || isJiraHigherThan8 || isJiraVersion8 && isJiraMinorLowerThan14 || isJiraVersion8 && isJiraMinor15OrHigher;
    }

    private boolean addUserdetailsInAnonymousJiraComment(FilterChain chain, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.kerbConfManager.isUserdetailsInCommentsEnabled()) {
            String userdetails = (String)req.getAttribute("usernameAnonymousUser");
            if (userdetails != null) {
                User user = this.crowdService.getUser(userdetails);
                if (user != null) {
                    userdetails = "[" + user.getDisplayName() + "|mailto:" + user.getEmailAddress() + "]";
                }
                this.log.debug("Adding user details to anonymous comment: " + userdetails);
            }
            req.getSession().removeAttribute("lockout_timestamp");
            chain.doFilter((ServletRequest)new UserdetailsInCommentRequestWrapper(req, userdetails, HttpUrlUtils.getInternalPath(req).matches(COMMENT_REST_URL)), (ServletResponse)new StatusPreservableHeaderAwareResponse(res));
            return true;
        }
        return false;
    }

    @Override
    public List<String> getUserProfileKeys() {
        return List.empty();
    }

    @Override
    public void setUserProfileValue(String username, String key, String value) {
    }

    @Override
    public String getUserProfileValue(String username, String key) {
        return "";
    }

    @Override
    public Map<String, String> getUsersProfilePicture(java.util.List<User> users) {
        HashMap<String, String> usernameAvatarUriMap = new HashMap<String, String>();
        for (User u : users) {
            ApplicationUser aUser = this.userManager.getUserByName(u.getName());
            String avatarUri = null;
            try {
                avatarUri = this.avatarServiceImpl.getAvatarUrlNoPermCheck(aUser, null).toString();
            }
            catch (AvatarsDisabledException avatarsDisabledException) {
                // empty catch block
            }
            usernameAvatarUriMap.put(u.getName(), avatarUri);
        }
        return usernameAvatarUriMap;
    }

    @Override
    public void setUserProfilePicture(String userName, String fileExtension, byte[] imageBytes, Path avatarDirPath) {
        String contentType = "image/" + fileExtension;
        String filename = userName.trim() + "." + fileExtension;
        IconType iconType = IconType.USER_ICON_TYPE;
        File outputFile = new File(Paths.get(avatarDirPath.toString(), filename).toString());
        ApplicationUser appUser = this.userManager.getUserByName(userName);
        if (appUser == null) {
            return;
        }
        try {
            IconOwningObjectId owner = new IconOwningObjectId(appUser.getKey());
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageBytes));
            ImageIO.write((RenderedImage)img, fileExtension, outputFile);
            BufferedInputStream iStream = new BufferedInputStream(Files.newInputStream(outputFile.toPath(), new OpenOption[0]));
            Avatar avatar = this.avatarManager.create(filename, contentType, iconType, owner, (InputStream)iStream, null);
            Method setAvatarMethod = this.avatarService.getClass().getDeclaredMethod("setConfiguredAvatarIdFor", ApplicationUser.class, Long.class);
            setAvatarMethod.setAccessible(true);
            setAvatarMethod.invoke((Object)this.avatarService, appUser, avatar.getId());
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequest request) {
        return super.isRestPathInternalAtlassianFunctionality(request) || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/api/2/field") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/remote-link-aggregation") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/remote-event-consumer") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/gadgets");
    }

    @Override
    public boolean shouldEnableHardRedirect(HttpServletRequest req) {
        if (this.idpConfManager == null) {
            return super.shouldEnableHardRedirect(req);
        }
        String internalPath = HttpUrlUtils.getInternalPath(req);
        boolean anyJsmUsingInstant = false;
        Iterator<IdpConfiguration> idps = this.idpConfManager.getIdentityProviders().iterator();
        while (idps.hasNext() && !anyJsmUsingInstant) {
            IdpConfiguration idp = idps.next();
            if (!idp.isEnabled()) continue;
            IdpConfiguration.RedirectPolicy redirectPolicy = idp.getJsmRedirectProperties().getRedirectPolicy();
            if (this.isServiceDeskLogout(req)) {
                anyJsmUsingInstant = redirectPolicy == IdpConfiguration.RedirectPolicy.HARD && idp.isSsoAfterLogout();
                continue;
            }
            anyJsmUsingInstant = redirectPolicy == IdpConfiguration.RedirectPolicy.HARD;
        }
        boolean shouldEnableRedirectForJsm = super.shouldEnableHardRedirect(req) && this.idpConfManager.isLoginEnabledForJSM() && anyJsmUsingInstant;
        this.log.debug("shouldEnableInstantRedirectForJsm: {}", (Object)shouldEnableRedirectForJsm);
        if (JiraHostApp.isJSMLoginPage(req)) {
            return shouldEnableRedirectForJsm;
        }
        return super.shouldEnableHardRedirect(req);
    }

    @Override
    public IdpConfiguration getInstantRedirectProvider(HttpServletRequest req, HttpServletResponse resp, SSOScriptLoginHookCondition loginScriptCondition) {
        java.util.List<IdpConfiguration> jsmHardRedirectIdps;
        if (JiraHostApp.isJSMLoginPage(req) && this.shouldEnableHardRedirect(req) && (!this.shouldLoginManually(req, resp) || this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) && (jsmHardRedirectIdps = this.idpConfManager.getProvidersByJsmRedirectPolicy(IdpConfiguration.RedirectPolicy.HARD)).size() == 1) {
            return jsmHardRedirectIdps.get(0);
        }
        return super.getInstantRedirectProvider(req, resp, loginScriptCondition);
    }

    @Override
    public boolean sendToDashboardAfterLogin() {
        return this.kerbConfManager.isSendToDashboardAfterLogin();
    }

    public static class CanUseStatus {
        private final ApplicationUser user;
        private boolean hasGlobalAdminPermission;
        private boolean hasAnyRole;

        public CanUseStatus(String username) {
            this.user = this.createApplicationUser(username);
        }

        @NotNull
        private ApplicationUser createApplicationUser(final String userName) {
            return new ApplicationUser(){

                public String getKey() {
                    return userName;
                }

                public String getUsername() {
                    return userName;
                }

                public String getName() {
                    return userName;
                }

                public long getDirectoryId() {
                    return 0L;
                }

                public boolean isActive() {
                    return true;
                }

                public String getEmailAddress() {
                    return null;
                }

                public String getDisplayName() {
                    return null;
                }

                public User getDirectoryUser() {
                    return null;
                }

                public Long getId() {
                    return null;
                }
            };
        }

        public boolean hasGlobalAdminPermission() {
            return this.hasGlobalAdminPermission;
        }

        public boolean hasAnyRole() {
            return this.hasAnyRole;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CanUseStatus invoke() {
            Thread ct = Thread.currentThread();
            ClassLoader oldCcl = ct.getContextClassLoader();
            try {
                GlobalPermissionManager globalPermissionManager = (GlobalPermissionManager)ComponentLocator.getComponent(GlobalPermissionManager.class);
                ct.setContextClassLoader(GlobalPermissionManager.class.getClassLoader());
                this.hasGlobalAdminPermission = globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.user);
                ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
                this.hasAnyRole = applicationRoleManager.hasAnyRole(this.user);
            }
            finally {
                ct.setContextClassLoader(oldCcl);
            }
            return this;
        }
    }
}

