/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.AuthorizationUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasKerberosPreFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KerbConfManager kerbConfManager;
    private final ApiTokenService apiTokenService;
    private String[] products;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final AuditLogFacade auditLogFacade;
    public static final String ALLOW_BASIC_AUTH_ATTR = "ksso.allowed.basic.auth";

    @Inject
    public AtlasKerberosPreFilter(KerbConfManager kerbConfManager, ApiTokenService apiTokenService, HostAppFactory hostAppFactory, UserLookupService userLookupService, AuditLogFacade auditLogFacade) {
        this.kerbConfManager = kerbConfManager;
        this.apiTokenService = apiTokenService;
        this.hostApp = hostAppFactory.getInstance();
        this.userLookupService = userLookupService;
        this.auditLogFacade = auditLogFacade;
    }

    public void doFilter(ServletRequest filterRequest, ServletResponse filterResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)filterRequest;
        HttpServletResponse res = (HttpServletResponse)filterResponse;
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        String username = (String)HttpUrlUtils.extractUsernameFromBasicAuthHeader(req).getOrElse((Object)"anonymous");
        if (!this.isProductMatch()) {
            chain.doFilter(filterRequest, filterResponse);
            return;
        }
        if (this.hostApp.isScimRequest(req)) {
            chain.doFilter((ServletRequest)this.wrapScimAuthHeader(req), (ServletResponse)res);
            this.log.debug("Request to SCIM server. Avoid normal login");
            return;
        }
        this.log.debug("isBasicAuthPrevented -> {}", (Object)this.kerbConfManager.isBasicAuthPrevented());
        IpRestrictionFilter basicAuthIpRestrictionFilter = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthFilter();
        if (AuthorizationUtil.isBasicAuth(req) && this.kerbConfManager.isBasicAuthPrevented() && !this.apiTokenService.requestHasApiToken(req) && !this.hostApp.isJiraCrowdRequest(req)) {
            this.log.debug("isRemoteAddressEnabledForBasicAuth -> {}", (Object)basicAuthIpRestrictionFilter.isRemoteAddressEnabled(remoteIpAddress));
            this.log.debug("requestHasApiToken -> {}", (Object)this.apiTokenService.requestHasApiToken(req));
            this.log.debug("isJiraCrowdRequest -> {}", (Object)this.hostApp.isJiraCrowdRequest(req));
            if (!basicAuthIpRestrictionFilter.isRemoteAddressEnabled(remoteIpAddress)) {
                this.auditLogFacade.loginFailed(username, "Basic Auth", "Basic Auth disabled for user with IP " + remoteIpAddress);
                this.log.debug("Blocking BasicAuth authentication request for IP " + remoteIpAddress);
            } else {
                boolean userInAllowedDirectoryOrGroup;
                boolean isUserHasAccess = this.userLookupService.hasUserAccess(req);
                this.log.debug("userLookupService.isUserHasAccess -> " + isUserHasAccess);
                List<Object> dirsAllowing = new ArrayList();
                this.log.debug("Searching for user directories for user access in traditional login");
                try {
                    dirsAllowing = this.userLookupService.getCachedDirectoriesAllowingBasicAuth();
                }
                catch (RuntimeException e) {
                    this.log.warn("Not able to search for directories checking Basic Auth exceptions: " + e.getMessage());
                }
                Set<String> allowGroups = this.kerbConfManager.getAllowBasicAuthGroups();
                Set<String> disAllowGroups = this.kerbConfManager.getDisallowBasicAuthGroups();
                if (!(dirsAllowing.isEmpty() && allowGroups.isEmpty() && disAllowGroups.isEmpty() || !(userInAllowedDirectoryOrGroup = this.userLookupService.isUserInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, allowGroups, disAllowGroups, (String)HttpUrlUtils.getUsernameFromBasicAuthHeader(req).getOrElse((Object)"anonymous"), AuthMethod.BASIC_AUTH)))) {
                    this.log.debug("User directory or group exception to Basic Auth restriction.");
                    req.setAttribute(ALLOW_BASIC_AUTH_ATTR, (Object)true);
                    chain.doFilter(filterRequest, filterResponse);
                    return;
                }
            }
            res.sendError(403, "HTTP Basic Auth has been disabled by the Administrator");
            return;
        }
        this.log.debug("isTraditionalLoginPrevented() -> {}", (Object)this.kerbConfManager.isTraditionalLoginPrevented());
        if ((this.kerbConfManager.isTraditionalLoginPrevented() || this.kerbConfManager.isTraditionalLoginJsmPrevented()) && this.hostApp.isPasswordLoginRequest(req)) {
            boolean isUserHasAccess = this.userLookupService.hasUserAccess(req);
            this.log.debug("userLookupService.isUserHasAccess -> " + isUserHasAccess);
            if (this.kerbConfManager.isTraditionalLoginPrevented()) {
                List<Object> dirsAllowing = new ArrayList();
                this.log.debug("Searching for user directories for user access in traditional login");
                try {
                    dirsAllowing = this.userLookupService.getCachedDirectoriesAllowingTraditionalLogin();
                }
                catch (RuntimeException e) {
                    this.log.warn("Not able to search for directories: " + e.getMessage());
                }
                if (dirsAllowing.size() > 0 || this.kerbConfManager.getAllowTraditionalLoginGroups().size() > 0 || this.kerbConfManager.getDisallowTraditionalLoginGroups().size() > 0) {
                    boolean userInAllowedDirectoryOrGroup = this.userLookupService.isUserInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, this.kerbConfManager.getAllowTraditionalLoginGroups(), this.kerbConfManager.getDisallowTraditionalLoginGroups(), this.hostApp.getLoginRequestUsername(req), AuthMethod.LOCAL_LOGIN);
                    if (this.kerbConfManager.isTraditionalLoginPrevented() && isUserHasAccess && userInAllowedDirectoryOrGroup) {
                        this.log.debug("Standard user directory or group exception to disabled traditional login for users with rights");
                        chain.doFilter(filterRequest, filterResponse);
                    } else if (!(this.kerbConfManager.isTraditionalLoginJsmPrevented() && !userInAllowedDirectoryOrGroup || isUserHasAccess)) {
                        this.log.debug("Allowing user with JSM user directory or group exception to disabled traditional login");
                        chain.doFilter(filterRequest, filterResponse);
                    } else {
                        this.auditLogFacade.loginFailed(username, "Traditional Username/Password login", "No group or user directory for exception to disabled username/password login.");
                        this.log.debug("Blocking request to use username/password because group / user directory is not allowed.");
                        this.renderTraditionalLoginErrorPage(req, res);
                    }
                } else if (JiraHostApp.isJSMLoginPage(req)) {
                    if (isUserHasAccess) {
                        this.auditLogFacade.loginFailed(username, "JSM Username/password login for licensed user", "Blocking request giving incorrect password because no rights to use passwords with roles");
                        this.log.debug("Blocking request giving incorrect password because no rights to use passwords with roles");
                        this.sendJsmErrorBody(res);
                    } else if (this.kerbConfManager.isTraditionalLoginJsmPrevented()) {
                        this.auditLogFacade.loginFailed(username, "JSM Username/password login unlicensed", "Blocking request JSM giving incorrect password");
                        this.log.debug("Blocking request to JSM giving incorrect password on unlicensed user");
                        this.sendJsmErrorBody(res);
                    } else {
                        chain.doFilter(filterRequest, filterResponse);
                    }
                } else {
                    this.auditLogFacade.loginFailed(username, "Traditional Username/Password login", "Traditional login disabled. Blocking passwords.");
                    this.log.debug("Blocking request containing traditional username/password parameter");
                    res.sendError(403, "Username and password authentication has been disabled.");
                }
            } else if (this.kerbConfManager.isTraditionalLoginJsmPrevented()) {
                if (!isUserHasAccess) {
                    this.auditLogFacade.loginFailed(username, "JSM Username/password login unlicensed user", "Blocking request JSM giving incorrect password");
                    this.log.debug("Blocking request to JSM giving incorrect password on unlicensed user");
                    this.sendJsmErrorBody(res);
                } else {
                    chain.doFilter(filterRequest, filterResponse);
                }
            }
        } else {
            chain.doFilter(filterRequest, filterResponse);
        }
    }

    private void sendJsmErrorBody(HttpServletResponse res) throws IOException {
        res.setContentType("application/json");
        res.getWriter().print("{\"loginSucceeded\":false,\"loginError\":false,\"communicationError\":false,\"elevatedSecurityCheckShown\":false,\"captchaFailure\":false,\"loginFailedByPermissions\":false,\"passwordResetRequired\":false}");
    }

    private void renderTraditionalLoginErrorPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String errorMessage = this.kerbConfManager.getTraditionalLoginDisabledMessage();
        if (StringUtils.contains((String)this.kerbConfManager.getTraditionalLoginDisabledMessage(), (String)"%s%s")) {
            errorMessage = String.format(this.kerbConfManager.getTraditionalLoginDisabledMessage(), req.getContextPath(), this.hostApp.getLoginPage());
        }
        res.setContentType("text/html");
        res.getWriter().print(errorMessage);
    }

    private void renderTraditionalLoginErrorPageAndSendError(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String errorMessage = this.kerbConfManager.getTraditionalLoginDisabledMessage();
        if (StringUtils.contains((String)this.kerbConfManager.getTraditionalLoginDisabledMessage(), (String)"%s%s")) {
            errorMessage = String.format(this.kerbConfManager.getTraditionalLoginDisabledMessage(), req.getContextPath(), this.hostApp.getLoginPage());
        }
        res.setContentType("text/html");
        res.getWriter().print(errorMessage);
    }

    public void destroy() {
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    private HttpServletRequest wrapScimAuthHeader(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){
            private Set<String> headerNameSet;

            public Enumeration<String> getHeaderNames() {
                if (this.headerNameSet == null) {
                    this.headerNameSet = new HashSet<String>();
                    Enumeration wrappedHeaderNames = super.getHeaderNames();
                    while (wrappedHeaderNames.hasMoreElements()) {
                        String headerName = (String)wrappedHeaderNames.nextElement();
                        if ("Authorization".equalsIgnoreCase(headerName)) {
                            this.headerNameSet.add("ScimAuthorization");
                            continue;
                        }
                        this.headerNameSet.add(headerName);
                    }
                }
                return Collections.enumeration(this.headerNameSet);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return Collections.emptyEnumeration();
                }
                if ("ScimAuthorization".equalsIgnoreCase(name)) {
                    return super.getHeaders("Authorization");
                }
                return super.getHeaders(name);
            }

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return null;
                }
                if ("ScimAuthorization".equalsIgnoreCase(name)) {
                    return super.getHeader("Authorization");
                }
                return super.getHeader(name);
            }
        };
    }
}

