/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import io.vavr.control.Option;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.utils.ListParseUtils;

public class IpRestrictionConfig {
    private final String[] customDisabledUserAgents;
    private final KerbConfManager.IpRestrictionType globalRestrictionType;
    private String[] oldGlobalIpBlockedlist;
    private String[] oldGlobalIpUnblockedlist;
    private final String[] globalIpBlockedlist;
    private final String[] globalIpUnblockedlist;
    private final IpRestrictionFilter globalFilter;
    private final KerbConfManager.IpRestrictionType restRestrictionType;
    private String[] oldRestIpBlockedlist;
    private String[] oldRestIpUnblockedlist;
    private final String[] restIpBlockedlist;
    private final String[] restIpUnblockedlist;
    private final IpRestrictionFilter restFilter;
    private final KerbConfManager.IpRestrictionType apiTokenRestrictionType;
    private String[] oldApiTokenIpBlockedList;
    private String[] oldApiTokenIpUnblockedList;
    private final String[] apiTokenIpBlockedList;
    private final String[] apiTokenIpUnblockedList;
    private final IpRestrictionFilter apiTokenFilter;
    private final KerbConfManager.IpRestrictionType basicAuthIpRestrictionType;
    private final String[] basicAuthIpBlockedList;
    private final String[] basicAuthIpUnblockedList;
    private final IpRestrictionFilter basicAuthFilter;

    public IpRestrictionConfig(PluginSettings settings) {
        this.customDisabledUserAgents = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.CUSTOM_DISABLED_USER_AGENTS.key));
        this.globalRestrictionType = (KerbConfManager.IpRestrictionType)((Object)Option.of((Object)((String)settings.get(KerbConfManager.KEYS.GLOBAL_IP_RESTRICTION_TYPE.key))).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).getOrElse((Object)KerbConfManager.IpRestrictionType.UNRESTRICTED));
        this.globalIpBlockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST.key));
        this.globalIpUnblockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST.key));
        this.globalFilter = new IpRestrictionFilter(this.globalIpUnblockedlist, this.globalIpBlockedlist, this.globalRestrictionType);
        this.restRestrictionType = (KerbConfManager.IpRestrictionType)((Object)Option.of((Object)((String)settings.get(KerbConfManager.KEYS.REST_IP_RESTRICTION_TYPE.key))).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).getOrElse((Object)KerbConfManager.IpRestrictionType.UNRESTRICTED));
        this.restIpBlockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.REST_IP_BLOCKEDLIST.key));
        this.restIpUnblockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST.key));
        this.restFilter = new IpRestrictionFilter.InheritingFilter(this.restIpUnblockedlist, this.restIpBlockedlist, this.restRestrictionType, this.globalFilter);
        this.apiTokenRestrictionType = (KerbConfManager.IpRestrictionType)((Object)Option.of((Object)((String)settings.get(KerbConfManager.KEYS.API_TOKEN_IP_RESTRICTION_TYPE.key))).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).getOrElse((Object)KerbConfManager.IpRestrictionType.UNRESTRICTED));
        this.apiTokenIpBlockedList = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST.key));
        this.apiTokenIpUnblockedList = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST.key));
        this.apiTokenFilter = new IpRestrictionFilter(this.apiTokenIpUnblockedList, this.apiTokenIpBlockedList, this.apiTokenRestrictionType);
        this.basicAuthIpRestrictionType = (KerbConfManager.IpRestrictionType)((Object)Option.of((Object)((String)settings.get(KerbConfManager.KEYS.BASIC_AUTH_IP_RESTRICTION_TYPE.key))).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).getOrElse((Object)KerbConfManager.IpRestrictionType.UNBLOCKEDLIST));
        this.basicAuthIpBlockedList = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST.key));
        this.basicAuthIpUnblockedList = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST.key));
        this.basicAuthFilter = new IpRestrictionFilter(this.basicAuthIpUnblockedList, this.basicAuthIpBlockedList, this.basicAuthIpRestrictionType);
    }

    public String[] getCustomDisabledUserAgents() {
        return this.customDisabledUserAgents;
    }

    public IpRestrictionFilter getGlobalIpFilter() {
        return this.globalFilter;
    }

    public String[] getGlobalIpBlockedList() {
        return this.globalIpBlockedlist;
    }

    public String[] getGlobalIpUnblockedList() {
        return this.globalIpUnblockedlist;
    }

    public KerbConfManager.IpRestrictionType getGlobalRestrictionType() {
        return this.globalRestrictionType;
    }

    public IpRestrictionFilter getRestIpFilter() {
        return this.restFilter;
    }

    public KerbConfManager.IpRestrictionType getRestRestrictionType() {
        return this.restRestrictionType;
    }

    public String[] getRestIpBlockedList() {
        return this.restIpBlockedlist;
    }

    public String[] getRestIpUnblockedList() {
        return this.restIpUnblockedlist;
    }

    public KerbConfManager.IpRestrictionType getApiTokenRestrictionType() {
        return this.apiTokenRestrictionType;
    }

    public String[] getApiTokenIpBlockedList() {
        return this.apiTokenIpBlockedList;
    }

    public String[] getApiTokenIpUnblockedList() {
        return this.apiTokenIpUnblockedList;
    }

    public IpRestrictionFilter getApiTokenFilter() {
        return this.apiTokenFilter;
    }

    public KerbConfManager.IpRestrictionType getBasicAuthIpRestrictionType() {
        return this.basicAuthIpRestrictionType;
    }

    public String[] getBasicAuthIpBlockedList() {
        return this.basicAuthIpBlockedList;
    }

    public String[] getBasicAuthIpUnblockedList() {
        return this.basicAuthIpUnblockedList;
    }

    public IpRestrictionFilter getBasicAuthFilter() {
        return this.basicAuthFilter;
    }
}

