/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.google.common.collect.Lists;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.collection.CharSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;

public final class ListParseUtils {
    private static final Function2<String, KssoStringUtils.StringLiteral, Seq<CharSeq>> parseFromStringWithSeparator = (Function2 & Serializable)(separatedString, separator) -> ((Seq)Option.of((Object)separatedString).filter(StringUtils::isNotBlank).map(CharSeq::of).map(cs -> cs.split(separator.value)).getOrElse((Object)List.empty())).map(CharSeq::trim).filter(cs -> !cs.isEmpty());
    private static final Function1<String, Seq<CharSeq>> parseFromCommaSeparated = (Function1 & Serializable)commaSeparated -> ListParseUtils.parseFromStringWithSeparator(commaSeparated, KssoStringUtils.StringLiteral.COMMA);
    private static final Function1<String, Set<String>> parseSetFromCommaSeparated = parseFromCommaSeparated.andThen(seq -> seq.map(CharSeq::toString).toJavaSet());
    private static final Function1<String, String[]> parseArrayFromCommaSeparated = parseFromCommaSeparated.andThen(seq -> seq.map(CharSeq::toString).toJavaList().toArray(new String[0]));
    private static final Function1<String, java.util.List<String>> parseListFromCommaSeparated = parseSetFromCommaSeparated.andThen(Lists::newArrayList);
    private static final Function1<String, Seq<CharSeq>> parseFromNewlines = (Function1 & Serializable)lineSeparated -> (Seq)parseFromStringWithSeparator.apply(lineSeparated, (Object)KssoStringUtils.StringLiteral.LINE_SEPARATOR_LOOKUP);
    public static final Function1<String, Set<String>> parseSetFromNewlines = parseFromNewlines.andThen(seq -> seq.map(CharSeq::toString).toJavaSet());
    private static final Function1<String, String[]> parseArrayFromNewlines = parseFromNewlines.andThen(seq -> seq.map(CharSeq::toString).toJavaList().toArray(new String[0]));
    private static final Function2<List<String>, KssoStringUtils.StringLiteral, String> listToSeparatedString = (Function2 & Serializable)(items, separator) -> ((String)items.map(String::trim).intersperse((Object)separator.value).foldLeft((Object)"", String::concat)).trim();
    private static final Function1<String[], String> arrayToStringWithNewlines = (Function1 & Serializable)array -> (String)listToSeparatedString.apply((Object)List.of((Object[])array), (Object)KssoStringUtils.StringLiteral.NEW_LINE_SEPARATOR);
    private static final Function1<Iterable<String>, String> iterableToCommaSeparatedString = (Function1 & Serializable)iterable -> (String)Option.of((Object)iterable).map(itr -> (String)listToSeparatedString.apply((Object)List.ofAll((Iterable)itr), (Object)KssoStringUtils.StringLiteral.COMMA)).getOrElse((Object)"");
    private static final Function1<Iterable<String>, String> iterableToCommaSeparatedAndSpacedString = (Function1 & Serializable)iterable -> (String)Option.of((Object)iterable).map(itr -> (String)listToSeparatedString.apply((Object)List.ofAll((Iterable)itr), (Object)KssoStringUtils.StringLiteral.COMMA_AND_SPACE)).getOrElse((Object)"");

    public static boolean isListIntersection(List<String> oneList, List<String> otherList) {
        return oneList.exists(oneElement -> List.ofAll((Iterable)otherList).exists(otherElement -> oneElement.equals(otherElement)));
    }

    public static Seq<CharSeq> parseFromStringWithSeparator(String separatedString, KssoStringUtils.StringLiteral separator) {
        return (Seq)parseFromStringWithSeparator.apply((Object)separatedString, (Object)separator);
    }

    public static Seq<CharSeq> parseFromCommaSeparated(String commaSeparated) {
        return (Seq)parseFromCommaSeparated.apply((Object)commaSeparated);
    }

    public static Set<String> parseSetFromCommaSeparated(String commaSeparated) {
        return (Set)parseSetFromCommaSeparated.apply((Object)commaSeparated);
    }

    public static String[] parseArrayFromCommaSeparated(String commaSeparated) {
        return (String[])parseArrayFromCommaSeparated.apply((Object)commaSeparated);
    }

    public static java.util.List<String> parseListFromCommaSeparated(String commaSeparated) {
        return (java.util.List)parseListFromCommaSeparated.apply((Object)commaSeparated);
    }

    public static Seq<CharSeq> parseFromNewlines(String lineSeparated) {
        return (Seq)parseFromNewlines.apply((Object)lineSeparated);
    }

    public static Set<String> parseSetFromNewlines(String newlineseparated) {
        return (Set)parseSetFromNewlines.apply((Object)newlineseparated);
    }

    public static List<String> parseListFromNewlines(String newLines) {
        return (List)parseFromNewlines.andThen(seq -> seq.map(CharSeq::toString).toList()).apply((Object)newLines);
    }

    public static String[] parseArrayFromNewlines(String newlines) {
        return (String[])parseArrayFromNewlines.apply((Object)newlines);
    }

    public static String listToSeparatedString(List<String> items, KssoStringUtils.StringLiteral separator) {
        return (String)listToSeparatedString.apply(items, (Object)separator);
    }

    public static String listToStringWithNewlines(List<String> items) {
        return (String)listToSeparatedString.apply(items, (Object)KssoStringUtils.StringLiteral.NEW_LINE_SEPARATOR);
    }

    public static String arrayToStringWithNewlines(String[] items) {
        return (String)arrayToStringWithNewlines.apply((Object)items);
    }

    public static String iterableToCommaSeparatedString(Iterable<String> iterable) {
        return (String)Option.of(iterable).map(iterableToCommaSeparatedString).getOrElse((Object)"");
    }

    public static String iterableToCommaSeparatedAndSpacedString(Iterable<String> iterable) {
        return (String)iterableToCommaSeparatedAndSpacedString.apply(iterable);
    }
}

