/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class JsonWrapper {
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).addModule((Module)new ParameterNamesModule())).addModule((Module)new AfterburnerModule())).build();
    private final ObjectWriter objectWriter = this.objectMapper.writer();
    private final ObjectReader objectReader = this.objectMapper.reader();

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectReader objectReader() {
        return this.objectReader;
    }

    public ObjectWriter objectWriter() {
        return this.objectWriter;
    }

    public <T> T readJavaObjectFromJson(String json, Class<T> clazz) throws IOException {
        return (T)this.objectReader.readValue(json, clazz);
    }

    public <T> Try<? extends T> tryReadJavaObjectFromJson(String json, Class<T> clazz) {
        return Option.of((Object)json).toTry().mapTry((CheckedFunction1 & Serializable)nullSafeJson -> this.objectReader.readValue(nullSafeJson, clazz));
    }

    public String buildJsonString(Object object) throws JsonProcessingException {
        return this.objectWriter.writeValueAsString(object);
    }

    public Try<String> tryBuildJsonString(Object object) {
        return Option.of((Object)object).toTry().mapTry(arg_0 -> ((ObjectWriter)this.objectWriter).writeValueAsString(arg_0));
    }
}

