/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.update.data.UpdateMessage;
import org.kantega.atlaskerb.update.data.UpdatePluginSettingsEntryResult;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.PageNameUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KssoUpdateManager {
    private static final Logger log = LoggerFactory.getLogger(KssoUpdateManager.class);
    private final KerbConfManager kerbConfManager;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final IdpConfManager idpConfManager;
    private final BackupService backupService;
    private final GlobalConfigUpdate globalConfigUpdate;
    private final IdpConfigurationUpdate idpConfigurationUpdate;
    private final ActiveObjectsUpdate activeObjectsSettingsUpdate;

    @Inject
    public KssoUpdateManager(KerbConfManager kerbConfManager, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, IdpConfManager idpConfManager, BackupService backupService, UserLookupService userLookupService, HostAppFactory hostAppFactory) {
        this.kerbConfManager = kerbConfManager;
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.idpConfManager = idpConfManager;
        this.globalConfigUpdate = new GlobalConfigUpdate(kerbConfManager, userLookupService, hostAppFactory);
        this.idpConfigurationUpdate = new IdpConfigurationUpdate(idpConfManager, kerbConfManager);
        this.activeObjectsSettingsUpdate = new ActiveObjectsUpdate(apiTokenService, tokenEndpointService);
        this.backupService = backupService;
    }

    public io.vavr.collection.List<UpdateMessage> doUpdate() {
        log.info("Running update routine of Kantega SSO Enterprise.");
        try {
            if (!this.isKssoConfigUpdateNeeded()) {
                log.info("Config already up to date. Skipping update.");
                return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.SUCCESS, "Configuration is already up to date."));
            }
            log.info("Version change indicates update of Kantega SSO Enterprise needed.");
            boolean isBackupSuccess = this.saveBackupOfConfig();
            if (!isBackupSuccess) {
                return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.FAILURE, "Failed to take a backup of config. Update was aborted."));
            }
            io.vavr.collection.List updateMessages = this.globalConfigUpdate.run().appendAll(this.activeObjectsSettingsUpdate.run()).appendAll(this.idpConfigurationUpdate.run());
            if (updateMessages.forAll(UpdateMessage::isSuccess)) {
                log.info("Successful update of Kantega SSO Enterprise. Updating version in config.");
                try {
                    this.kerbConfManager.updateKssoVersionInConfig();
                    return updateMessages.append((Object)new UpdateMessage(ResultCode.SUCCESS, "Updated version in config"));
                }
                catch (Exception e) {
                    log.error("Encountered an error while updating the version of config.");
                    return updateMessages.append((Object)new UpdateMessage(ResultCode.VERSION_CHANGE_FAILURE, "Could not update the configuration version. Please re-try to confirm the update."));
                }
            }
            log.warn("Failed to update some settings during configuration update of Kantega SSO Enterprise:");
            log.info("Successful updates: " + (String)updateMessages.filter(UpdateMessage::isSuccess).map(UpdateMessage::toString).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            log.warn("Failed updates: " + (String)updateMessages.filter(UpdateMessage::isFailure).map(UpdateMessage::toString).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            return updateMessages;
        }
        catch (Exception e) {
            String msg = "Encountered an error during configuration update of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong.";
            log.error("Encountered an error during configuration update of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong.", (Throwable)e);
            return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.FAILURE, "Encountered an error during configuration update of Kantega SSO Enterprise. Please try again or refer to the logs for more information about what went wrong."));
        }
    }

    public boolean isAnyDataConfigured() {
        return this.kerbConfManager.isAnySettingsConfigured() || this.idpConfManager.isAnySettingsConfigured() || this.idpConfManager.isAnyProvidersSaved() || this.apiTokenService.isAnyApiTokensConfigured() || this.tokenEndpointService.isAnyTokenEndpointsConfigured();
    }

    public static String dataWithErrorMessages(io.vavr.collection.List<UpdatePluginSettingsEntryResult> upgradeFailures, KerbConfManager.KEYS configurationKey) {
        return (String)upgradeFailures.find(upgradeConfigEntryResult -> upgradeConfigEntryResult.getOldConfigurationKey() == configurationKey).map(UpdatePluginSettingsEntryResult::getDataWithErrorMessages).getOrNull();
    }

    public boolean isUpdateFromMajorVersion4OrUnknown() {
        return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().flatMap(Version::getMajor).map(major -> major < 5).getOrElse((Object)true);
    }

    public boolean isBreakingChangesInNewVersion() {
        Option<Version> maybeSavedKssoVersion;
        Option<Version> maybeRunningVersion = KerbConfManager.getRunningKssoVersion();
        boolean runningVersionIsSavedConfigVersion = maybeRunningVersion.exists(arg_0 -> KssoUpdateManager.lambda$isBreakingChangesInNewVersion$2(maybeSavedKssoVersion = this.kerbConfManager.getSavedKssoConfigVersion(), arg_0)) || maybeRunningVersion.isEmpty() && maybeSavedKssoVersion.isEmpty();
        return !runningVersionIsSavedConfigVersion && (this.isUpdateFromMajorVersion4OrUnknown() || this.activeObjectsSettingsUpdate.isBreakingApiTokens(this.kerbConfManager) || this.globalConfigUpdate.isBreakingCsrfCheck() || this.globalConfigUpdate.isBreakingDisableTraditionalLogin() || this.globalConfigUpdate.isBreakingBasicAuthIpRestrictions() || this.globalConfigUpdate.isBreakingIpRestrictionsVersion6_20());
    }

    public static boolean isUpdateApiTokenFromBeforeVersion43(Version savedVersion, Version runningVersion) {
        Version lastVersionBeforeBreakingApiToken = new Version("4.3.0");
        return savedVersion.compareTo(lastVersionBeforeBreakingApiToken) <= 0 && runningVersion.compareTo(lastVersionBeforeBreakingApiToken) > 0;
    }

    public static boolean isUpdateApiTokenFromBeforeVersion57(Version savedVersion, Version runningVersion) {
        Version versionWithNewApiTokens = new Version("5.7.0");
        return !KssoUpdateManager.isUpdateApiTokenFromBeforeVersion43(savedVersion, runningVersion) && savedVersion.compareTo(versionWithNewApiTokens) < 0;
    }

    public boolean isKssoConfigUpdateNeeded() {
        return this.isBreakingChangesInNewVersion() && this.isAnyDataConfigured() && this.kerbConfManager.hasKerberosFolder();
    }

    public io.vavr.collection.List<UpdatePluginSettingsEntryResult> getUpdateFailures() {
        return this.globalConfigUpdate.getUpdateFailures();
    }

    public boolean hasUpdateFailures() {
        return this.globalConfigUpdate.hasUpdateFailures();
    }

    public void removeUpdateFailureAfterFix(KerbConfManager.KEYS oldConfigurationKey) {
        this.globalConfigUpdate.removeUpdateFailureAfterFix(oldConfigurationKey);
    }

    @Nullable
    public static String onlyIpRestrictErrorMessagesCommaSeparated(io.vavr.collection.List<UpdatePluginSettingsEntryResult> upgradeFailures, KerbConfManager.KEYS key) {
        return (String)upgradeFailures.find(upgradeConfigEntryResult -> upgradeConfigEntryResult.getOldConfigurationKey() == key).map(UpdatePluginSettingsEntryResult::getDataWithErrorMessages).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull();
    }

    @Nullable
    public static String onlyIpRestrictErrorMessagesCommaSeparated(io.vavr.collection.List<String> ipRestrictionPermissions) {
        return (String)Option.of(ipRestrictionPermissions).map(p -> p.filter(InternetAddressUtils::isNotValidPermission)).map(ListParseUtils::iterableToCommaSeparatedAndSpacedString).getOrNull();
    }

    private boolean saveBackupOfConfig() {
        Option<Version> runningKssoVersion = KerbConfManager.getRunningKssoVersion();
        Option savedKssoVersion = this.kerbConfManager.getSavedKssoConfigVersion().peek(version -> log.info("Migrating the Kantega SSO Enterprise configuration from version " + version.stringValue + " to version " + (String)runningKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>"))).onEmpty(() -> log.info("Migrating the Kantega SSO Enterprise configuration from <unknown version>  to version " + (String)runningKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>")));
        log.info("Preparing for configutation update: Create a backup of Kantega SSO Enterprise configuration...");
        try {
            this.backupService.createBackup("Backup before update of config from version " + (String)savedKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>") + " to " + (String)runningKssoVersion.map(Version::stringValue).getOrElse((Object)"<unknown version>"));
            return true;
        }
        catch (Exception e) {
            log.error("We encountered an error while saving backup of Kantega SSO Enteprise configuration: ", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$isBreakingChangesInNewVersion$2(Option maybeSavedKssoVersion, Version version) {
        return maybeSavedKssoVersion.exists(version::equals);
    }

    public static enum ResultCode {
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE"),
        VERSION_CHANGE_FAILURE("VERSION_CHANGE_FAILURE"),
        NONE("NONE");

        private final String value;

        private ResultCode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class GlobalConfigUpdate {
        private final KerbConfManager kerbConfManager;
        private final UserLookupService userLookupService;
        private final HostApp hostApp;

        public GlobalConfigUpdate(KerbConfManager kerbConfManager, UserLookupService userLookupService, HostAppFactory hostAppFactory) {
            this.kerbConfManager = kerbConfManager;
            this.userLookupService = userLookupService;
            this.hostApp = hostAppFactory.getInstance();
        }

        io.vavr.collection.List<UpdateMessage> run() {
            return io.vavr.collection.List.of((Object[])new UpdateMessage[]{this.updateCsrfCheck(), this.updateIpRestrictionsFormat(), this.updateBasicAuthIpRestrictionsAfterFlippedBool()}).appendAll(this.updateDisableTraditionalLoginSettings());
        }

        boolean isBreakingDisableTraditionalLogin() {
            Version versionWithRefactoredTraditionalLogin = new Version("6.3.0");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithRefactoredTraditionalLogin) < 0).getOrElse((Object)true);
        }

        boolean isBreakingCsrfCheck() {
            Version versionWithNewCsrfCheck = new Version("5.5.2");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithNewCsrfCheck) < 0).getOrElse((Object)true);
        }

        boolean isBreakingBasicAuthIpRestrictions() {
            Version firstVersionWithBasicAuthIpRestriction = Version.of("6.3.0");
            Version versionWithBreakingChangesBasicAuth = new Version("6.15.0");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChangesBasicAuth) && version.isHigherThanOrEqualTo(firstVersionWithBasicAuthIpRestriction)).getOrElse((Object)false);
        }

        boolean isBreakingIpRestrictionsVersion6_20() {
            Version versionWithBreakingChangesBasicAuth = new Version("6.20.0");
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(version -> version.isLowerThan(versionWithBreakingChangesBasicAuth)).getOrElse((Object)false);
        }

        private io.vavr.collection.List<UpdateMessage> updateDisableTraditionalLoginSettings() {
            if (this.isBreakingDisableTraditionalLogin()) {
                log.info("Converting old traditional login settings to new format introduced in K-SSO Enterprise version 6.3");
                boolean traditionalLoginPrevented = this.kerbConfManager.oldIsTraditionalLoginDisabled();
                boolean traditionalLoginJsmPrevented = this.kerbConfManager.oldIsTraditionalLoginDisabledJSD();
                boolean basicAuthDisabled = this.kerbConfManager.oldIsBasicAuthDisabled();
                String disableLoginUri = this.kerbConfManager.getPluginRootAbsoluteUrl() + "/disableLogin";
                String disableLoginTitle = "Disable traditional username/password login";
                UpdateMessage traditionalLogin = this.kerbConfManager.setTraditionalLoginPrevented(traditionalLoginPrevented) ? new UpdateMessage(ResultCode.SUCCESS, "Successfully updated 'disable traditional username password login' to new format.") : new UpdateMessage(ResultCode.FAILURE, "Failed to update 'disable traditional username password login' to new format.", disableLoginUri, "Disable traditional username/password login");
                UpdateMessage traditionalLoginJsm = this.kerbConfManager.setTraditionalLoginJsmPrevented(traditionalLoginJsmPrevented) ? new UpdateMessage(ResultCode.SUCCESS, "Successfully updated 'disable traditional username password login for JSM' to new format.", disableLoginUri, "Disable traditional username/password login") : new UpdateMessage(ResultCode.FAILURE, "Failed to update 'disable traditional username password login' to new format.", disableLoginUri, "Disable traditional username/password login");
                UpdateMessage basicAuth = this.kerbConfManager.setBasicAuthPrevented(basicAuthDisabled) ? new UpdateMessage(ResultCode.SUCCESS, "Successfully updated 'disable traditional username password login' to new format.") : new UpdateMessage(ResultCode.FAILURE, "Failed to update 'disable traditional username password login' to new format.");
                return io.vavr.collection.List.of((Object[])new UpdateMessage[]{traditionalLogin, traditionalLoginJsm, basicAuth});
            }
            return io.vavr.collection.List.of((Object)new UpdateMessage(ResultCode.SUCCESS, "No need to update 'disable traditional login and basic auth' settings."));
        }

        private UpdateMessage updateCsrfCheck() {
            if (this.isBreakingCsrfCheck()) {
                return this.kerbConfManager.setCsrfOriginCheckEnabled(true) ? new UpdateMessage(ResultCode.SUCCESS, "Successfully upgraded CSRF origin header check to new format.") : new UpdateMessage(ResultCode.FAILURE, "Failed to upgrade CSRF origin header check to new format.");
            }
            return new UpdateMessage(ResultCode.SUCCESS, "No need to update CSRF origin header check.");
        }

        @NotNull
        private UpdateMessage updateIpRestrictionsFormat() {
            io.vavr.collection.List<UpdatePluginSettingsEntryResult> convertedIpRestrictionsResults = this.updateIpRestrictions();
            return convertedIpRestrictionsResults.forAll(UpdatePluginSettingsEntryResult::isSuccess) ? new UpdateMessage(ResultCode.SUCCESS, "Successfully upgraded Kantega SSO Enterprise IP restrictions to new format.", convertedIpRestrictionsResults) : new UpdateMessage(ResultCode.FAILURE, "Failed to upgrade Kantega SSO Enterprise IP restrictions to new format.", convertedIpRestrictionsResults);
        }

        private UpdateMessage updateBasicAuthIpRestrictionsAfterFlippedBool() {
            if (this.isBreakingBasicAuthIpRestrictions()) {
                boolean hasConfiguredBasicAuthIpRestrictions;
                IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
                boolean oldBasicAuthEnabled = !this.kerbConfManager.isBasicAuthPrevented();
                boolean bl = hasConfiguredBasicAuthIpRestrictions = ipRestrictionConfig.getBasicAuthIpBlockedList().length > 0 || ipRestrictionConfig.getBasicAuthIpUnblockedList().length > 0;
                if (oldBasicAuthEnabled && hasConfiguredBasicAuthIpRestrictions) {
                    log.info("Updating IP restrictions for basic auth to be compatible with new format");
                    log.info("Setting basicAuthPrevented to true and let IP restrictions decide access to basic auth");
                    this.kerbConfManager.setBasicAuthPrevented(true);
                    log.info("Setting all directories present to Basic Auth allowed directories.");
                    for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
                        try {
                            ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                            HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                            attrs.put("ksso.basic.auth.allowed", "true");
                            builder.setAttributes(attrs);
                            this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
                        }
                        catch (UnsupportedOperationException u) {
                            String errorMessage = ErrorUtils.createErrorMessage("KSSO-UIBQ35Z52X", "Unable to update directory " + directory.getName() + " during update of config");
                            log.error(errorMessage, (Throwable)u);
                            return UpdateMessage.failure(errorMessage);
                        }
                    }
                    return UpdateMessage.success("Successfully updated basic auth IP restrictions.");
                }
            }
            log.debug("Skipping update of Basic Auth Ip restrictions");
            return UpdateMessage.success("Skipping update of basic auth IP restrictions.");
        }

        boolean hasUpdateFailures() {
            return !this.getUpdateFailures().isEmpty();
        }

        boolean hasSavedOldPreV5IpRestrictions() {
            return io.vavr.collection.List.of((Object[])new KerbConfManager.KEYS[]{KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST}).map(key -> (String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)key))).exists(StringUtils::isNotBlank);
        }

        boolean hasSavedIpRestrictions() {
            return GlobalConfigUpdate.ipRestrictionKeys().map(key -> (String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)key))).exists(StringUtils::isNotBlank);
        }

        private void saveUpdateFailures(io.vavr.collection.List<UpdatePluginSettingsEntryResult> failedResults) {
            io.vavr.collection.List maybeJsonList = failedResults.filter(UpdatePluginSettingsEntryResult::isFailure).map(JsonMapping.Write::objectAsJson);
            if (maybeJsonList.forAll(Try::isSuccess)) {
                JSONArray resultsToSave = new JSONArray((Collection)maybeJsonList.map(Try::get).toJavaList());
                this.kerbConfManager.put(KerbConfManager.KEYS.UPGRADE_FAILURES, resultsToSave.toString());
            } else {
                maybeJsonList.find(Try::isFailure).map(Try::getCause).peek(throwable -> log.error("Encountered an error while saving the upgrade results: ", throwable));
            }
        }

        private io.vavr.collection.List<UpdatePluginSettingsEntryResult> updateIpRestrictions() {
            io.vavr.collection.List results = this.updateToV5IpRestrictions().appendAll(this.updateToV6_20IpRestrictions());
            if (results.forAll(UpdatePluginSettingsEntryResult::isSuccess)) {
                this.kerbConfManager.flushOneMinuteCache();
            }
            this.saveUpdateFailures((io.vavr.collection.List<UpdatePluginSettingsEntryResult>)results.filter(UpdatePluginSettingsEntryResult::isFailure));
            log.info("No conversion needed for Kantega SSO IP restrictions. Skipping conversion.");
            return io.vavr.collection.List.empty();
        }

        private io.vavr.collection.List<UpdatePluginSettingsEntryResult> updateToV6_20IpRestrictions() {
            if (this.isBreakingIpRestrictionsVersion6_20() && this.hasSavedIpRestrictions()) {
                log.info("Converting old IP restrictions to new format introduced in K-SSO Enterprise version 6.20.0");
                return GlobalConfigUpdate.ipRestrictionKeys().map(this::convertAndSaveToV6_20IpRestriction);
            }
            return io.vavr.collection.List.empty();
        }

        private io.vavr.collection.List<UpdatePluginSettingsEntryResult> updateToV5IpRestrictions() {
            if (this.hasSavedOldPreV5IpRestrictions() && this.isSavedConfigVersionPreV5()) {
                IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
                log.info("Converting old IP restrictions to new format introduced in K-SSO Enterprise version 5");
                io.vavr.collection.List results = GlobalConfigUpdate.legacyIpRestrictionKeysMapped().filter(oldKeyAndNewKey -> {
                    boolean isSettingConfigured = false;
                    if (((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST) || ((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST)) {
                        isSettingConfigured = this.kerbConfManager.isKerberosEnabled() && ipRestrictionConfig.getGlobalRestrictionType() != KerbConfManager.IpRestrictionType.UNRESTRICTED;
                    } else if (((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST) || ((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST)) {
                        isSettingConfigured = this.kerbConfManager.isKerberosEnabled() && this.kerbConfManager.isKerberosRestAuthEnabled() && ipRestrictionConfig.getRestRestrictionType() != KerbConfManager.IpRestrictionType.UNRESTRICTED;
                    } else if (((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST) || ((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1()))).equals((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST)) {
                        isSettingConfigured = this.kerbConfManager.isApiTokensEnabled() && ipRestrictionConfig.getApiTokenRestrictionType() != KerbConfManager.IpRestrictionType.UNRESTRICTED;
                    }
                    return isSettingConfigured && StringUtils.isNotBlank((CharSequence)((String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)((Object)oldKeyAndNewKey._1())))));
                }).map(this::convertAndSaveLegacyIpRestriction);
                if (results.forAll(UpdatePluginSettingsEntryResult::isSuccess)) {
                    this.kerbConfManager.flushOneMinuteCache();
                }
                return results;
            }
            log.info("Skipping KSSO Version 5 format update. Already up to date.");
            return io.vavr.collection.List.empty();
        }

        private boolean isSavedConfigVersionPreV5() {
            return (Boolean)this.kerbConfManager.getSavedKssoConfigVersion().map(v -> v.isLowerThan(Version.of("5.0.0"))).getOrElse((Object)true);
        }

        private void blockEveryPatternInBlockedListDueToFailedUpdate(KerbConfManager.KEYS oldConfigKey, KerbConfManager.KEYS newConfigKey) {
            String blockEveryIpAddressPattern = "^.*$" + System.lineSeparator();
            List<KerbConfManager.KEYS> blockedListConfigKeys = Arrays.asList(KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST);
            if (blockedListConfigKeys.contains((Object)oldConfigKey)) {
                this.kerbConfManager.put(newConfigKey, blockEveryIpAddressPattern);
            }
        }

        io.vavr.collection.List<UpdatePluginSettingsEntryResult> getUpdateFailures() {
            return (io.vavr.collection.List)Option.of((Object)((String)this.kerbConfManager.get(KerbConfManager.KEYS.UPGRADE_FAILURES))).filter(StringUtils::isNotBlank).toTry().mapTry((CheckedFunction1 & Serializable)source -> {
                JSONArray jsonArray = new JSONArray(source);
                ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    jsonObjects.add(jsonArray.optJSONObject(i));
                }
                return io.vavr.collection.List.ofAll(jsonObjects).map(Option::of).map(Value::toTry).map(maybeJson -> maybeJson.flatMap(json -> JsonMapping.Read.valueFromJson((JSONObject)json, UpdatePluginSettingsEntryResult.class).onFailure(error -> log.error("JSON error while reading config upgrade result: ", error)))).filter(Try::isSuccess).map(Try::get);
            }).getOrElse((Object)io.vavr.collection.List.empty());
        }

        public void removeUpdateFailureAfterFix(KerbConfManager.KEYS oldConfigurationKey) {
            io.vavr.collection.List resultsReduced = this.getUpdateFailures().removeFirst(failure -> failure.getOldConfigurationKey() == oldConfigurationKey);
            this.saveUpdateFailures((io.vavr.collection.List<UpdatePluginSettingsEntryResult>)resultsReduced);
            if (!this.hasUpdateFailures()) {
                this.kerbConfManager.updateKssoVersionInConfig();
            }
        }

        @NotNull
        private UpdatePluginSettingsEntryResult convertAndSaveLegacyIpRestriction(Tuple2<KerbConfManager.KEYS, KerbConfManager.KEYS> oldKeyAndNewKey) {
            io.vavr.collection.List<Either<String, String>> convertedRestrictions = InternetAddressUtils.Versioning.convertOldIpRestrictionFormatToVersion5Format((String)this.kerbConfManager.get((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())));
            if (convertedRestrictions.isEmpty()) {
                return new UpdatePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), ResultCode.SUCCESS, "No data for conversion found.", (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrNull());
            }
            if (this.isIpRestrictionConversionSuccessful(convertedRestrictions)) {
                String convertedIpRestrictions = ListParseUtils.listToStringWithNewlines((io.vavr.collection.List<String>)convertedRestrictions.map(Either::get));
                log.info("Converted " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).name());
                this.kerbConfManager.put((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2()), convertedIpRestrictions);
                return new UpdatePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), ResultCode.SUCCESS, "Conversion succeeded for " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).key, (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrNull());
            }
            log.error("Conversion failed for " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).name());
            io.vavr.collection.List failedConversions = convertedRestrictions.map(either -> (String)either.getOrElse(() -> ((Either)either).getLeft()));
            log.error("Failed conversion: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List<String>)failedConversions, KssoStringUtils.StringLiteral.COMMA));
            this.blockEveryPatternInBlockedListDueToFailedUpdate((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2()));
            return new UpdatePluginSettingsEntryResult((String)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull(), ResultCode.FAILURE, "Conversion failed for " + ((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1())).key, (KerbConfManager.KEYS)((Object)oldKeyAndNewKey._1()), this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle((KerbConfManager.KEYS)((Object)oldKeyAndNewKey._2())).getOrNull(), ListParseUtils.listToStringWithNewlines((io.vavr.collection.List<String>)failedConversions));
        }

        @NotNull
        private UpdatePluginSettingsEntryResult convertAndSaveToV6_20IpRestriction(KerbConfManager.KEYS ipRestrictionKey) {
            io.vavr.collection.List convertedRestrictions = InternetAddressUtils.Versioning.convertV5IpRestrictionFormatToV6_20Format((String)this.kerbConfManager.get(ipRestrictionKey)).map(InternetAddressUtils.IpRestrictionConversionResult::getMaybeConvertedRestriction);
            if (convertedRestrictions.isEmpty()) {
                return new UpdatePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), ResultCode.SUCCESS, "No data for conversion found.", ipRestrictionKey, this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl(ipRestrictionKey).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle(ipRestrictionKey).getOrNull());
            }
            if (this.isIpRestrictionConversionSuccessful((io.vavr.collection.List<Either<String, String>>)convertedRestrictions)) {
                String convertedIpRestrictions = ListParseUtils.listToStringWithNewlines((io.vavr.collection.List<String>)convertedRestrictions.map(Either::get));
                log.info("Converted " + ipRestrictionKey.name());
                this.kerbConfManager.put(ipRestrictionKey, convertedIpRestrictions);
                return new UpdatePluginSettingsEntryResult((Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull(), ResultCode.SUCCESS, "Conversion succeeded for " + ipRestrictionKey.key, ipRestrictionKey, this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl(ipRestrictionKey).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle(ipRestrictionKey).getOrNull());
            }
            log.error("Conversion failed for " + ipRestrictionKey.name());
            io.vavr.collection.List failedConversions = convertedRestrictions.map(either -> (String)either.getOrElse(() -> ((Either)either).getLeft()));
            log.error("Failed conversion: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List<String>)failedConversions, KssoStringUtils.StringLiteral.COMMA));
            this.blockEveryPatternInBlockedListDueToFailedUpdate(ipRestrictionKey, ipRestrictionKey);
            return new UpdatePluginSettingsEntryResult((String)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull(), ResultCode.FAILURE, "Conversion failed for " + ipRestrictionKey.key, ipRestrictionKey, this.kerbConfManager.getPluginRootAbsoluteUrl() + "/" + (String)PageNameUtils.getConfigPageRelativeUrl(ipRestrictionKey).getOrElse((Object)""), (String)PageNameUtils.getConfigPageTitle(ipRestrictionKey).getOrNull(), ListParseUtils.listToStringWithNewlines((io.vavr.collection.List<String>)failedConversions));
        }

        boolean isIpRestrictionConversionSuccessful(io.vavr.collection.List<Either<String, String>> convertedIpRestrictions) {
            return !convertedIpRestrictions.isEmpty() && convertedIpRestrictions.forAll(Either::isRight) && convertedIpRestrictions.filter(Either::isRight).map(Either::get).forAll(InternetAddressUtils::isValidPermissionList);
        }

        private static io.vavr.collection.List<KerbConfManager.KEYS> ipRestrictionKeys() {
            return io.vavr.collection.List.of((Object[])new KerbConfManager.KEYS[]{KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST, KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.REST_IP_BLOCKEDLIST, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST, KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_BLOCKEDLIST, KerbConfManager.KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST});
        }

        private static io.vavr.collection.List<Tuple2<KerbConfManager.KEYS, KerbConfManager.KEYS>> legacyIpRestrictionKeysMapped() {
            return io.vavr.collection.List.of((Object[])new Tuple2[]{Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_BLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_GLOBAL_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_REST_IP_BLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.REST_IP_BLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_REST_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_BLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_API_TOKEN_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST)), Tuple.of((Object)((Object)KerbConfManager.KEYS.LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST), (Object)((Object)KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST))});
        }
    }

    public static class IdpConfigurationUpdate {
        private final IdpConfManager idpConfManager;
        private final KerbConfManager kerbConfManager;

        public IdpConfigurationUpdate(IdpConfManager idpConfManager, KerbConfManager kerbConfManager) {
            this.idpConfManager = idpConfManager;
            this.kerbConfManager = kerbConfManager;
        }

        io.vavr.collection.List<UpdateMessage> run() {
            return io.vavr.collection.List.empty();
        }

        public static IdpConfiguration.UserUpdateNamePolicy convertNamePolicyFromOldConfig(IdpConfiguration.UserUpdatePolicy userUpdatePolicy) {
            return userUpdatePolicy == IdpConfiguration.UserUpdatePolicy.UPDATE ? IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME : IdpConfiguration.UserUpdateNamePolicy.NONE;
        }

        public static IdpConfiguration.UserUpdateEmailPolicy convertEmailPolicyFromOldConfig(IdpConfiguration.UserUpdatePolicy userUpdatePolicy) {
            return userUpdatePolicy == IdpConfiguration.UserUpdatePolicy.UPDATE ? IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL : IdpConfiguration.UserUpdateEmailPolicy.NONE;
        }
    }

    static class ActiveObjectsUpdate {
        private final ApiTokenService apiTokenService;
        private final TokenEndpointService tokenEndpointService;

        public ActiveObjectsUpdate(ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService) {
            this.apiTokenService = apiTokenService;
            this.tokenEndpointService = tokenEndpointService;
        }

        @NotNull
        io.vavr.collection.List<UpdateMessage> run() {
            return io.vavr.collection.List.of((Object)this.updateApiTokens());
        }

        @NotNull
        private UpdateMessage updateApiTokens() {
            return this.apiTokenService.migrateOldSettings() ? new UpdateMessage(ResultCode.SUCCESS, "Successfully updated Kantega SSO Enterprise API Tokens to new format.") : new UpdateMessage(ResultCode.FAILURE, "Failed to updated Kantega SSO Enterprise API Tokens to new format.");
        }

        boolean isBreakingApiTokens(KerbConfManager kerbConfManager) {
            Version versionWithNewFieldsInApiToken = new Version("5.7.0");
            return (Boolean)kerbConfManager.getSavedKssoConfigVersion().map(version -> version.compareTo(versionWithNewFieldsInApiToken) < 0).getOrElse((Object)true);
        }
    }
}

