/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.v1.user;

import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.Serializable;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.rest.resource.api.apitokens.Util;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTokensForUserV1 {
    private static final Logger log = LoggerFactory.getLogger(GetTokensForUserV1.class);

    public static Response run(UserProfile userProfile, ApiTokenService apiTokenService) {
        Option<String> maybeUsername = UserManagerUtils.extractUsername(userProfile);
        return (Response)maybeUsername.toTry().mapTry((CheckedFunction1 & Serializable)username -> List.ofAll(apiTokenService.findTokensByUsername((String)username))).mapTry((CheckedFunction1 & Serializable)apiTokens -> apiTokens.map(apiToken -> Util.apiTokenObjectToJsonV1(apiToken, userProfile.getUserKey()))).mapTry((CheckedFunction1 & Serializable)jsonObjects -> {
            JSONObject json = new JSONObject();
            json.put("apiTokens", jsonObjects);
            log.debug("Available API tokens for user {}: {}", maybeUsername.getOrElse((Object)"<unknown>"), (Object)json.toString(4));
            return new JSONArray(jsonObjects.toJavaList().toString());
        }).mapTry((CheckedFunction1 & Serializable)json -> Response.ok((Object)json.toString(4)).build()).onFailure(e -> log.error("Encountered an error while fetching KSSO API tokens: ", e)).getOrElse((Object)Response.serverError().build());
    }
}

