/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.azure.AzureDirectory;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AvatarFetchJobRunner
implements JobRunner,
Runnable {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(AvatarFetchJobRunner.class + ".job"));
    private static final Logger log = LoggerFactory.getLogger(AvatarFetchJobRunner.class);
    private final HostApp hostApp;
    private ConnectorConfManager connectorConfManager;
    private CrowdDirectoryFinder crowdDirectoryFinder;

    @Inject
    public AvatarFetchJobRunner(HostAppFactory hostAppFactory, ConnectorConfManager connectorConfManager) {
        this.hostApp = hostAppFactory.getInstance();
        this.crowdDirectoryFinder = new CrowdDirectoryFinder(this.hostApp);
        this.connectorConfManager = connectorConfManager;
    }

    public AvatarFetchJobRunner(HostApp hostApp) {
        this.hostApp = hostApp;
    }

    private boolean skipDirectory(AzureDirectory aDir, com.atlassian.crowd.embedded.api.Directory cDir) {
        if (!cDir.isActive() || !aDir.isAvatarFetchActive()) {
            return true;
        }
        int fetchHourInterval = aDir.getAvatarFetchFrequency();
        LocalDateTime timeNow = LocalDateTime.now();
        LocalDateTime lastFetchDate = aDir.getAvatarLastFetchDate();
        LocalDateTime nextFetchDate = null;
        if (lastFetchDate != null) {
            nextFetchDate = lastFetchDate.plusHours(fetchHourInterval);
        }
        if (aDir.isAvatarFetchRunning()) {
            LocalDateTime time24hAfterLastFetch = null;
            if (lastFetchDate != null) {
                time24hAfterLastFetch = lastFetchDate.plusHours(24L);
            }
            if (time24hAfterLastFetch != null && timeNow.isBefore(time24hAfterLastFetch)) {
                log.info("Previous avatar sync job appears to still be running. Skipping fetch for now. The 'running' status will be ignored after >24 hours, and a new avatar sync will be run on a new thread.");
                return true;
            }
            log.warn("Avatar sync has had 'running' status in directory {} for >24 hours or is in an invalid state. A new avatar sync will be run on a new thread.", (Object)aDir.getId());
            return false;
        }
        return nextFetchDate != null && nextFetchDate.isAfter(timeNow);
    }

    private Map<String, String> getUserDataFromDir(com.atlassian.crowd.embedded.api.Directory crowdDirectory) {
        HashMap<String, String> userData = new HashMap<String, String>();
        try {
            List userBatch;
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            int index = 0;
            int BATCH_SIZE = 1000;
            do {
                userBatch = directoryManager.searchUsers(crowdDirectory.getId().longValue(), (EntityQuery)new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, index, BATCH_SIZE));
                this.hostApp.mapNameToExternalId(userBatch, userData);
                index += BATCH_SIZE;
            } while (userBatch.size() == BATCH_SIZE);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
        return userData;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        List<Directory> directories = this.connectorConfManager.getDirectories();
        for (Directory directory : directories) {
            ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(directory.getKind());
            if (!connectorType.supportsAvatars()) continue;
            ConnectorAPI api = connectorType.getConnectorApi(directory);
            AzureDirectory azureDir = (AzureDirectory)directory;
            com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(directory.getId());
            if (this.skipDirectory(azureDir, crowdDirectory)) continue;
            azureDir.setAvatarLastFetchDateToCurrentDate();
            Map<String, String> userData = this.getUserDataFromDir(crowdDirectory);
            try {
                azureDir.setAvatarFetchStatus(AzureDirectory.AvatarFetchStatus.RUNNING);
                azureDir = (AzureDirectory)this.connectorConfManager.saveOrEdit(azureDir);
                api.setAvatars(userData, this.hostApp.getHomeDirectory().toPath(), azureDir.getId(), this.hostApp);
                azureDir.setAvatarFetchStatus(AzureDirectory.AvatarFetchStatus.SUCCESS);
            }
            catch (InterruptedException | RuntimeException e) {
                azureDir.setAvatarFetchStatus(AzureDirectory.AvatarFetchStatus.FAILED);
                log.warn("Failed to fetch avatars for director  y {}: {}", (Object)directory.getId(), (Object)e.getMessage());
                throw new RuntimeException(e);
            }
            finally {
                this.connectorConfManager.saveOrEdit(azureDir);
            }
        }
        return JobRunnerResponse.success();
    }

    @Override
    public void run() {
    }
}

