/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.vavr.collection.List;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdateMessage;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class KssoUpdateTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(KssoUpdateTask.class);
    private final KssoUpdateManager kssoUpdateManager;

    @Inject
    public KssoUpdateTask(KssoUpdateManager kssoUpdateManager) {
        this.kssoUpdateManager = kssoUpdateManager;
    }

    public int getBuildNumber() {
        return (Integer)KerbConfManager.getRunningKssoVersion().map(Version::buildNumber).getOrElse((Object)Version.empty().buildNumber());
    }

    public String getShortDescription() {
        return "Configuration update routine for Kantega SSO Enterprise";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Running Kantega SSO Enterprise configuration update task...");
        List<UpdateMessage> messages = this.kssoUpdateManager.doUpdate();
        if (messages.forAll(UpdateMessage::isSuccess)) {
            return new ArrayList<Message>();
        }
        return messages.filter(UpdateMessage::isFailure).map(Message.class::cast).toJavaList();
    }

    public String getPluginKey() {
        return PluginKey.getPluginKey();
    }
}

