/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;

public class IdpSamlSettingsServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;

    @Inject
    public IdpSamlSettingsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "samlSettings");
        model.put("idp", configuration);
        model.put("nextId", this.idpConfManager.nextId());
        model.put("idpIdLen", 20);
        model.put("productName", this.applicationProperties.getDisplayName());
        model.put("comparisons", SamlIdpConfiguration.RequestedAuthnContextComparison.values());
        model.put("defaultIssuer", this.idpConfManager.getServiceProviderLoginUrl(req, id));
        this.getTemplateRenderer().render("templates/saml/saml-idp-saml-settings.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String idFromRequestUrl = IdpConfManager.IdpServletUtil.getId(req);
        String id = (String)Option.of((Object)req.getParameter("newIdpId")).map(StringUtils::trim).filter(IdpConfManager::isValidIdpId).peek(newIdpId -> this.idpConfManager.updateId(idFromRequestUrl, (String)newIdpId)).getOrElse((Object)idFromRequestUrl);
        SamlIdpConfiguration.IssuerPolicy issuerPolicy = SamlIdpConfiguration.IssuerPolicy.valueOf(req.getParameter("issuerPolicy"));
        String issuer = req.getParameter("issuer").trim();
        IdpConfiguration.AllowCreate allowCreate = IdpConfiguration.AllowCreate.valueOf(req.getParameter("allowCreate"));
        IdpConfiguration.NameIdFormat nameIdFormat = IdpConfiguration.NameIdFormat.valueOf(req.getParameter("nameIdFormat"));
        String customNameIdFormat = req.getParameter("customNameIdFormat").trim();
        SamlIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy = SamlIdpConfiguration.RequestedAuthnContextPolicy.valueOf(req.getParameter("requestedAuthnContext"));
        SamlIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison = SamlIdpConfiguration.RequestedAuthnContextComparison.valueOf(req.getParameter("requestedAuthnContextComparison").toUpperCase());
        String authnContextClassRef = req.getParameter("authnContextClassRef").trim();
        boolean encryptedAssertionsRequired = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("encryptedAssertionsRequired"));
        boolean instantLoginUrlInSession = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("instantLoginUrlInSession"));
        boolean usePostBinding = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("usePostBinding"));
        IdpConfiguration updated = this.idpConfManager.getIdentityProviderById(id).fold(oidc -> {
            throw new RuntimeException("OIDC config not expected: " + id);
        }, saml -> (SamlIdpConfiguration)IdpConfigurationBuilder.of(saml).setAllowCreate(allowCreate).setAuthnCtxClassRef(authnContextClassRef).setCustomNameIdFormat(customNameIdFormat).setEncryptedAssertionsRequired(encryptedAssertionsRequired).setInstantLoginUrlInSession(instantLoginUrlInSession).setUsePostBinding(usePostBinding).setIssuer(issuer).setIssuerPolicy(issuerPolicy).setNameIdFormat(nameIdFormat).setRequestedAuthnContextComparison(requestedAuthnContextComparison).setRequestedAuthnContextPolicy(requestedAuthnContextPolicy).build());
        this.idpConfManager.updateIdpConfiguration(updated);
        String newUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin/providers/" + id + "/samlsettings";
        resp.sendRedirect(newUrl);
    }

    private boolean isEmpty(String nameParam) {
        return nameParam == null || nameParam.trim().isEmpty();
    }
}

