/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.bitbucket;

import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;

public class KerberosCloneUrlCondition
implements Condition {
    private final KerbConfManager kerbConfManager;
    private String priority;

    @Inject
    public KerberosCloneUrlCondition(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public void init(Map<String, String> params) {
        this.priority = params.get("priority");
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (!this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled()) {
            return false;
        }
        if (this.priority == null) {
            return true;
        }
        boolean isDefault = this.kerbConfManager.isBitbucketKerberosScmUrlsDefault();
        if (isDefault) {
            return "high".equals(this.priority);
        }
        return "low".equals(this.priority);
    }
}

