/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.servlet.IdpGroupsServlet;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(BasicAuthServlet.class);

    @Inject
    public BasicAuthServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            IdpGroupsServlet.printGroupsAsJson(resp, query, this.userManager);
        } else {
            this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        this.kerbConfManager.setBasicAuthPrevented(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("basicAuthPrevented")));
        HashMap<String, Object> basicAuthLoginIpRestrictions = this.setBasicAuthIpRestrictions(req);
        String addGroup = StringUtils.trim((String)req.getParameter("addGroup"));
        String removeGroup = req.getParameter("removeGroup");
        if ("usersInGroupsSelected".equals(req.getParameter("usersInGroups"))) {
            if (this.kerbConfManager.getDisallowBasicAuthGroups().size() > 0) {
                this.kerbConfManager.setAllowBasicAuthGroups(this.kerbConfManager.emptyDisallowBasicAuthGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addAllowBasicAuthGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeAllowBasicAuthGroups(removeGroup);
            }
        } else {
            if (this.kerbConfManager.getAllowBasicAuthGroups().size() > 0) {
                this.kerbConfManager.setDisallowBasicAuthGroups(this.kerbConfManager.emptyAllowBasicAuthGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addDisallowBasicAuthGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeDisallowBasicAuthGroups(removeGroup);
            }
        }
        this.userLookupService.invalidateDirectoriesCache();
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            String enableButton = req.getParameter("basicAuthAllowedDir" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton)) {
                    attrs.put("ksso.basic.auth.allowed", "true");
                } else {
                    attrs.put("ksso.basic.auth.allowed", "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error(ErrorUtils.createErrorMessage("KSSO-X7O8L3EC10", "Unable to update directory " + directory.getName()), (Throwable)u);
            }
        }
        if (basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedBlockedList") || basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedUnblockedList")) {
            this.buildModelAndRenderTemplate(req, resp, basicAuthLoginIpRestrictions);
            return;
        }
        resp.sendRedirect("basic-auth");
    }

    private HashMap<String, Object> setBasicAuthIpRestrictions(HttpServletRequest req) {
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        String basicAuthIpRestrictionType = req.getParameter("basicAuthIpRestrictionType");
        String basicAuthIpUnblockedList = req.getParameter("basicAuthIpUnblockedList");
        String basicAuthIpBlockedList = req.getParameter("basicAuthIpBlockedList");
        Option.of((Object)basicAuthIpRestrictionType).filter(StringUtils::isNotBlank).toTry().mapTry(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).onFailure(t -> this.log.debug("Couldn't save IP restriction type " + basicAuthIpRestrictionType, t)).peek(this.kerbConfManager::setBasicAuthIpRestrictionType);
        if (basicAuthIpBlockedList == null || basicAuthIpUnblockedList == null) {
            return additionalData;
        }
        Option maybeValidUnblockedList = Option.of((Object)basicAuthIpUnblockedList).filter(InternetAddressUtils::isValidPermissionList).peek(this.kerbConfManager::setBasicAuthIpUnblockedList).onEmpty(() -> additionalData.put("basicAuthIpUnblockedList", basicAuthIpUnblockedList)).onEmpty(() -> additionalData.put("basicAuthRegexFailedUnblockedList", true)).onEmpty(() -> additionalData.put("invalidDataInIpUnblockedList", Option.of((Object)basicAuthIpUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull()));
        Option maybeValidBlockedList = Option.of((Object)req.getParameter("basicAuthIpBlockedList")).filter(InternetAddressUtils::isValidPermissionList).peek(this.kerbConfManager::setBasicAuthIpBlockedList).onEmpty(() -> additionalData.put("basicAuthIpBlockedList", basicAuthIpBlockedList)).onEmpty(() -> additionalData.put("basicAuthRegexFailedBlockedList", true)).onEmpty(() -> additionalData.put("invalidDataInIpBlockedList", Option.of((Object)basicAuthIpBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull()));
        boolean success = List.of((Object[])new Option[]{maybeValidUnblockedList, maybeValidBlockedList}).forAll(Option::isDefined);
        if (!success) {
            additionalData.put("basicAuthIpRegexError", true);
        }
        return additionalData;
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalData);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/basic-auth.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "basic-auth");
        model.put("basicAuthPrevented", this.kerbConfManager.isBasicAuthPrevented());
        model.put("basicAuthIpUnblockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(ipRestrictionConfig.getBasicAuthIpUnblockedList())));
        model.put("basicAuthIpBlockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(ipRestrictionConfig.getBasicAuthIpBlockedList())));
        model.put("basicAuthIpRestrictionType", (Object)ipRestrictionConfig.getBasicAuthIpRestrictionType());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("directories", this.userLookupService.getActiveUserDirectories());
        model.put("KSSO_BASIC_AUTH_ALLOWED", "ksso.basic.auth.allowed");
        if (!this.kerbConfManager.getDisallowBasicAuthGroups().isEmpty()) {
            model.put("allowGroupsSelected", false);
            model.put("groups", this.kerbConfManager.getDisallowBasicAuthGroups());
        } else {
            model.put("allowGroupsSelected", true);
            model.put("groups", this.kerbConfManager.getAllowBasicAuthGroups());
        }
        return model;
    }
}

