/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.login;

import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;

public class RedirectProperties
implements DebugInfo {
    private final IdpConfiguration.RedirectPolicy redirectPolicy;
    private final Set<String> redirectGroups;
    private final boolean sendLoginHint;
    private final boolean knownAutoRedirect;
    private final boolean visible;
    private final boolean ssoOnLogout;
    private final Set<Long> matchedUserDirectoryIds;
    private final IdpConfiguration.MatchingPolicy groupMatchingPolicy;
    private final IdpConfiguration.MatchingPolicy directoryMatchingPolicy;

    public RedirectProperties(IdpConfiguration.RedirectPolicy redirectPolicy, Set<String> redirectGroups, boolean sendLoginHint, boolean knownAutoRedirect, boolean visible, boolean ssoOnLogout, Set<Long> matchedUserDirectoryIds, IdpConfiguration.MatchingPolicy groupMatchingPolicy, IdpConfiguration.MatchingPolicy directoryMatchingPolicy) {
        this.redirectPolicy = redirectPolicy;
        this.redirectGroups = redirectGroups;
        this.sendLoginHint = sendLoginHint;
        this.knownAutoRedirect = knownAutoRedirect;
        this.visible = visible;
        this.ssoOnLogout = ssoOnLogout;
        this.matchedUserDirectoryIds = matchedUserDirectoryIds;
        this.groupMatchingPolicy = groupMatchingPolicy;
        this.directoryMatchingPolicy = directoryMatchingPolicy;
    }

    public RedirectProperties(RedirectProperties otherRedirectProperties) {
        this.redirectPolicy = otherRedirectProperties.getRedirectPolicy();
        this.redirectGroups = otherRedirectProperties.getRedirectGroups();
        this.sendLoginHint = otherRedirectProperties.isSendLoginHint();
        this.knownAutoRedirect = otherRedirectProperties.isKnownAutoRedirect();
        this.visible = otherRedirectProperties.isVisible();
        this.matchedUserDirectoryIds = otherRedirectProperties.getMatchedUserDirectoryIds();
        this.groupMatchingPolicy = otherRedirectProperties.getGroupMatchingPolicy();
        this.directoryMatchingPolicy = otherRedirectProperties.getDirectoryMatchingPolicy();
        this.ssoOnLogout = otherRedirectProperties.isSsoOnLogout();
    }

    public IdpConfiguration.RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    public Set<String> getRedirectGroups() {
        return this.redirectGroups;
    }

    public boolean isSendLoginHint() {
        return this.sendLoginHint;
    }

    public boolean isKnownAutoRedirect() {
        return this.knownAutoRedirect;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isSsoOnLogout() {
        return this.ssoOnLogout;
    }

    public Set<Long> getMatchedUserDirectoryIds() {
        return this.matchedUserDirectoryIds;
    }

    public IdpConfiguration.MatchingPolicy getGroupMatchingPolicy() {
        return this.groupMatchingPolicy;
    }

    public IdpConfiguration.MatchingPolicy getDirectoryMatchingPolicy() {
        return this.directoryMatchingPolicy;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("redirectPolicy", (Object)this.getRedirectPolicy().name());
        json.put("redirectGroups", (Object)new JSONArray(this.getRedirectGroups()));
        json.put("sendLoginHint", this.isSendLoginHint());
        json.put("knownAutoRedirect", this.isKnownAutoRedirect());
        json.put("visible", this.isVisible());
        json.put("matchedUserDirectoryIds", this.getMatchedUserDirectoryIds());
        json.put("groupMatchingPolicy", (Object)this.getGroupMatchingPolicy());
        json.put("directoryMatchingPolicy", (Object)this.getDirectoryMatchingPolicy());
        return json;
    }
}

