/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.web.context.HttpContext;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kantega.atlaskerb.DisableTraditionalLoginServlet;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.ManualLoginEvent;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.diagnostics.FailureListener;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.intercept.filter.RequestInterceptor;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.intercept.model.Intercept;
import org.kantega.atlaskerb.intercept.model.InterceptExitCondition;
import org.kantega.atlaskerb.intercept.model.InterceptResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SSOScriptLoginHookCondition;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ContextAware;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasKerberosMainAuthFilter
implements Filter {
    public static final String LOCKOUT_TIMESTAMP = "lockout_timestamp";
    public static final String USERNAME_ANONYMOUS_USER = "usernameAnonymousUser";
    private static final Logger log = LoggerFactory.getLogger(AtlasKerberosMainAuthFilter.class);
    private static final Logger manualLoginLog = LoggerFactory.getLogger(ManualLoginEvent.class);
    private static final String ALREADY_MATCHED_ATTR = AtlasKerberosMainAuthFilter.class.getName() + "_alreadyMatched";
    private final KerbConfManager kerbConfManager;
    private final AuditLogFacade auditLogFacade;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SSOScriptLoginHookCondition loginScriptCondition;
    private final UserLookupService userLookupService;
    private final WebResourceManager webResourceManager;
    private String[] products;
    private final RequestInterceptor requestInterceptor;

    @Inject
    public AtlasKerberosMainAuthFilter(@ComponentImport HttpContext httpContext, @ComponentImport WebResourceManager webResourceManager, FailureListener failureListener, AuditLogFacade auditLogFacade, RequireAdminServletDependencyBucket bucket) {
        this.kerbConfManager = bucket.getKerbConfManager();
        this.auditLogFacade = auditLogFacade;
        this.userLookupService = bucket.getUserLookupService();
        this.webResourceManager = webResourceManager;
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.idpConfManager = bucket.getIdpConfManager();
        this.loginScriptCondition = new SSOScriptLoginHookCondition(httpContext, bucket);
        this.requestInterceptor = new RequestInterceptor(httpContext, failureListener, auditLogFacade, bucket);
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        boolean alreadyMatched = req.getAttribute(ALREADY_MATCHED_ATTR) != null;
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        String requestURI = req.getRequestURI();
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(req);
        this.toggleKerberosSessionFromQueryString(req);
        if (alreadyMatched && !this.isForwarded(req) || !this.isProductMatch()) {
            log.debug("Already matched request, !isForwarded and !isProductMatch. Passing filter down chain");
            chain.doFilter(request, response);
            return;
        }
        req.setAttribute(ALREADY_MATCHED_ATTR, (Object)true);
        if (isLoginPage && DisableTraditionalLoginServlet.isBlockTraditionalLogin(this.kerbConfManager, this.userLookupService) && !this.isForceUIForTest(req)) {
            log.debug("Including disabling-login elements in page since traditional login is disabled for {}", (Object)requestURI);
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-login");
        }
        if (!this.isMappedRequest(req, res)) {
            log.trace("Request for {} is not mapped for further processing. Passing down filter chain", (Object)requestURI);
            chain.doFilter(request, response);
            return;
        }
        this.addLoginScrips(req);
        this.logAuthorizationHeaders(req);
        this.logSessionAttributes(req);
        this.logForwardedRequest(req);
        log.debug("AtlasKerberosMainAuthFilter processing requestUri {}, method {}", (Object)requestURI, (Object)req.getMethod());
        List<Intercept> interceptOrder = Collections.unmodifiableList(Arrays.asList(Intercept.REST_API_ACCESS, Intercept.ALREADY_LOGGED_IN, Intercept.LICENSE, Intercept.ANONYMOUS_BROWSING, Intercept.USERNAME_FROM_HEADER, Intercept.API_TOKEN, Intercept.OTHER_AUTH_TOKEN, Intercept.COOKIE, Intercept.KERBEROS, Intercept.FEDERATED_SSO, Intercept.PASS_DOWN_FILTER_CHAIN));
        this.logInterceptOrder(requestURI, interceptOrder);
        InterceptResult interceptResult = this.requestInterceptor.intercept(req, res, interceptOrder);
        log.debug("Intercepted request on URI {} with result {}", (Object)requestURI, (Object)interceptResult);
        switch (interceptResult.getType()) {
            case LOGIN_SUCCESS: {
                this.finishLogin(req, res, chain, interceptResult);
                return;
            }
            case LOGIN_FAILED: {
                this.auditLogFacade.loginFailed((String)interceptResult.getMaybeUsername().getOrElse((Object)"anonymous"), interceptResult.getAuthMethod(), interceptResult.getMessage());
                interceptResult.writeRequestAndResponse(req, res).onFailure(t -> log.warn(ErrorUtils.createErrorMessage("KSSO-2GRKFGW5YE", "Failed to write response: "), t));
                return;
            }
            case PASS_DOWN_FILTER_CHAIN: {
                interceptResult.doFilter(request, response, chain).onFailure(t -> log.error(String.format("Could not pass down custom filter with result %s: %s", new Object[]{interceptResult.getType(), interceptResult.getMessage()}), t)).onFailure(t -> log.debug("Failed to pass down filter chain for user " + (String)interceptResult.getMaybeUsername().getOrElse((Object)"anonymous") + " with result " + (Object)((Object)interceptResult.getType()) + " " + interceptResult.getMessage(), t)).getOrElseThrow(t -> new RuntimeException((Throwable)t));
                return;
            }
            case SEND_REDIRECT: {
                Option<String> redirectTarget = interceptResult.getMaybeRedirectTarget();
                if (redirectTarget.isDefined()) {
                    res.sendRedirect((String)redirectTarget.get());
                } else {
                    log.warn(ErrorUtils.createErrorMessage("KSSO-MKKZK2YMWF", "Redirect target not defined for result type: " + (Object)((Object)interceptResult.getType()) + ". Passing down filter chain"));
                    chain.doFilter(request, response);
                }
                return;
            }
            case DISPATCH_TO_LOGIN: {
                interceptResult.writeRequestAndResponse(req, res).onFailure(t -> log.warn(ErrorUtils.createErrorMessage("KSSO-T2RJWACUNX", "Failed to write response."), t));
                this.dispatchToLogin(req, res, chain);
                return;
            }
            case NEXT_INTERCEPT: {
                log.warn("KSSO: Ended up in CONTINUE path after all processing in filter. No further processing at this point. Passing down filter chain...");
                chain.doFilter(request, response);
                break;
            }
            default: {
                log.warn(ErrorUtils.createErrorMessage("KSSO-K1DFM4MUTP", "Unexpected value after filter intercept. Passing down filter chain: ") + (Object)((Object)interceptResult.getType()));
                chain.doFilter(request, response);
            }
        }
    }

    private void logInterceptOrder(String requestURI, List<Intercept> interceptOrder) {
        log.debug("Intercepting request on" + requestURI + ". Perform the following checks: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List<String>)io.vavr.collection.List.ofAll(interceptOrder).map(Enum::toString), KssoStringUtils.StringLiteral.COMMA_AND_SPACE));
    }

    private void finishLogin(HttpServletRequest req, HttpServletResponse res, FilterChain chain, InterceptResult result) throws ServletException, IOException {
        if (result.getMaybePrincipal().isEmpty()) {
            this.auditLogFacade.loginFailed((String)result.getMaybeUsername().getOrElse((Object)"anonymous"), result.getAuthMethod(), result.getMessage());
            log.error("Unable to finish login. Principal is not set. Passing down filter chain");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        Principal principal = (Principal)result.getMaybePrincipal().get();
        if (result.getType() == InterceptExitCondition.LOGIN_SUCCESS) {
            log.debug("Successful login with {}", (Object)result.getAuthMethod());
            String username = principal.getName();
            if (result.getAuthMethod() == AuthMethod.KERBEROS) {
                this.auditLogFacade.loginSuccess(username, result.getAuthMethod());
                this.finishSuccessfulKerberosLogin(req, res, principal, chain);
            } else if (result.getAuthMethod() == AuthMethod.API_TOKEN) {
                this.auditLogFacade.loginSuccess(username, result.getAuthMethod());
                this.finishSuccessfulApiTokenLogin(req, res, chain, result, principal);
            } else if (result.getAuthMethod() == AuthMethod.USERNAME_FROM_HEADER) {
                this.auditLogFacade.loginSuccess(username, result.getAuthMethod());
                this.hostApp.publishUserAuthenticatedEvent(principal, req, res);
                this.authenticateWithProduct(req, res, principal);
                result.doFilter((ServletRequest)req, (ServletResponse)res, chain).onFailure(t -> log.error("Could not pass down custom filter after successful login...", t)).getOrElseThrow(t -> new RuntimeException((Throwable)t));
            } else {
                log.debug("Incorrect authmethod {}. Passing down filter chain...", (Object)result.getAuthMethod());
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            }
        } else {
            this.auditLogFacade.loginFailed((String)result.getMaybeUsername().getOrElse((Object)"anonymous"), result.getAuthMethod(), result.getMessage());
            log.warn("Ended up in successful login path with unidentified result {}...", (Object)result);
            log.debug("Passing down filter chain...");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private void finishSuccessfulApiTokenLogin(HttpServletRequest req, HttpServletResponse res, FilterChain chain, InterceptResult result, @NonNull Principal principal) {
        Option<Integer> maybeFailedLoginAttempts = result.getMaybeFailedLoginAttempts();
        this.authenticateWithProduct(req, res, principal);
        maybeFailedLoginAttempts.toTry().peek(failedLoginAttempts -> log.debug("Persisting failed login attempts for {}: {}", (Object)UserManagerUtils.nullsafeUsernameOrAnonymous(principal), failedLoginAttempts)).flatMapTry((CheckedFunction1 & Serializable)failedLoginAttempts -> this.hostApp.setFailedLoginAttempts(principal, (int)failedLoginAttempts)).onFailure(e -> log.warn("Failed to persist login attempts during API token authentication:", e));
        result.doFilter((ServletRequest)req, (ServletResponse)res, chain).onFailure(t -> log.error("Could not pass down custom filter after successful login...", t)).getOrElseThrow(t -> new RuntimeException((Throwable)t));
    }

    private void addLoginScrips(HttpServletRequest req) {
        if (this.loginScriptCondition.shouldAddLoginScripts(req)) {
            log.debug("Adding login scripts");
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
        }
        if (this.loginScriptCondition.shouldAddMSTeamsScripts(req)) {
            log.debug("Adding MSTeams login scripts");
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-msteams-login");
        }
    }

    private void logSessionAttributes(HttpServletRequest req) {
        if (this.idpConfManager.isSamlSessionActive(req)) {
            log.debug("KSSO SAML session active for user " + (String)Option.of((Object)req.getSession(false).getAttribute("ksso.saml.session.user")).map(String.class::cast).getOrElse((Object)"<anonoymous>"));
        }
        if (this.idpConfManager.isOidcSessionActive(req)) {
            log.debug("KSSO OpenID connect session active for user " + (String)Option.of((Object)req.getSession(false).getAttribute("ksso.oidc.session.user")).map(String.class::cast).getOrElse((Object)"<anonymous>"));
        }
    }

    private void logForwardedRequest(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            SanitizedLogStatement.of(req.getAttribute("javax.servlet.forward.request_uri")).andThenLog(sanitizedAttribute -> log.debug("Initiating SSO on forwarded request from; {} to: {}", sanitizedAttribute, (Object)req.getRequestURI()));
        }
    }

    private void logAuthorizationHeaders(HttpServletRequest req) {
        if (this.hostApp.isRestApi(HttpUrlUtils.getInternalPath(req)) && log.isDebugEnabled()) {
            Enumeration authorizationHeaders = req.getHeaders("Authorization");
            int i = 0;
            while (authorizationHeaders.hasMoreElements()) {
                log.debug("Authorization Headers:");
                String header = (String)authorizationHeaders.nextElement();
                String scheme = header.split(" ")[0];
                log.debug("Header Authorization " + i + ": " + scheme);
                ++i;
            }
        }
    }

    private boolean isPreemptivePathExcluded(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length()).toLowerCase();
        if (req.getQueryString() != null) {
            r = r + "?" + req.getQueryString();
        }
        for (String excludedPath : this.kerbConfManager.getRequireLoginExcludedPaths()) {
            if (excludedPath != null && excludedPath.endsWith("*")) {
                excludedPath = excludedPath.substring(0, excludedPath.length() - 1);
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)r, (CharSequence)excludedPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isMappedRequest(HttpServletRequest req, HttpServletResponse resp) {
        String r = HttpUrlUtils.getInternalPath(req);
        if (this.hostApp.isRequestMapped(req, r)) {
            log.debug("hostApp.isRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isRESTRequestMapped(req, r)) {
            log.debug("hostApp.isRestRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isForceLoginRequestMapped(req) && this.kerbConfManager.isRequireLogin() && !this.isPreemptivePathExcluded(req)) {
            log.debug("hostApp.isRequireLogin({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLoginRequest(req)) {
            log.debug("hostApp.isLoginRequest({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.shouldLoginManually(req, resp) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            log.debug("hostApp.shouldLoginManually && idpConfManager.isAnyProviderForcingReLoginAfterLogout() ({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLogoutPage(req) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            log.debug("hostApp.isLogoutPage && idpConfManager.isAnyProviderForcingReLoginAfterLogout() ({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isServiceDeskLogout(req) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) {
            return true;
        }
        if (this.hostApp.shouldTryApiTokenAuthentication(req)) {
            log.debug("AtlasKerberosFilter.shouldTryApiAuthentication({}) => true", (Object)r);
            return true;
        }
        if (HttpUrlUtils.getUsernameFromBasicAuthHeader(req).isDefined()) {
            log.debug("AtlasKerberosFilter.getUsernameFromHeader({}) => true", (Object)r);
            return true;
        }
        log.debug("AtlasKerberosFilter.isMappedRequest({}) => FALSE", (Object)r);
        return false;
    }

    private void finishSuccessfulKerberosLogin(HttpServletRequest req, HttpServletResponse res, Principal principal, FilterChain chain) throws ServletException, IOException {
        this.authenticateWithProduct(req, res, principal);
        this.kerbConfManager.getStats().success();
        res.setHeader("Persistent-Auth", "false");
        log.debug("Kerberos ticket OK -> login success");
        this.hostApp.postSuccessfulLoginWithKerberosAction(principal, req, res, chain);
    }

    private boolean isForceUIForTest(HttpServletRequest req) {
        String qry = req.getQueryString();
        return qry != null && qry.contains("forceUIForTest");
    }

    private boolean querystringHas(String queryStringPart, HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)queryStringPart);
    }

    private void toggleKerberosSessionFromQueryString(HttpServletRequest req) {
        if (this.querystringHas("nokerberosSession", req)) {
            req.getSession().setAttribute("nokerberosSession", (Object)true);
        } else if (this.querystringHas("kerberosSession", req)) {
            req.getSession().removeAttribute("nokerberosSession");
        }
    }

    private boolean isForwarded(HttpServletRequest req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    private void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws ServletException, IOException {
        log.debug("is response committed {}", (Object)resp.isCommitted());
        IdpConfiguration autoRedirect = this.hostApp.getInstantRedirectProvider(req, resp, this.loginScriptCondition);
        boolean hasCookie = false;
        if (this.kerbConfManager.isRemembermeCookieEnabled() && req.getCookies() != null) {
            for (Cookie cookie : req.getCookies()) {
                if (!"seraph.rememberme.cookie".equals(cookie.getName()) && !"seraph.confluence".equals(cookie.getName())) continue;
                hasCookie = true;
                break;
            }
        }
        if (autoRedirect != null && !hasCookie && (this.hostApp.isForceLoginRequestMapped(req) && this.kerbConfManager.isRequireLogin() && this.kerbConfManager.isForceLogin() || this.hostApp.isMainLoginPage(req))) {
            this.performInstantRedirect(req, resp, autoRedirect);
        } else {
            this.hostApp.dispatchToLogin(req, resp, chain);
        }
    }

    protected final void performInstantRedirect(HttpServletRequest req, HttpServletResponse resp, IdpConfiguration idpConfiguration) throws IOException {
        String url;
        String target = this.hostApp.getRedirectTarget(req);
        ContextAware pathHelper = ContextAware.of(req);
        resp.setContentType("text/html");
        if (target != null) {
            url = target;
        } else {
            String qs;
            String string = qs = req.getQueryString() != null ? "?" + req.getQueryString() : "";
            if (this.hostApp.isMainLoginPage(req)) {
                if (StringUtils.isNotBlank((CharSequence)qs) && !StringUtils.contains((CharSequence)qs, (CharSequence)this.hostApp.getTargetParameterName())) {
                    qs = qs + "&" + this.hostApp.getTargetParameterName() + "=/";
                } else if (StringUtils.isBlank((CharSequence)qs)) {
                    qs = "?" + this.hostApp.getTargetParameterName() + "=/";
                }
            }
            url = req.getRequestURI() + qs;
            log.debug("Instant redirect: Target value built from query string: " + url);
        }
        if (!StringUtils.contains((CharSequence)url, (CharSequence)pathHelper.path("/rest/"))) {
            req.getSession().setAttribute("samlInstantLoginUrl", (Object)url);
        }
        url = this.idpConfManager.getServiceProviderLoginUrl(req, idpConfiguration.getId()) + "?target=" + HttpUrlUtils.urlEncode(url);
        log.debug("Instant redirect: Return value sent to IdP: " + url);
        if (idpConfiguration.isHostedDomain() && idpConfiguration.getKnownDomains().iterator().hasNext()) {
            url = url + "&hd=" + (String)idpConfiguration.getKnownDomains().iterator().next();
        }
        resp.getWriter().print("<html><head><meta http-equiv=\"refresh\" content=\"1;URL='" + StringEscapeUtils.escapeHtml((String)url) + "'\" /></head><p>Redirecting to sign-on..</p></html>");
    }

    public void destroy() {
    }

    private Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        return AtlasKerberosMainAuthFilter.authenticateWithProduct(req, res, user, this.kerbConfManager, this.hostApp);
    }

    public static Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user, KerbConfManager kerbConfManager, HostApp hostApp) {
        if (kerbConfManager.isRemembermeCookieEnabled()) {
            hostApp.setRememberMeCookie(req, res, user.getName());
        }
        return hostApp.authenticateWithProduct(req, res, user);
    }
}

