/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.model;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.connector.model.UserLookupTransform;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;

public abstract class Directory
implements DebugInfo {
    private final String id;
    private final String kind;
    private final String password;
    private final Set<String> remoteAddresses;
    protected final Properties properties = new Properties();
    private UserMembershipFilter userMembershipFilter;
    private GroupFilter groupFilter;
    private UserTypeSelectionFilter userTypeFilter;
    private UserLookupTransform usernameTransformation;
    private ObjectTypeFilter objectTypeFilter;
    private SecurityGroupFilter securityGroupFilter;

    public Directory(Common common) {
        this.id = common.getId();
        this.kind = common.getKind();
        this.password = common.getPassword();
        this.remoteAddresses = common.getRemoteAddresses();
        this.groupFilter = common.getGroupFilter();
        this.userMembershipFilter = common.getUserMembershipFilter();
        this.userTypeFilter = common.getUserTypeFilter();
        this.usernameTransformation = common.getUsernameTransformation();
        this.objectTypeFilter = common.getObjectTypeFilter() != null ? common.getObjectTypeFilter() : ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("properties", (Map)this.properties);
        json.put("kind", (Object)this.kind);
        json.put("id", (Object)this.id);
        json.put("remoteAddresses", this.remoteAddresses);
        json.put("userMembershipFilter", (Object)this.userMembershipFilter.asJson());
        json.put("groupFilter", (Object)this.groupFilter.asJson());
        json.put("userTypeFilter", (Object)this.userTypeFilter.asJson());
        json.put("usernameTransformation", (Object)this.usernameTransformation);
        json.put("objectTypeFilter", (Object)this.objectTypeFilter);
        json.put("securityGroupFilter", (Object)this.securityGroupFilter);
        return json;
    }

    public String getKind() {
        return this.kind;
    }

    public String getId() {
        return this.id;
    }

    public String getPassword() {
        return this.password;
    }

    public abstract String getDisplayName();

    public Set<String> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public UserTypeSelectionFilter getUserTypeSelectionFilter() {
        return this.userTypeFilter;
    }

    public UserMembershipFilter getUserMembershipFilter() {
        return this.userMembershipFilter;
    }

    public String toString() {
        return this.getId() + "/" + this.getDisplayName();
    }

    public void setUserMembershipFilter(UserMembershipFilter groupFilter) {
        this.userMembershipFilter = groupFilter;
    }

    public GroupFilter getGroupFilter() {
        return this.groupFilter;
    }

    public void setGroupFilter(GroupFilter groupFilter) {
        this.groupFilter = groupFilter;
    }

    public void setUserTypeFilter(UserTypeSelectionFilter userTypeFilter) {
        this.userTypeFilter = userTypeFilter;
    }

    public UserLookupTransform getUsernameTransformation() {
        return this.usernameTransformation;
    }

    public void setUsernameTransformation(UserLookupTransform usernameTransformation) {
        this.usernameTransformation = usernameTransformation;
    }

    public ObjectTypeFilter getObjectTypeFilter() {
        return this.objectTypeFilter;
    }

    public void setObjectTypeFilter(ObjectTypeFilter objectTypeFilter) {
        this.objectTypeFilter = objectTypeFilter;
    }

    public SecurityGroupFilter getSecurityGroupFilter() {
        return this.securityGroupFilter;
    }

    public void setSecurityGroupFilter(SecurityGroupFilter securityGroupFilter) {
        this.securityGroupFilter = securityGroupFilter;
    }

    public static class Common {
        private final String id;
        private final String kind;
        private final String password;
        private final Set<String> remoteAddresses;
        private final UserMembershipFilter userMembershipFilter;
        private final GroupFilter groupFilter;
        private final UserTypeSelectionFilter userTypeFilter;
        private final ObjectTypeFilter objectTypeFilter;
        private final UserLookupTransform usernameTransformation;

        public Common(String id, String kind, String password, Set<String> remoteAddresses, UserMembershipFilter userMembershipFilter, GroupFilter groupFilter, UserTypeSelectionFilter userTypeFilter, ObjectTypeFilter objectTypeFilter, UserLookupTransform usernameTransformation) {
            this.id = id;
            this.kind = kind;
            this.password = password;
            this.remoteAddresses = remoteAddresses;
            this.userMembershipFilter = userMembershipFilter;
            this.groupFilter = groupFilter;
            this.userTypeFilter = userTypeFilter;
            this.objectTypeFilter = objectTypeFilter;
            this.usernameTransformation = usernameTransformation;
        }

        public String getId() {
            return this.id;
        }

        public String getKind() {
            return this.kind;
        }

        public String getPassword() {
            return this.password;
        }

        public Set<String> getRemoteAddresses() {
            return this.remoteAddresses;
        }

        public UserMembershipFilter getUserMembershipFilter() {
            return this.userMembershipFilter;
        }

        public GroupFilter getGroupFilter() {
            return this.groupFilter;
        }

        public UserTypeSelectionFilter getUserTypeFilter() {
            return this.userTypeFilter;
        }

        public ObjectTypeFilter getObjectTypeFilter() {
            return this.objectTypeFilter;
        }

        public UserLookupTransform getUsernameTransformation() {
            return this.usernameTransformation;
        }
    }
}

