/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.userlookup;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserResolutionException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.prometheus.client.Summary;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.diagnostics.metrics.KSSOPluginMetrics;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.kerberos.AtlDirectoryManager;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.userlookup.UserNameLookup;
import org.kantega.atlaskerb.userlookup.UsernameTransformAction;
import org.kantega.atlaskerb.utils.AuthMethod;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserLookupService
implements DebugInfo {
    public static final String KSSO_TRADITIONAL_LOGIN_ALLOWED = "ksso.traditional.login.allowed";
    public static final String KSSO_BASIC_AUTH_ALLOWED = "ksso.basic.auth.allowed";
    public static final String KSSO_KERBEROS_LOGIN_ALLOWED = "ksso.kerberos.login.allowed";
    private static final Logger log = LoggerFactory.getLogger(UserLookupService.class);
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final AtlDirectoryManager directoryManager;
    private final Map<UsernameTransformAction, Integer> utaWeights;
    private final Queue<UsernameTransformAction> utaIndexLog;
    private final HostApp hostApp;
    private final Map<String, Boolean> activeDirectoryCache = new ConcurrentHashMap<String, Boolean>();
    private final Cache<String, Object> oneMinuteCache;

    @Inject
    public UserLookupService(@ComponentImport UserManager userManager, KerbConfManager kerbConfManager, HostAppFactory hostAppFactory, AtlDirectoryManager directoryManager, IdpConfManager idpConfManager) {
        this.userManager = userManager;
        this.kerbConfManager = kerbConfManager;
        this.directoryManager = directoryManager;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.utaWeights = new HashMap<UsernameTransformAction, Integer>();
        this.utaIndexLog = new LinkedList<UsernameTransformAction>();
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    private void registerUta(UsernameTransformAction action) {
        int MAX_LOG_SIZE = 100;
        Integer count = this.getUtaWeights().get((Object)action);
        if (count == null) {
            this.getUtaWeights().put(action, 1);
        } else {
            this.getUtaWeights().put(action, count + 1);
        }
        if (this.utaIndexLog.size() <= 100) {
            return;
        }
        UsernameTransformAction removedAction = this.utaIndexLog.remove();
        this.getUtaWeights().put(removedAction, this.getUtaWeights().get((Object)removedAction) - 1);
    }

    private Collection<UsernameTransformAction> sortAndFilterUTAs(Collection<UsernameTransformAction> unsortedUTAs, boolean onlyRegexTransformationLookup) {
        if (!onlyRegexTransformationLookup || StringUtils.isBlank((String)this.kerbConfManager.getRegexReplacement()) || StringUtils.isBlank((String)this.kerbConfManager.getRegexLookup())) {
            if (this.getUtaWeights().isEmpty()) {
                return unsortedUTAs;
            }
            ArrayList<UsernameTransformAction> utaList = new ArrayList<UsernameTransformAction>(unsortedUTAs);
            utaList.forEach(transformAction -> {
                if (!this.getUtaWeights().containsKey(transformAction)) {
                    this.getUtaWeights().put((UsernameTransformAction)((Object)transformAction), 0);
                }
            });
            utaList.sort((uta1, uta2) -> this.getUtaWeights().get(uta2).compareTo(this.getUtaWeights().get(uta1)));
            if (utaList.remove((Object)UsernameTransformAction.REGEX)) {
                utaList.add(0, UsernameTransformAction.REGEX);
            }
            return utaList;
        }
        if (unsortedUTAs.contains((Object)UsernameTransformAction.REGEX)) {
            return Collections.singletonList(UsernameTransformAction.REGEX);
        }
        return Collections.emptyList();
    }

    Map<UsernameTransformAction, Integer> getUtaWeights() {
        return this.utaWeights;
    }

    public Collection<UsernameTransformAction> sortAndFilterUTAs(Map<UsernameTransformAction, String> lookupNames, boolean onlyRegexTransformationLookup) {
        return new ArrayList<UsernameTransformAction>(this.sortAndFilterUTAs(lookupNames.keySet(), onlyRegexTransformationLookup));
    }

    public PrincipalEntry lookupUserForKerberos(String userPrincipalName, boolean addDefaultGroups) {
        for (Directory directory : this.getActiveUserDirectories()) {
            Map<UsernameTransformAction, String> lookupNames = this.findLookupNamesInDir(userPrincipalName, directory);
            List sortedUTAs = (List)this.sortAndFilterUTAs(lookupNames, this.kerbConfManager.isOnlyRegexTransformationLookup());
            if (lookupNames.isEmpty()) continue;
            for (UsernameTransformAction action : sortedUTAs) {
                PrincipalEntry principalEntry = this.resolveUserInDirectory(directory, lookupNames.get((Object)action), addDefaultGroups);
                if (principalEntry.getUserState() == PrincipalEntry.UserState.NOT_FOUND || principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) continue;
                this.registerUta(action);
                return principalEntry;
            }
        }
        Map<UsernameTransformAction, String> fallbackNames = this.getAccountNamesForLookup(userPrincipalName);
        return this.resolveUser(fallbackNames);
    }

    @NotNull
    public PrincipalEntry resolveUser(String username) {
        return (PrincipalEntry)Option.of((Object)username).map(arg_0 -> ((CrowdService)this.hostApp.getCrowdService()).getUser(arg_0)).toTry().mapTry((CheckedFunction1 & Serializable)user -> new PrincipalEntry(this.userManager.resolve(username), user.isActive() ? PrincipalEntry.UserState.FOUND : PrincipalEntry.UserState.INACTIVE)).onFailure(UserResolutionException.class, e -> log.debug("User not found: {}", (Object)username)).toOption().onEmpty(() -> log.debug("No users resolved for username " + username)).getOrElse((Object)new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND));
    }

    @NotNull
    private PrincipalEntry resolveUser(Map<UsernameTransformAction, String> lookupNames) {
        CrowdService crowdService = this.hostApp.getCrowdService();
        ArrayList<UsernameTransformAction> sortedUTAs = new ArrayList<UsernameTransformAction>(this.sortAndFilterUTAs(lookupNames.keySet(), this.kerbConfManager.isOnlyRegexTransformationLookup()));
        for (UsernameTransformAction action : sortedUTAs) {
            String username = lookupNames.get((Object)action);
            User user = crowdService.getUser(username);
            if (user == null) continue;
            log.debug("Resolved user {}", (Object)username);
            this.registerUta(action);
            PrincipalEntry.UserState state = user.isActive() ? PrincipalEntry.UserState.FOUND : PrincipalEntry.UserState.INACTIVE;
            return new PrincipalEntry(this.userManager.resolve(username), state);
        }
        log.debug("No users resolved");
        return new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalEntry resolveUserInDirectory(Directory directory, String username, boolean addDefaultGroups) {
        try (Summary.Timer timer = KSSOPluginMetrics.resolveUserInDirectoryLatency.startTimer();){
            com.atlassian.crowd.model.user.User user = this.hostApp.getDirectoryManager().findUserByName(directory.getId().longValue(), username);
            log.debug(String.format("Found user.name '%s', user.firstname: '%s', user.lastname: '%s' in directory '%s' with username '%s'", user.getName(), user.getFirstName(), user.getLastName(), directory.getName(), username));
            if (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR) {
                this.hostApp.optionallyUpdateUserFromRemoteDirectory(user.getName(), directory, this.isNewlyCreatedUser(user));
                if (directory.getType() == DirectoryType.CROWD) {
                    this.hostApp.optionallyAddCrowdGroups(user);
                }
            } else if (directory.getType() == DirectoryType.DELEGATING && !this.isJITDirectory(directory.getId())) {
                this.hostApp.optionallyUpdateDelegatedUser(directory, user);
            }
            if (user.isActive()) {
                PrincipalEntry principalEntry = new PrincipalEntry(this.userManager.resolve(username), PrincipalEntry.UserState.FOUND);
                if (addDefaultGroups && principalEntry.getPrincipal().isPresent() && "true".equals(directory.getAttributes().get("ksso.default.groups.enabled"))) {
                    this.hostApp.setDefaultGroups(principalEntry.getPrincipal().get(), directory);
                }
                PrincipalEntry principalEntry2 = principalEntry;
                return principalEntry2;
            }
            PrincipalEntry principalEntry = new PrincipalEntry(this.userManager.resolve(username), PrincipalEntry.UserState.INACTIVE);
            return principalEntry;
        }
        return new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
    }

    public PrincipalEntry resolveUserInDirectories(String username, boolean addDefaultGroups) {
        for (Directory directory : this.getActiveUserDirectories()) {
            PrincipalEntry principalEntry = this.resolveUserInDirectory(directory, username, addDefaultGroups);
            if (principalEntry.getUserState() == PrincipalEntry.UserState.NOT_FOUND) continue;
            return principalEntry;
        }
        Map<UsernameTransformAction, String> fallbackNames = this.getAccountNamesForLookup(username);
        log.debug("Looking up fallback users: {}", fallbackNames);
        return this.resolveUser(fallbackNames);
    }

    private boolean isNewlyCreatedUser(com.atlassian.crowd.model.user.User user) {
        boolean newlyCreatedUser = true;
        if (user instanceof TimestampedUser) {
            TimestampedUser tUser = (TimestampedUser)user;
            Instant creationInstant = tUser.getCreatedDate().toInstant();
            if (creationInstant.isBefore(Instant.now().minusSeconds(60L))) {
                newlyCreatedUser = false;
            }
        } else {
            log.debug("User {} not instance of TimestampedUser ({}); cannot determine if newly created", (Object)user.getName(), user.getClass());
        }
        return newlyCreatedUser;
    }

    public Map<UsernameTransformAction, String> findLookupNamesInDir(String userPrincipalName, Directory directory) {
        return this.findLookupNamesInDir(userPrincipalName, directory, this.kerbConfManager.getRegexLookup(), this.kerbConfManager.getRegexReplacement(), this.kerbConfManager.getAdditionalUserSuffix());
    }

    public Map<UsernameTransformAction, String> findLookupNamesInDir(String userPrincipalName, Directory directory, String regexLookup, String regexReplacement, String additionalUserSuffix) {
        LinkedHashMap<UsernameTransformAction, String> lookupNames = new LinkedHashMap<UsernameTransformAction, String>();
        String transformedPrincipalName = UserMappingUtils.regexTransformPairToResult(userPrincipalName, regexLookup, regexReplacement).getResult();
        if (StringUtils.isNotBlank((String)transformedPrincipalName)) {
            lookupNames.put(UsernameTransformAction.REGEX, transformedPrincipalName);
        }
        if (this.isMicrosoftActiveDirectory(directory)) {
            if (UserLookupService.isUpnRealmMatchesDirectory(userPrincipalName, directory)) {
                Map<UsernameTransformAction, String> msUsernames = this.getActiveDirectoryAccountNamesForLookup(userPrincipalName, directory);
                lookupNames.putAll(msUsernames);
                log.debug("Adding search accounts names for microsoft active directory {}", (Object)directory.getName());
            }
            return lookupNames;
        }
        return this.fallBackAccountNamesForLookup(userPrincipalName, directory, additionalUserSuffix, lookupNames);
    }

    @NotNull
    private Map<UsernameTransformAction, String> fallBackAccountNamesForLookup(String userPrincipalName, Directory directory, String additionalUserSuffix, Map<UsernameTransformAction, String> lookupNames) {
        Map<UsernameTransformAction, String> usernames = this.getAccountNamesForLookup(userPrincipalName, additionalUserSuffix);
        lookupNames.putAll(usernames);
        log.debug("getAccountNamesForLookup was called for directory {}", (Object)directory.getName());
        return lookupNames;
    }

    private Map<UsernameTransformAction, String> getActiveDirectoryAccountNamesForLookup(String userPrincipalName, Directory directory) {
        HashMap<UsernameTransformAction, String> msLookupNames = new HashMap<UsernameTransformAction, String>();
        if (StringUtils.isNotBlank((String)userPrincipalName)) {
            String userPart = userPrincipalName.substring(0, userPrincipalName.lastIndexOf("@"));
            if (userPart.contains("@")) {
                String username = new UserNameLookup(directory.getAttributes(), this.hostApp, this.kerbConfManager).lookupUserNameFromUserPrincipalName(userPart);
                if (StringUtils.isNotBlank((String)username)) {
                    msLookupNames.put(UsernameTransformAction.USER_PRINCIPAL_NAME, username);
                }
            } else if (this.isNonStandardUsernameDirectory(directory)) {
                String nonSamAccountName = new UserNameLookup(directory.getAttributes(), this.hostApp, this.kerbConfManager).lookupUserNameFromSamAccountNameAtRealm(userPrincipalName);
                log.debug(String.format("Looked up username '%s' from AD user directory '%s' using sAMAccountName '%s'", nonSamAccountName, directory.getName(), userPart));
                if (StringUtils.isNotBlank((String)nonSamAccountName)) {
                    msLookupNames.put(UsernameTransformAction.NON_STANDARD_NAME_ATTRIBUTE, nonSamAccountName);
                }
            } else {
                msLookupNames.put(UsernameTransformAction.SAM_ACCOUNT_NAME, userPrincipalName.substring(0, userPrincipalName.indexOf("@")));
            }
        }
        return msLookupNames;
    }

    static boolean isUpnRealmMatchesDirectory(String userPrincipalName, Directory directory) {
        Map attributes = directory.getAttributes();
        String baseDn = (String)attributes.get("ldap.basedn");
        String userDn = (String)attributes.get("ldap.user.dn");
        if (StringUtils.isBlank((String)baseDn)) {
            return false;
        }
        String searchBase = StringUtils.isNotBlank((String)userDn) ? userDn + "," + baseDn : baseDn;
        String logDetails = String.format("Performing isUpnRealmMatchesDirectory basedn: '%s', userDn '%s', searchBase: '%s' and userPrincipalName: '%s'", baseDn, userDn, searchBase, userPrincipalName);
        SanitizedLogStatement.of(logDetails).andThenLog(arg_0 -> ((Logger)log).debug(arg_0));
        String realm = userPrincipalName.substring(userPrincipalName.lastIndexOf("@") + 1);
        return UserLookupService.isRealmMatchesLdapName(realm, baseDn, searchBase);
    }

    static boolean isRealmMatchesLdapName(String realm, String baseDn, String searchBase) {
        try {
            String normalizedBaseDn = UserLookupService.toNormalizedDomainName(new LdapName(baseDn));
            String normalizedSearchBase = UserLookupService.toNormalizedDomainName(new LdapName(searchBase));
            return StringUtils.endsWithIgnoreCase((String)normalizedSearchBase, (String)realm) || StringUtils.endsWithIgnoreCase((String)realm, (String)normalizedBaseDn);
        }
        catch (InvalidNameException e) {
            log.debug("Invalid searchBase {} and baseDn {}. Will be unable to determine match for realm {}", new Object[]{searchBase, baseDn, realm});
            return false;
        }
    }

    private static String toNormalizedDomainName(LdapName ldapName) {
        return ldapName.getRdns().stream().filter(rdn -> StringUtils.equalsIgnoreCase((String)"dc", (String)rdn.getType())).map(rdn -> (String)rdn.getValue()).map(StringUtils::upperCase).reduce("", (a, b) -> StringUtils.isBlank((String)a) ? b : b + "." + a);
    }

    Map<UsernameTransformAction, String> getAccountNamesForLookup(String maybeUserPrincipalName, String additionalUserSuffix) {
        HashMap<UsernameTransformAction, String> usernames = new HashMap<UsernameTransformAction, String>();
        Option.of((Object)maybeUserPrincipalName).filter(StringUtils::isNotBlank).peek(userPrincipalName -> {
            String username = StringUtils.substringBefore((String)userPrincipalName, (String)"@");
            usernames.put(UsernameTransformAction.USERNAME, username);
            usernames.put(UsernameTransformAction.USERNAME_LOWERCASE, username.toLowerCase());
            usernames.put(UsernameTransformAction.USERNAME_UPPERCASE, username.toUpperCase());
            usernames.put(UsernameTransformAction.USER_PRINCIPAL_NAME, (String)userPrincipalName);
            usernames.put(UsernameTransformAction.USER_PRINCIPAL_NAME_LOWERCASE, userPrincipalName.toLowerCase());
            usernames.put(UsernameTransformAction.USER_PRINCIPAL_NAME_UPPERCASE, userPrincipalName.toUpperCase());
            if (additionalUserSuffix != null) {
                String additional = username + "@" + additionalUserSuffix;
                usernames.put(UsernameTransformAction.ADDITIONAL_SUFFIX, additional);
                usernames.put(UsernameTransformAction.ADDITIONAL_SUFFIX_LOWERCASE, additional.toLowerCase());
                usernames.put(UsernameTransformAction.ADDITIONAL_SUFFIX_UPPERCASE, additional.toUpperCase());
            }
        });
        return usernames;
    }

    public Map<UsernameTransformAction, String> getAccountNamesForLookup(String userPrincipalName) {
        return this.getAccountNamesForLookup(userPrincipalName, this.kerbConfManager.getAdditionalUserSuffix());
    }

    public List<Directory> getActiveUserDirectories() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (!directory.isActive()) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public List<Directory> getDirectoriesAllowingKerberosLogin() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_KERBEROS_LOGIN_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    private List<Directory> getDirectoriesAllowingTraditionalLogin() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_TRADITIONAL_LOGIN_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    private List<Directory> getDirectoriesAllowingBasicAuth() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_BASIC_AUTH_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public List<Directory> getCachedDirectoriesAllowingBasicAuth() {
        try {
            List dirs = (List)this.oneMinuteCache.get((Object)"getDirectoriesAllowingBasicAuth", this::getDirectoriesAllowingBasicAuth);
            return dirs;
        }
        catch (ExecutionException e) {
            return new ArrayList<Directory>();
        }
        catch (Exception e) {
            log.debug("getCachedDirectoriesAllowingBasicAuth - failed to extract cache.");
            return null;
        }
    }

    public List<Directory> getCachedDirectoriesAllowingTraditionalLogin() {
        try {
            List dirs = (List)this.oneMinuteCache.get((Object)"getDirectoriesAllowingTraditionalLogin", this::getDirectoriesAllowingTraditionalLogin);
            return dirs;
        }
        catch (ExecutionException e) {
            return new ArrayList<Directory>();
        }
        catch (Exception e) {
            log.debug("getCachedDirectoriesAllowingTraditionalLogin - failed to extract cache.");
            return null;
        }
    }

    public void invalidateDirectoriesCache() {
        this.oneMinuteCache.invalidateAll();
    }

    private boolean isNonStandardUsernameDirectory(Directory directory) {
        String usernameAttribute = (String)directory.getAttributes().get("ldap.user.username");
        return this.isMicrosoftActiveDirectory(directory) && usernameAttribute != null && !"sAMAccountName".equalsIgnoreCase(usernameAttribute);
    }

    private boolean isMicrosoftActiveDirectory(Directory directory) {
        if (directory.getType() != DirectoryType.DELEGATING && directory.getType() != DirectoryType.CONNECTOR) {
            return false;
        }
        if (this.isDirectoryType(directory, "com.atlassian.crowd.directory.MicrosoftActiveDirectory")) {
            return true;
        }
        if (!this.isDirectoryType(directory, "com.atlassian.crowd.directory.GenericLDAP")) {
            return false;
        }
        String key = UserLookupService.getAdCacheKey(directory);
        Boolean cached = this.activeDirectoryCache.get(key);
        if (Boolean.TRUE.equals(cached)) {
            return true;
        }
        if (Boolean.FALSE.equals(cached)) {
            return false;
        }
        try {
            boolean isAD = this.directoryManager.getDomainDirectory(directory).isActiveDirectory();
            this.activeDirectoryCache.put(key, isAD);
            return isAD;
        }
        catch (NamingException e) {
            return false;
        }
    }

    private boolean isDirectoryType(Directory directory, String type) {
        return directory.getImplementationClass() != null && (type.equals(directory.getImplementationClass()) || directory.getAttributes() != null && "com.atlassian.crowd.directory.MicrosoftActiveDirectory".equals(directory.getAttributes().get("crowd.delegated.directory.type")));
    }

    private static String getAdCacheKey(Directory directory) {
        return directory.getId().toString() + "-" + directory.getUpdatedDate().getTime();
    }

    public boolean isLdapDirectory(Directory directory) {
        return directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.DELEGATING;
    }

    public boolean hasWritableCrowdDirectory() {
        for (Directory directory : this.getActiveUserDirectories()) {
            if (directory.getType() != DirectoryType.CROWD || !directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveLDAPDirectories() {
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!this.isLdapDirectory(directory)) continue;
            return true;
        }
        return false;
    }

    private boolean isJITDirectory(Long directoryId) {
        Iterator<IdpConfiguration> iterator = this.idpConfManager.getIdentityProviders().iterator();
        if (iterator.hasNext()) {
            IdpConfiguration idpConfig = iterator.next();
            boolean isJITActive = idpConfig.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idpConfig.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idpConfig.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL || idpConfig.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE;
            return idpConfig.getJitDirectory().isPresent() && idpConfig.getJitDirectory().get().equals(directoryId) && isJITActive;
        }
        return false;
    }

    public boolean hasUserAccess(HttpServletRequest request) {
        if (!this.hostApp.shouldCheckUserAccess()) {
            return true;
        }
        String userName = this.hostApp.getLoginRequestUsername(request);
        if (userName != null) {
            JiraHostApp.CanUseStatus canUseStatus = new JiraHostApp.CanUseStatus(userName).invoke();
            return canUseStatus.hasAnyRole() || canUseStatus.hasGlobalAdminPermission();
        }
        return false;
    }

    public List<UsernameSearchResult> searchUserAccount(String searchUsername, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, boolean addDefaultGroups) {
        ArrayList<UsernameSearchResult> results = new ArrayList<UsernameSearchResult>();
        for (Directory directory : this.getActiveUserDirectories()) {
            PrincipalEntry pe;
            String userLookupName = searchUsername;
            if (this.isLdapDirectory(directory) && userNotFoundPolicy == IdpConfiguration.UserNotFoundPolicy.REJECT && userLookupAttribute != IdpConfiguration.UserLookupAttribute.USERNAME) {
                String ldapUsername = new UserNameLookup(directory.getAttributes(), this.hostApp, this.kerbConfManager).lookupUserNameFromAttribute(userLookupAttribute.getAttributeName(), userLookupName);
                if (ldapUsername != null) {
                    userLookupName = ldapUsername;
                } else {
                    results.add(UsernameSearchResult.notFound(directory));
                    continue;
                }
            }
            if ((pe = this.resolveUserInDirectory(directory, userLookupName, addDefaultGroups)).getUserState() != PrincipalEntry.UserState.NOT_FOUND) {
                if (pe.getUserState() == PrincipalEntry.UserState.FOUND && pe.getPrincipal().isPresent()) {
                    String userAccountName = pe.getPrincipal().get().getName();
                    UserProfile userProfile = this.userManager.getUserProfile(userAccountName);
                    results.add(UsernameSearchResult.resolved(directory, pe, userProfile));
                    return results;
                }
                results.add(UsernameSearchResult.inactive(directory, pe));
                continue;
            }
            results.add(UsernameSearchResult.notFound(directory));
        }
        return results;
    }

    public boolean isUserInAllowedDirectoryOrGroup(HttpServletRequest req, List<Directory> dirsAllowing, HostApp hostApp, Set<String> allowingLoginGroups, Set<String> disallowingLoginGroups, String username, AuthMethod authMethod) {
        try {
            List<UsernameSearchResult> usernameSearchResult = null;
            if (username != null) {
                usernameSearchResult = this.searchUserAccount(username, IdpConfiguration.UserNotFoundPolicy.REJECT, IdpConfiguration.UserLookupAttribute.USERNAME, false);
            }
            if (usernameSearchResult != null) {
                UsernameSearchResult userFound = null;
                for (UsernameSearchResult usernameSearchResult2 : usernameSearchResult) {
                    if (usernameSearchResult2 == null || usernameSearchResult2.getUserProfile() == null) continue;
                    userFound = usernameSearchResult2;
                }
                if (userFound != null) {
                    Directory usernameDirectory = userFound.getDirectory();
                    for (Directory dir : dirsAllowing) {
                        if (!dir.getId().equals(usernameDirectory.getId())) continue;
                        log.debug("[ALLOW DIR] User " + username + " allowed exception to blocked traditional login since they are in the configured user directory " + dir.getName() + "(" + dir.getId() + ")");
                        return true;
                    }
                    for (String group : allowingLoginGroups) {
                        if (!hostApp.isUserInGroup(username, group)) continue;
                        log.debug("[ALLOW GROUP] User " + username + " allowed exception to blocked traditional login since they are member of the configured group " + group);
                        return true;
                    }
                    if (disallowingLoginGroups.size() > 0) {
                        boolean bl;
                        boolean bl2 = true;
                        for (String group : disallowingLoginGroups) {
                            if (!hostApp.isUserInGroup(username, group)) continue;
                            bl = false;
                            log.debug("[DENY GROUP] User " + username + " denied access to traditional login since they are member of the configured group " + group);
                            break;
                        }
                        return bl;
                    }
                }
            }
        }
        catch (RuntimeException r) {
            log.error(ErrorUtils.createErrorMessage("KSSO-KILKDR1VEI", "Problem when searching for user in directory: " + r));
        }
        return false;
    }

    @Override
    public JSONObject asJson() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        List directories = io.vavr.collection.List.ofAll(this.getActiveUserDirectories()).map(directory -> {
            JSONObject directoryJson = new JSONObject();
            directoryJson.put("isActive", directory.isActive());
            directoryJson.put("isEmpty", directory.isEmpty());
            directoryJson.put("name", (Object)directory.getName());
            directoryJson.put("attributes", (Object)new JSONObject(directory.getAttributes()));
            directoryJson.put("directoryType", (Object)directory.getType().name());
            directoryJson.put("description", (Object)directory.getDescription());
            directoryJson.put("encryptionType", (Object)directory.getEncryptionType());
            directoryJson.put("id", (Object)directory.getId());
            directoryJson.put("updatedDate", (Object)dateFormat.format(directory.getUpdatedDate().getTime()));
            directoryJson.put("createdDate", (Object)dateFormat.format(directory.getCreatedDate().getTime()));
            directoryJson.put("isAlwaysSyncGroups", this.hostApp.isAlwaysSyncGroups((Directory)directory));
            directoryJson.put("isSyncGroupsOnFirstCreated", this.hostApp.isSyncGroupsOnFirstCreated((Directory)directory));
            return directoryJson;
        }).toJavaList();
        JSONObject json = new JSONObject();
        json.put("directories", (Collection)directories);
        return json;
    }
}

