/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import io.vavr.collection.Stream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;

public class CrowdDirectoryFinder {
    private final CrowdDirectoryService crowdDirectoryService;
    private final TransactionTemplate transactionTemplate;

    public CrowdDirectoryFinder(HostApp hostApp) {
        this.crowdDirectoryService = hostApp.getCrowdDirectoryService();
        this.transactionTemplate = hostApp.getTransactionTemplate();
    }

    public Directory findDirectory(String id) {
        return (Directory)this.transactionTemplate.execute(() -> {
            for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
                if (directory.getType() != DirectoryType.CROWD) continue;
                for (String key : directory.getAttributes().keySet()) {
                    if (!"application.name".equals(key) || !id.equals(directory.getAttributes().get(key))) continue;
                    return directory;
                }
            }
            return null;
        });
    }

    public Directory findInternalDirectory() {
        List dirs = this.crowdDirectoryService.findAllDirectories();
        return (Directory)Stream.ofAll((Iterable)dirs).filter(dir -> dir.getType() == DirectoryType.INTERNAL).filter(dir -> StringUtils.containsIgnoreCase((CharSequence)dir.getName(), (CharSequence)"Internal Directory")).get();
    }
}

