/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.user.UserManager;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.kantega.atlaskerb.utils.DateTimeUtil;

public class ApiTokenUtil {

    public static class Validation {
        public static final String TOKEN_PREFIX = "API_TOKEN_";

        public static Try<Long> tryParseTokenTimeLimit(String tokenTimeLimit) {
            return Try.of((CheckedFunction0 & Serializable)() -> Long.parseLong(tokenTimeLimit));
        }

        public static boolean isValidDuration(long duration) {
            return DatePair.durationOptionsDays.stream().anyMatch(d -> ((DatePair)d).duration == duration) || duration <= DateTimeUtil.convertDaysToMillis(360L) && duration > 0L;
        }

        public static boolean validTokenTimeLimit(String tokenTimeLimit) {
            return (Boolean)Validation.tryParseTokenTimeLimit(tokenTimeLimit).mapTry(Validation::isValidDuration).getOrElse((Object)false);
        }

        public static boolean isValidDurationRestricted(long duration, long maximumDurationRestriction) {
            return maximumDurationRestriction == -1L ? Validation.isValidDuration(duration) : duration != -1L && Validation.isValidDuration(duration) && duration <= maximumDurationRestriction;
        }

        public static String removePrefixFromApiToken(String token) {
            if (Validation.apiTokenHasPrefix(token)) {
                return token.substring(TOKEN_PREFIX.length());
            }
            return token;
        }

        public static boolean apiTokenHasPrefix(String apiToken) {
            return (Boolean)Option.of((Object)apiToken).filter(token -> token.length() > TOKEN_PREFIX.length()).map(token -> token.substring(0, TOKEN_PREFIX.length())).map(prefixFromToken -> prefixFromToken.equals(TOKEN_PREFIX)).getOrElse((Object)false);
        }
    }

    public static class Time {
        public static String convertMillisToDays(long millis) {
            if (millis == -1L) {
                return "Forever";
            }
            return (String)DateTimeUtil.convertMillisToDays(millis).getOrElse((Object)"Forever");
        }

        public static long calculateTimeUntilExpiry(ApiTokenV570 apiTokenObject) {
            if (apiTokenObject.getValidFor() < 0L) {
                return apiTokenObject.getValidFor();
            }
            return apiTokenObject.getCreatedAt() + apiTokenObject.getValidFor() - System.currentTimeMillis();
        }

        public static String getExpiryDateTime(long createdAt, long validFor) {
            if (validFor < 0L) {
                return "Never";
            }
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(new Date(createdAt + validFor));
        }
    }

    public static enum TokenUserPermission {
        NO_USERS,
        ALL_USERS,
        USER_GROUPS;

    }

    public static class DatePair {
        private final Long duration;
        private final String englishDuration;
        static final long day = 86400000L;
        static final List<DatePair> durationOptionsDays = Arrays.asList(new DatePair(2592000000L, "30 Days"), new DatePair(7776000000L, "90 Days"), new DatePair(15552000000L, "180 Days"), new DatePair(31104000000L, "360 Days"), new DatePair(-1L, "Forever"));

        private DatePair(Long duration, String englishDuration) {
            this.duration = duration;
            this.englishDuration = englishDuration;
        }

        public Long getDuration() {
            return this.duration;
        }

        public Long getDurationAsDays() {
            if (this.duration == -1L) {
                return this.duration;
            }
            return this.duration / 86400000L;
        }

        public String getEnglishDuration() {
            return this.englishDuration;
        }

        public static List<DatePair> getDurationOptionsRestricted(long maximumDurationRestriction) {
            if (maximumDurationRestriction == -1L) {
                return durationOptionsDays;
            }
            return durationOptionsDays.stream().filter(d -> d.duration != -1L).filter(d -> d.duration <= maximumDurationRestriction).collect(Collectors.toList());
        }

        public static List<DatePair> getDurationOptions() {
            return durationOptionsDays;
        }
    }

    public static class ApiTokenRepresentation {
        private final int id;
        private final String alias;
        private final String username;
        private final String description;
        private final long createdAt;
        private final long validFor;
        private final boolean active;
        private boolean isUserFound = false;

        public ApiTokenRepresentation(ApiTokenV570 t, UserManager userManager, ApiTokenService apiTokenService) {
            this.id = t.getID();
            this.alias = t.getTokenName();
            this.validFor = t.getValidFor();
            this.createdAt = t.getCreatedAt();
            this.username = (String)Option.of((Object)t.getUsername()).getOrElse((Object)"");
            this.isUserFound = (Boolean)Option.of((Object)t.getUsername()).map(username -> userManager.resolve(username) != null).getOrElse((Object)false);
            this.description = t.getDescription();
            this.active = apiTokenService.isTokenActive(String.valueOf(t.getID()));
        }

        public boolean isActive() {
            return this.active;
        }

        public String getCreatedDate() {
            return (String)DateTimeUtil.millisToDateTimeString(this.createdAt).getOrElse((Object)"");
        }

        public String getExpiryDate() {
            if (this.validFor < 0L) {
                return "Never";
            }
            return (String)DateTimeUtil.millisToDateTimeString(this.createdAt + this.validFor).getOrElse((Object)"");
        }

        public boolean isExpired() {
            return this.validFor > 0L && System.currentTimeMillis() > this.createdAt + this.validFor;
        }

        public boolean isUserFound() {
            return this.isUserFound;
        }

        public int getId() {
            return this.id;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getUsername() {
            return this.username;
        }

        public long getValidFor() {
            return this.validFor;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

