/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.regextranformation.RegexTransformationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpUserLookupServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(IdpUserLookupServlet.class);
    private static final String JOHN_DOE_EXAMPLE_COM = "john.doe@example.com";
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private IdpConfiguration configuration;
    private String requestId;

    @Inject
    public IdpUserLookupServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.requestId = IdpConfManager.IdpServletUtil.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(this.requestId);
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(req));
        JSONArray regexTransformations = new JSONArray();
        List<Pair<String, String>> regexTuples = this.configuration.getUserTransformationRegexes();
        List<RegexTransformationResult> validations = UserMappingUtils.regexTransformations(JOHN_DOE_EXAMPLE_COM, regexTuples);
        validations.forEach(result -> regexTransformations.put((Object)result.toJson()));
        List<Pair<UsernameAttribute, String>> usernameAttributePriority = this.configuration.getUsernameAttributePriority();
        for (int i = 0; i < usernameAttributePriority.size(); ++i) {
            model.put("usernameAttribute" + (i + 1), usernameAttributePriority.get(i).getLeft());
            model.put("customUsernameAttributeName" + (i + 1), usernameAttributePriority.get(i).getRight());
        }
        Optional<String> transformedUsername = UserMappingUtils.transformUsername(JOHN_DOE_EXAMPLE_COM, regexTuples);
        model.put("regexTransformationsWithHtml", regexTransformations.toString());
        model.put("userPrincipalName", JOHN_DOE_EXAMPLE_COM);
        model.put("regexTuples", regexTuples);
        model.put("noTransformation", IdpConfiguration.UserLookupTransform.NONE.toString());
        model.put("namePartTransformation", IdpConfiguration.UserLookupTransform.NAME_PART.toString());
        model.put("regexTransformation", IdpConfiguration.UserLookupTransform.REGEX.toString());
        model.put("selectedUserLookupTransform", this.configuration.getUserLookupTransform().toString());
        model.put("transformedUsername", transformedUsername.orElse("<no match>"));
        model.put("topMenu", "SAML");
        model.put("menuItem", "userLookupSettings");
        model.put("usernameAttributes", UsernameAttribute.values());
        model.put("idp", this.configuration);
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("serviceURL", this.idpConfManager.getServiceProviderLoginUrl(req, this.requestId));
        model.put("testingURL", this.idpConfManager.getServiceProviderTestUrl(req, this.requestId));
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataUrl(req, this.requestId));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("canAddUser", this.hostApp.canAddUser());
        model.put("defaultGroups", this.idpConfManager.commaSeparated(this.configuration.getDefaultGroups()));
        model.put("serverName", req.getServerName());
        model.put("test", req.getParameter("test"));
        this.getTemplateRenderer().render("templates/saml/idp-user-lookup.vm", model, (Writer)resp.getWriter());
    }

    private io.vavr.collection.List<Tuple2<String, String>> processRegexTuples(HttpServletRequest req) {
        int rowNumber = 0;
        io.vavr.collection.List inputRegexTuples = io.vavr.collection.List.empty();
        String regexLookup = req.getParameter("regexLookup" + rowNumber);
        String regexReplacement = req.getParameter("regexReplacement" + rowNumber);
        while (regexLookup != null && regexReplacement != null) {
            inputRegexTuples = inputRegexTuples.append((Object)Tuple.of((Object)regexLookup, (Object)regexReplacement));
            regexLookup = req.getParameter("regexLookup" + ++rowNumber);
            regexReplacement = req.getParameter("regexReplacement" + rowNumber);
        }
        return inputRegexTuples;
    }

    private void checkTransformation(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        io.vavr.collection.List<Tuple2<String, String>> regexTuples = this.processRegexTuples(req);
        String testUsername = (String)Option.of((Object)req.getParameter("transformationTestText")).map(StringUtils::trim).filter(StringUtils::isNotBlank).getOrElse((Object)"");
        JSONObject response = this.createTransformationJsonResponse(testUsername, regexTuples);
        resp.setContentType("application/json");
        resp.setStatus(200);
        resp.getWriter().print(response);
        resp.flushBuffer();
    }

    private JSONObject createTransformationJsonResponse(String testUsername, io.vavr.collection.List<Tuple2<String, String>> regexTuples) {
        JSONObject jsonObject = new JSONObject();
        JSONArray validations = this.createValidationsJsonResponse(regexTuples);
        JSONObject result = this.createResultJsonResponse(testUsername, regexTuples);
        jsonObject.put("validations", (Object)validations);
        jsonObject.put("result", (Object)result);
        return jsonObject;
    }

    private JSONArray createValidationsJsonResponse(io.vavr.collection.List<Tuple2<String, String>> regexTuples) {
        JSONArray validations = new JSONArray();
        io.vavr.collection.List<Either<String, Boolean>> regexTransformationResults = UserMappingUtils.validateRegexTransformations(regexTuples);
        int index = 0;
        for (Either regexTransformationResult : regexTransformationResults) {
            JSONObject result = new JSONObject();
            result.put("index", index);
            result.put("valid", regexTransformationResult.isRight());
            result.put("message", regexTransformationResult.isLeft() ? regexTransformationResult.getLeft() : "");
            validations.put((Object)result);
            ++index;
        }
        return validations;
    }

    private JSONObject createResultJsonResponse(String testUsername, io.vavr.collection.List<Tuple2<String, String>> regexTuples) {
        JSONObject result = new JSONObject();
        Tuple2 indexAndUsername = (Tuple2)UserMappingUtils.transformUsernameWithIndex(testUsername, regexTuples).getOrNull();
        if (indexAndUsername != null) {
            String username = (String)indexAndUsername.apply((i, name) -> name);
            result.put("username", (Object)username);
            JSONObject rule = new JSONObject();
            int index = (Integer)indexAndUsername.apply((i, name) -> i);
            rule.put("index", index);
            result.put("rule", (Object)rule);
        } else {
            result.put("username", (Object)testUsername);
            JSONObject rule = new JSONObject();
            rule.put("index", -1);
            result.put("rule", (Object)rule);
        }
        return result;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("checkTransformation") != null) {
            this.checkTransformation(req, resp);
            return;
        }
        String id = IdpConfManager.IdpServletUtil.getId(req);
        String action = req.getParameter("action");
        if ("editUserLookupSettings".equals(action)) {
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
            ArrayList<Pair<UsernameAttribute, String>> usernameAttributePriority = new ArrayList<Pair<UsernameAttribute, String>>();
            for (int i = 0; i < 3; ++i) {
                String attr = req.getParameter("usernameAttr" + (i + 1));
                if (!StringUtils.isNotBlank((CharSequence)attr)) continue;
                UsernameAttribute userAttr = UsernameAttribute.valueOf(attr);
                usernameAttributePriority.add((Pair<UsernameAttribute, String>)Pair.of((Object)((Object)userAttr), (Object)StringUtils.trim((String)req.getParameter("customUsernameAttributeName" + (i + 1)))));
            }
            builder.setUsernameAttributePriority(usernameAttributePriority);
            Optional.ofNullable(req.getParameter("userLookupAttribute")).map(StringUtils::trim).map(IdpConfiguration.UserLookupAttribute::valueOf).ifPresent(builder::setUserLookupAttribute);
            IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.valueOf(StringUtils.trim((String)req.getParameter("userLookupTransform")));
            builder.setUserLookupTransform(userLookupTransform);
            List regexTuples = this.processRegexTuples(req).filter(tuple -> StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._1)) && StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._2))).map(tuple -> Pair.of((Object)tuple._1, (Object)tuple._2)).asJava();
            if (userLookupTransform == IdpConfiguration.UserLookupTransform.REGEX) {
                builder.setUserTransformationRegexes(regexTuples);
            }
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        Map<String, Object> model = this.newModel(req);
        this.renderPage(req, resp, model);
    }
}

