/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDeskSignupFilter
implements Filter {
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final Logger log = LoggerFactory.getLogger(ServiceDeskSignupFilter.class);

    @Inject
    public ServiceDeskSignupFilter(@ComponentImport TemplateRenderer templateRenderer, KerbConfManager kerbConfManager) {
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = kerbConfManager;
    }

    public static String getEmailFromHeader(HttpServletRequest req, KerbConfManager kerbConfManager) {
        String remoteAddr = req.getRemoteAddr();
        String emailFromHeader = null;
        boolean headerUsernameIpUnblocked = InternetAddressUtils.isAddressPermissionMatch(remoteAddr, kerbConfManager.getHeaderUsernameIpUnblockedList());
        if (headerUsernameIpUnblocked && kerbConfManager.getHeaderEmailAttribute() != null) {
            emailFromHeader = req.getHeader(kerbConfManager.getHeaderEmailAttribute());
        }
        return ServiceDeskSignupFilter.isValidEmailAddress(emailFromHeader) ? emailFromHeader : null;
    }

    private static boolean isValidEmailAddress(String email) {
        boolean result = true;
        if (email == null) {
            return false;
        }
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        final String emailFromHeader = ServiceDeskSignupFilter.getEmailFromHeader(req, this.kerbConfManager);
        final String jsmSignupEmailUnblockedList = this.kerbConfManager.getJsmSignupEmailUnblockedList();
        final String jsmUrlFormUrlparts = this.kerbConfManager.getJsmSignupFormUrlparts();
        if (StringUtils.isNotBlank((String)emailFromHeader) || StringUtils.isNotBlank((String)jsmSignupEmailUnblockedList)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new HttpServletResponseWrapper(resp){
                ServletOutputStream out;

                public ServletOutputStream getOutputStream() throws IOException {
                    if (this.out == null) {
                        ServiceDeskSignupFilter.this.log.debug("Setting up ServiceDeskSignupFilter. ServletOutputStream out == null");
                        this.out = new InjectingOutputStream(emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts, super.getOutputStream());
                    }
                    return this.out;
                }
            });
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public void destroy() {
    }

    private class InjectingOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream out;
        private final byte[] headStart;
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;

        public InjectingOutputStream(String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts, ServletOutputStream outputStream) {
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
            this.out = outputStream;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int head = this.findHeadStart(b, off, len);
            if (head != -1) {
                this.out.write(b, off, head - off + this.headStart.length);
                StringWriter inject = new StringWriter();
                ServiceDeskSignupFilter.this.log.debug("Writing js changes. emailFromHeader: " + this.emailFromHeader);
                HashMap<String, String> model = new HashMap<String, String>();
                inject.append("<script type=\"text/javascript\">emailFromHeader = '").append(this.emailFromHeader).append("'</script>");
                inject.append("<script type=\"text/javascript\">jsmSignupEmailUnblockedList = '").append(this.jsmSignupEmailUnblockedList).append("'</script>");
                model.put("jsmSignupEmailUnblockedList", this.jsmSignupEmailUnblockedList);
                model.put("jsmUrlFormUrlparts", this.jsmUrlFormUrlparts);
                model.put("emailFromHeader", this.emailFromHeader);
                ServiceDeskSignupFilter.this.templateRenderer.render("templates/atlaskerb/jsm-signup-email.vm", model, (Writer)inject);
                this.out.write(inject.toString().getBytes(StandardCharsets.UTF_8));
                this.out.write(b, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                this.out.write(b, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }
    }
}

