/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupsFromLdapAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    public static final String DEFAULT_GROUPS_STRING = "ksso.default.groups.enabled";
    private final HostApp hostApp;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DefaultGroupsFromLdapAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "defaultGroupsFromLdap");
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("directories", this.userLookupService.getActiveUserDirectories());
        model.put("DEFAULT_GROUPS_STRING", DEFAULT_GROUPS_STRING);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/defaultGroupsFromLdap.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            if (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.INTERNAL) continue;
            String enableButton = req.getParameter("defaultGroupsEnable" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton) && StringUtils.isNotBlank((CharSequence)((CharSequence)directory.getAttributes().get("autoAddGroups")))) {
                    attrs.put(DEFAULT_GROUPS_STRING, "true");
                } else {
                    attrs.put(DEFAULT_GROUPS_STRING, "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error("Unable to update directory " + directory.getName(), (Throwable)u);
            }
        }
        resp.sendRedirect("defaultGroupsFromLdap");
    }
}

