/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.user.UserProfile;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;

public abstract class FederatedIdentityResponseEvaluationResult {
    private final IdpConfiguration idpConfiguration;
    private final List<AttributeInfo> attributeInfos;
    private final List<Pair<UsernameAttribute, String>> usernameAttributePriority;
    private IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping;
    private PrincipalEntry resolvedPrincipalEntry;
    private UserRecipe userRecipe;
    private boolean domainAllowed;
    private UserProfile userProfile;
    private String userDomain;
    private String searchedUsername;
    private List<UsernameSearchResult> searchResult;
    private boolean readOnlyDirectory;
    private Directory resolvedUserDirectory;
    private final GroupEvaluation groupEvaluation = new GroupEvaluation();

    public FederatedIdentityResponseEvaluationResult(IdpConfiguration idpConfiguration, List<AttributeInfo> attributeInfos, List<Pair<UsernameAttribute, String>> usernameAttributePriority, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping) {
        this.idpConfiguration = idpConfiguration;
        this.attributeInfos = attributeInfos;
        this.usernameAttributePriority = usernameAttributePriority;
        this.nameAttributeMapping = nameAttributeMapping;
    }

    public ResponseEvaluationCode getCode() {
        if (this.getIdpConfiguration().getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.REJECT && this.getResolvedPrincipalEntry() == null) {
            return ResponseEvaluationCode.USER_NOT_FOUND;
        }
        if (!this.isDomainAllowed()) {
            return ResponseEvaluationCode.DOMAIN_NOT_ALLOWED;
        }
        if (!(this.getIdpConfiguration().getUserNotFoundPolicy() != IdpConfiguration.UserNotFoundPolicy.CREATE || this.getUserProfile() == null && this.getUserRecipe() == null || this.getUserRecipe().isComplete())) {
            return ResponseEvaluationCode.USER_RECIPE_NOT_COMPLETE;
        }
        if (this.getResolvedPrincipalEntry() != null) {
            return ResponseEvaluationCode.SUCCESS_USER_EXISTS;
        }
        if (this.getUserRecipe() != null && this.getUserRecipe().isComplete() && !IdpConfManager.hasRequiredGroupsForCreation(this.getIdpConfiguration(), this.groupEvaluation)) {
            return ResponseEvaluationCode.MISSING_REQUIRED_GROUPS;
        }
        if (this.getUserRecipe() != null && this.getUserRecipe().isComplete()) {
            return ResponseEvaluationCode.SUCCESS_CAN_CREATE_USER;
        }
        return ResponseEvaluationCode.UNKNOWN;
    }

    public GroupEvaluation getGroupEvaluation() {
        return this.groupEvaluation;
    }

    public IdpConfiguration getIdpConfiguration() {
        return this.idpConfiguration;
    }

    public List<AttributeInfo> getAttributeInfos() {
        return this.attributeInfos;
    }

    public boolean isConfiguredUsernameAttributeFound() {
        for (AttributeInfo attributeInfo : this.attributeInfos) {
            if (this.usernameAttributePriority != null) {
                for (Pair<UsernameAttribute, String> pair : this.usernameAttributePriority) {
                    if (pair.getLeft() != attributeInfo.getUsernameAttribute()) continue;
                    return true;
                }
            }
            if (attributeInfo.getUsernameAttribute() != UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME || this.usernameAttributePriority == null) continue;
            for (Pair<UsernameAttribute, String> attr : this.usernameAttributePriority) {
                if (attr.getLeft() != UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME || !StringUtils.equals((CharSequence)attributeInfo.getName(), (CharSequence)((CharSequence)attr.getRight()))) continue;
                return true;
            }
        }
        return false;
    }

    public AttributeInfo getConfiguredUsernameAttributeInfo() {
        for (Pair<UsernameAttribute, String> pair : this.usernameAttributePriority) {
            for (AttributeInfo attributeInfo : this.attributeInfos) {
                if (attributeInfo == null || !StringUtils.isNotBlank((CharSequence)attributeInfo.getValue())) continue;
                if (pair.getLeft() != UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME && attributeInfo.getUsernameAttribute() == pair.getLeft()) {
                    return attributeInfo;
                }
                if (pair.getLeft() != UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME || !StringUtils.equals((CharSequence)attributeInfo.getName(), (CharSequence)((CharSequence)pair.getRight()))) continue;
                return attributeInfo;
            }
        }
        return null;
    }

    public void setResolvedPrincipalEntry(PrincipalEntry resolvedPrincipalEntry) {
        this.resolvedPrincipalEntry = resolvedPrincipalEntry;
    }

    public void setUserRecipe(UserRecipe userRecipe) {
        this.userRecipe = userRecipe;
    }

    public UserRecipe getUserRecipe() {
        return this.userRecipe;
    }

    public void setNameAttributeMapping(IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping) {
        this.nameAttributeMapping = nameAttributeMapping;
    }

    public IdpConfManager.NAME_ATTRIBUTE_MAPPING getNameAttributeMapping() {
        return this.nameAttributeMapping;
    }

    public PrincipalEntry getResolvedPrincipalEntry() {
        return this.resolvedPrincipalEntry;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public String getSearchedUsername() {
        return this.searchedUsername;
    }

    public void setSearchedUsername(String searchedUsername) {
        this.searchedUsername = searchedUsername;
    }

    public void setDomainAllowed(boolean domainAllowed) {
        this.domainAllowed = domainAllowed;
    }

    public boolean isDomainAllowed() {
        return this.domainAllowed;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public void setUserDomain(String userDomain) {
        this.userDomain = userDomain;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public void setSearchResult(List<UsernameSearchResult> searchResult) {
        this.searchResult = searchResult;
    }

    public List<UsernameSearchResult> getSearchResult() {
        return this.searchResult;
    }

    public boolean isUserDomainRejected() {
        return this.idpConfiguration.getUsernamePolicy() == IdpConfiguration.UsernamePolicy.KNOWN_DOMAINS && !this.isDomainAllowed();
    }

    public void setReadOnlyDirectory(boolean readOnlyDirectory) {
        this.readOnlyDirectory = readOnlyDirectory;
    }

    public boolean isReadOnlyDirectory() {
        return this.readOnlyDirectory;
    }

    public void setResolvedUserDirectory(Directory resolvedUserDirectory) {
        this.resolvedUserDirectory = resolvedUserDirectory;
    }

    public Directory getResolvedUserDirectory() {
        return this.resolvedUserDirectory;
    }

    public String getUsername() {
        if (this.getUserProfile() != null) {
            return this.getUserProfile().getUsername();
        }
        if (this.getUserRecipe() != null && this.getUserRecipe().isComplete()) {
            return this.getUserRecipe().getUsername().getValue();
        }
        return null;
    }

    public String getFullname() {
        if (this.getUserProfile() != null) {
            return this.getUserProfile().getFullName();
        }
        if (this.getUserRecipe() != null && this.getUserRecipe().isComplete()) {
            return this.getUserRecipe().getName().getValue();
        }
        return null;
    }
}

