/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Version
implements Comparable<Version> {
    public final List<Integer> numbers;
    public final boolean isSnapshot;
    private final Map<String, Integer> semanticVersions;
    public static final String MAJOR = "major";
    public static final String MINOR = "minor";
    public static final String PATCH = "patch";
    public final String stringValue;

    public Version(String version) {
        Option maybeVersion = Option.of((Object)version);
        this.stringValue = (String)maybeVersion.getOrElse((Object)"");
        this.isSnapshot = (Boolean)maybeVersion.map(ver -> ver.split("-")).filter(parts -> ((String[])parts).length >= 2).map(parts -> parts[1].equals("SNAPSHOT")).getOrElse((Object)false);
        this.numbers = (List)maybeVersion.map(ver -> ver.split("-")[0]).map(numberPart -> numberPart.split("\\.")).map(List::of).toTry().mapTry((CheckedFunction1 & Serializable)numbers -> numbers.map(Integer::parseInt)).getOrElse(List::empty);
        this.semanticVersions = HashMap.of((Object)MAJOR, (Object)Try.of((CheckedFunction0 & Serializable)() -> (Integer)this.numbers.get(0)).getOrElse((Object)-1), (Object)MINOR, (Object)Try.of((CheckedFunction0 & Serializable)() -> (Integer)this.numbers.get(1)).getOrElse((Object)-1), (Object)PATCH, (Object)Try.of((CheckedFunction0 & Serializable)() -> (Integer)this.numbers.get(2)).getOrElse((Object)-1));
    }

    public static Version of(String version) {
        return new Version(version);
    }

    public Option<Integer> getMajor() {
        return this.semanticVersions.get((Object)MAJOR);
    }

    public Option<Integer> getMinor() {
        return this.semanticVersions.get((Object)MINOR);
    }

    public Option<Integer> getPatch() {
        return this.semanticVersions.get((Object)PATCH);
    }

    public static Version empty() {
        return new Version("");
    }

    public String stringValue() {
        return this.stringValue;
    }

    public int buildNumber() {
        return (Integer)Try.of((CheckedFunction0 & Serializable)() -> (String)this.numbers.map(Object::toString).intersperse((Object)"00").append((Object)"00").foldLeft((Object)"", String::concat)).map(numbers -> {
            if (this.isSnapshot) {
                return numbers + "1";
            }
            return numbers;
        }).mapTry(Integer::parseInt).getOrElse((Object)-1);
    }

    public boolean isHigherThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isEqualTo(Version other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return "Version{stringValue='" + this.stringValue + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.compareTo(version) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.stringValue, this.isSnapshot);
    }

    @Override
    public int compareTo(@NonNull Version another) {
        int maxLength = Math.max(this.numbers.size(), another.numbers.size());
        for (int i = 0; i < maxLength; ++i) {
            int otherVersion;
            int thisVersion = i < this.numbers.size() ? (Integer)this.numbers.get(i) : 0;
            int n = otherVersion = i < another.numbers.size() ? (Integer)another.numbers.get(i) : 0;
            if (thisVersion == otherVersion) continue;
            return thisVersion < otherVersion ? -1 : 1;
        }
        return 0;
    }
}

