/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.crowdserver;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.entity.ErrorEntity;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.Sets;
import io.vavr.Tuple2;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.crowdserver.CrowdResponseDocumentHandler;
import org.kantega.atlaskerb.connector.crowdserver.DefaultCrowdResponseDocumentHandler;
import org.kantega.atlaskerb.connector.crowdserver.FilterUtils;
import org.kantega.atlaskerb.connector.crowdserver.SyncState;
import org.kantega.atlaskerb.connector.crowdserver.SyncStateRegistry;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.UserLookupTransform;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserCollection;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdApiHandler
extends AbstractHandler {
    private final ConnectorConfManager connectorConfManager;
    private final HostApp hostApp;
    private final PluginLicenseManager pluginLicenseManager;
    private static final Logger log = LoggerFactory.getLogger(CrowdApiHandler.class);
    private final CrowdDirectoryFinder crowdDirectoryFinder;
    private final SyncStateRegistry syncStateRegistry;

    @Inject
    public CrowdApiHandler(ConnectorConfManager connectorConfManager, HostApp hostApp, PluginLicenseManager pluginLicenseManager) {
        this.connectorConfManager = connectorConfManager;
        this.hostApp = hostApp;
        this.pluginLicenseManager = pluginLicenseManager;
        this.crowdDirectoryFinder = new CrowdDirectoryFinder(hostApp);
        this.syncStateRegistry = new SyncStateRegistry(hostApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String s, Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long start = System.nanoTime();
        try {
            List<String> activeConnectors = this.connectorConfManager.getDirectories().stream().map(conn -> conn.getId()).collect(Collectors.toList());
            this.syncStateRegistry.pruneStates(activeConnectors);
            this.handleRequest(req, resp);
        }
        catch (Throwable throwable) {
            request.setHandled(true);
            if (log.isDebugEnabled()) {
                String entityType = request.getParameter("entity-type");
                log.debug("Request for '{}' with entity-type={} processed in {} ms", new Object[]{request.getRequestURI(), entityType, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
            }
            throw throwable;
        }
        request.setHandled(true);
        if (log.isDebugEnabled()) {
            String entityType = request.getParameter("entity-type");
            log.debug("Request for '{}' with entity-type={} processed in {} ms", new Object[]{request.getRequestURI(), entityType, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        }
    }

    protected void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug("handleRequest '{}' with parameters: {} ", (Object)req.getRequestURI(), (Object)req.getParameterMap());
        resp.setHeader("X-Embedded-Crowd-Version", "Crowd/3.0.0)");
        UsernamePassword usernamePassword = this.parseUsernamePassword(req.getHeader("Authorization"));
        if (req.getRequestURI().endsWith("/authentication")) {
            resp.setStatus(400);
            String username = req.getParameter("username");
            if (usernamePassword == null) {
                this.sendUserNotFound(resp, username);
                return;
            }
            String id = usernamePassword.getUsername();
            Directory directory = this.connectorConfManager.getDirectory(id);
            try {
                com.atlassian.crowd.embedded.api.Directory cd = this.crowdDirectoryFinder.findDirectory(directory.getId());
                DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
                if (StringUtils.isNotBlank((CharSequence)username)) {
                    directoryManager.findUserByName(cd.getId().longValue(), username);
                    this.sendIncorrectPassword(resp);
                }
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                log.warn("Could not verify user password in synchronized cloud directory");
            }
            catch (UserNotFoundException e) {
                this.sendUserNotFound(resp, username);
            }
            return;
        }
        if (!this.isLicenseValid(resp)) {
            return;
        }
        if (usernamePassword == null) {
            this.unauthorized(resp);
            return;
        }
        String connectorId = usernamePassword.getUsername();
        String password = usernamePassword.getPassword();
        Directory directory = this.connectorConfManager.getDirectory(connectorId);
        if (directory == null) {
            this.unauthorized(resp);
            log.warn("No connector directory with id '{}'", (Object)connectorId);
            return;
        }
        String remoteAddress = req.getRemoteAddr();
        if (!directory.getRemoteAddresses().contains(remoteAddress)) {
            resp.setStatus(403);
            String msg = String.format("Client with address '%s' is forbidden to make requests to the connector '%s'", remoteAddress, directory.getId());
            resp.getWriter().write(msg);
            log.warn(msg);
            return;
        }
        if (password == null || !password.equals(directory.getPassword())) {
            log.warn("Connector request with invalid password. Check that Crowd directory configuration matches Connector.");
            this.unauthorized(resp);
            return;
        }
        try {
            ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(directory.getKind());
            com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(connectorId);
            crowdDirectory.getAttributes().get("useNestedGroups");
            long correlationId = this.syncStateRegistry.getCorrelationId(crowdDirectory);
            log.debug("handleRequest() connectorId: {} correlationId: {}", (Object)connectorId, (Object)correlationId);
            ConnectorAPI api = connectorType.getConnectorApi(directory);
            DefaultCrowdResponseDocumentHandler responseDocumentHandler = this.startDocument(resp);
            this.handleApiCall(req, resp, directory, responseDocumentHandler, api);
            responseDocumentHandler.endDocument();
        }
        catch (Exception e) {
            log.error("Exception occurred handling API call " + req.getMethod() + " " + req.getRequestURI() + " for connector '" + directory.getDisplayName() + "'", (Throwable)e);
            resp.setStatus(500);
        }
    }

    private DefaultCrowdResponseDocumentHandler startDocument(HttpServletResponse resp) {
        return DefaultCrowdResponseDocumentHandler.startDocument(resp);
    }

    private void sendIncorrectPassword(HttpServletResponse resp) {
        DefaultCrowdResponseDocumentHandler handler = this.startDocument(resp);
        handler.outputError("Failed to authenticate principal, password was invalid", "INVALID_USER_AUTHENTICATION");
        handler.endDocument();
    }

    private void sendUserNotFound(HttpServletResponse resp, String username) {
        DefaultCrowdResponseDocumentHandler handler = this.startDocument(resp);
        handler.outputError("User &lt;" + username + "&gt; does not exist", "USER_NOT_FOUND");
        handler.endDocument();
    }

    private boolean isLicenseValid(HttpServletResponse resp) throws IOException {
        Option license = this.pluginLicenseManager.getLicense();
        if (!license.isDefined()) {
            resp.setStatus(500);
            String msg = "License error: Kantega SSO does not have a license.";
            resp.getWriter().print(msg);
            log.warn(msg);
            return false;
        }
        if (!((PluginLicense)license.get()).isValid()) {
            resp.setStatus(500);
            String msg = "License error: App license for Kantega SSO is not valid. Consult UPM for details.";
            resp.getWriter().print(msg);
            log.warn(msg);
            return false;
        }
        return true;
    }

    private void handleApiCall(HttpServletRequest req, HttpServletResponse resp, Directory directory, CrowdResponseDocumentHandler responseHandler, ConnectorAPI connectorAPI) throws InterruptedException, DirectoryNotFoundException, OperationFailedException {
        if ("user".equals(req.getParameter("entity-type"))) {
            this.handleUsersRequest(directory, responseHandler, connectorAPI);
        } else if ("group".equals(req.getParameter("entity-type"))) {
            this.handleGroupsRequest(directory, responseHandler);
        } else if (req.getRequestURI().endsWith("/1/group")) {
            this.handleSingleGroupRequest(req, resp, directory, responseHandler);
        } else if (req.getRequestURI().endsWith("/1/user")) {
            this.handleSingleUserRequest(req, resp, directory, responseHandler);
        } else if (req.getRequestURI().endsWith("/membership")) {
            this.handleMembershipsRequest(directory, responseHandler);
        } else {
            resp.setStatus(400);
        }
    }

    private void handleMembershipsRequest(Directory directory, CrowdResponseDocumentHandler handler) {
        handler.startMemberships();
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            SyncState syncState = this.syncStateRegistry.getSyncState(directory);
            syncState.getMemberships().forEach(handler::outputMembership);
        }
        handler.endMemberships();
    }

    private void handleSingleUserRequest(HttpServletRequest req, HttpServletResponse resp, Directory directory, CrowdResponseDocumentHandler responseHandler) throws DirectoryNotFoundException, OperationFailedException {
        if ("GET".equals(req.getMethod())) {
            String username = req.getParameter("username");
            com.atlassian.crowd.embedded.api.Directory cd = this.crowdDirectoryFinder.findDirectory(directory.getId());
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            try {
                User crowdUser = directoryManager.findUserByName(cd.getId().longValue(), username);
                UserItem user = UserItem.cloneFromCrowdUser(crowdUser);
                responseHandler.outputUser(user);
            }
            catch (UserNotFoundException e) {
                resp.setStatus(404);
                responseHandler.outputError(username + " does not exist", ErrorEntity.ErrorReason.USER_NOT_FOUND.name());
            }
        }
    }

    private void handleSingleGroupRequest(HttpServletRequest req, HttpServletResponse resp, Directory directory, CrowdResponseDocumentHandler handler) {
        if ("GET".equals(req.getMethod())) {
            String groupName = req.getParameter("groupname");
            InternalDirectoryGroup group = null;
            if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
                try {
                    com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(directory.getId());
                    group = this.findGroupByName(groupName, crowdDirectory).orElse(null);
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    throw new RuntimeException("Failed to retrieve '" + groupName + "'", e);
                }
            }
            if (group != null && !group.isLocal()) {
                GroupItem gi = new GroupItem();
                gi.setName(groupName);
                gi.setActive(group.isActive());
                gi.setDescription(group.getDescription());
                handler.outputGroup(gi);
            } else {
                resp.setStatus(404);
                handler.outputError("Group not found: " + groupName, ErrorEntity.ErrorReason.GROUP_NOT_FOUND.name());
            }
        }
    }

    private Optional<InternalDirectoryGroup> findGroupByName(String groupName, com.atlassian.crowd.embedded.api.Directory directory) throws DirectoryNotFoundException, OperationFailedException {
        DirectoryManager dm = this.hostApp.getDirectoryManager();
        EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)new TermRestriction(GroupTermKeys.NAME, MatchMode.EXACTLY_MATCHES, (Object)groupName)).returningAtMost(1);
        List results = dm.searchGroups(directory.getId().longValue(), groupQuery);
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(0));
    }

    private void handleGroupsRequest(Directory directory, CrowdResponseDocumentHandler handler) {
        handler.startGroups();
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            SyncState syncState = this.syncStateRegistry.getSyncState(directory);
            syncState.getGroups().forEach(handler::outputGroup);
        }
        handler.endGroups();
    }

    private void handleUsersRequest(Directory directory, CrowdResponseDocumentHandler handler, ConnectorAPI api) throws InterruptedException {
        handler.startUsers();
        UserLookupTransform usernameTransformation = directory.getUsernameTransformation();
        UserTypeSelectionFilter userTypeSelectionFilter = directory.getUserTypeSelectionFilter();
        log.debug("Starting user fetch from API: {}, selectionMode: {}, transformation: {}", new Object[]{api.getClass().getName(), userTypeSelectionFilter.getMode(), usernameTransformation});
        HashSet<UserItem> usersOfType = new HashSet<UserItem>();
        api.findAllUsers(userItem -> {
            if (FilterUtils.isUserTypeAccepted(userItem, userTypeSelectionFilter)) {
                UserItem renamed = this.transformUser(userItem, usernameTransformation);
                usersOfType.add(renamed);
            }
            handler.keepalive();
        });
        GroupFilter groupFilter = directory.getGroupFilter();
        UserMembershipFilter userMembershipFilter = directory.getUserMembershipFilter();
        HashSet<GroupItem> groups = new HashSet<GroupItem>();
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            log.debug("Starting group fetch from API: {}", (Object)api.getClass().getName());
            api.findAllGroups(groupItem -> {
                if (FilterUtils.isMembershipRetrievalRequired(groupItem, groupFilter, userMembershipFilter)) {
                    groups.add(groupItem);
                }
                handler.keepalive();
            });
        }
        HashSet memberships = Sets.newHashSetWithExpectedSize((int)groups.size());
        com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(directory.getId());
        boolean useNestedGroups = StringUtils.equals((CharSequence)"true", (CharSequence)((CharSequence)crowdDirectory.getAttributes().get("useNestedGroups")));
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            log.debug("Starting membership fetch from API: {}. useNestedGroups: {}", (Object)api.getClass().getName(), (Object)useNestedGroups);
            api.findAllMemberships(usersOfType, groups, membershipItem -> {
                memberships.add(this.transformMembershipItem(membershipItem, usernameTransformation));
                handler.keepalive();
            }, useNestedGroups);
        }
        Set<GroupItem> filteredGroups = FilterUtils.filterGroupsByGroup(groups, groupFilter);
        Tuple2<Set<UserItem>, Set<MembershipItem>> filteredUsers = FilterUtils.filterUsersByMemberships(usersOfType, memberships, groupFilter, userMembershipFilter);
        handler.keepalive();
        this.syncStateRegistry.createSyncState(directory, (Set)filteredUsers._1, filteredGroups, (Set)filteredUsers._2);
        ((Set)filteredUsers._1).forEach(handler::outputUser);
        handler.endUsers();
    }

    private String transformUsername(String username, UserLookupTransform userLookupTransform) {
        if (UserLookupTransform.NAME_PART == userLookupTransform) {
            return StringUtils.substringBefore((String)username, (String)"@");
        }
        return username;
    }

    private UserItem transformUser(UserItem user, UserLookupTransform userLookupTransform) {
        UserItem out = UserItem.clone(user);
        out.setName(this.transformUsername(user.getName(), userLookupTransform));
        return out;
    }

    private MembershipItem transformMembershipItem(MembershipItem membershipItem, UserLookupTransform usernameTransformation) {
        if (usernameTransformation == UserLookupTransform.NONE) {
            return membershipItem;
        }
        List<UserMember> userMembers = membershipItem.getUserCollection().getUsers().stream().map(u -> new UserMember(this.transformUsername(u.getName(), usernameTransformation))).collect(Collectors.toList());
        return new MembershipItem(membershipItem.getName(), new UserCollection(userMembers));
    }

    private void unauthorized(HttpServletResponse resp) {
        resp.addHeader("WWW-Authenticate", "Basic realm=\"Kantega SSO Connector API\"");
        resp.setStatus(401);
    }

    private UsernamePassword parseUsernamePassword(String authorization) {
        return (UsernamePassword)io.vavr.control.Option.of((Object)authorization).filter(auth -> auth.startsWith("Basic ")).map(auth -> auth.substring("Basic ".length())).map(Base64::decodeBase64).map(String::new).map(up -> up.split(":")).filter(up -> ((String[])up).length == 2).map(up -> new UsernamePassword(up[0], up[1])).getOrNull();
    }

    private static class UsernamePassword {
        final String username;
        final String password;

        public UsernamePassword(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

