/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.DisableTraditionalLoginServlet;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.LoginAttempt;
import org.kantega.atlaskerb.ManualLoginEvent;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.diagnostics.FailureListener;
import org.kantega.atlaskerb.hostapp.AuthContextPreservableHttpServletRequest;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservableHeaderAwareResponse;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.restapi.access.RestrictAPIEndpoint;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.restapi.access.UnblockAPIEndpoint;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SSOScriptLoginHookCondition;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.AuthMethod;
import org.kantega.atlaskerb.utils.ContextAware;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.SpNegoResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasKerberosFilter
implements Filter {
    public static final String LOCKOUT_TIMESTAMP = "lockout_timestamp";
    public static final String USERNAME_ANONYMOUS_USER = "usernameAnonymousUser";
    private static final Logger log = LoggerFactory.getLogger(AtlasKerberosFilter.class);
    private static final Logger manualLoginLog = LoggerFactory.getLogger(ManualLoginEvent.class);
    private static final String ALREADY_MATCHED_ATTR = AtlasKerberosFilter.class.getName() + "_alreadyMatched";
    private static final String ALREADY_FILTERED = "loginfilter.already.filtered";
    private final KerbConfManager kerbConfManager;
    private final FailureListener failureListener;
    private final AuditLogFacade auditLogFacade;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SSOScriptLoginHookCondition loginScriptCondition;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final UserLookupService userLookupService;
    private final WebResourceManager webResourceManager;
    private String[] products;

    @Inject
    public AtlasKerberosFilter(@ComponentImport HttpContext httpContext, @ComponentImport WebResourceManager webResourceManager, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, FailureListener failureListener, AuditLogFacade auditLogFacade, RequireAdminServletDependencyBucket bucket) {
        this.kerbConfManager = bucket.getKerbConfManager();
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.failureListener = failureListener;
        this.auditLogFacade = auditLogFacade;
        this.userLookupService = bucket.getUserLookupService();
        this.webResourceManager = webResourceManager;
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.idpConfManager = bucket.getIdpConfManager();
        this.loginScriptCondition = new SSOScriptLoginHookCondition(httpContext, bucket);
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean clientAllowedBasicAuth;
        String internalPath;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        boolean alreadyMatched = req.getAttribute(ALREADY_MATCHED_ATTR) != null;
        this.setNokerberosSession(req);
        if (alreadyMatched && !this.isForwarded(req) || !this.isProductMatch()) {
            log.debug("Already matched request, !isForwarded and !isProductMatch. Passing filter down chain");
            chain.doFilter(request, response);
            return;
        }
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        req.setAttribute(ALREADY_MATCHED_ATTR, (Object)true);
        String requestURI = req.getRequestURI();
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(req);
        if (isLoginPage && DisableTraditionalLoginServlet.isBlockTraditionalLogin(this.kerbConfManager, this.userLookupService) && !this.isForceUIForTest(req)) {
            log.debug("Including disabling-login elements in page since traditional login is disabled for {}", (Object)requestURI);
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-login");
        }
        if (this.hostApp.isRestApi(internalPath = HttpUrlUtils.getInternalPath(req)) && log.isDebugEnabled()) {
            Enumeration authorizationHeaders = req.getHeaders("Authorization");
            int i = 0;
            while (authorizationHeaders.hasMoreElements()) {
                log.debug("Authorization Headers:");
                String header = (String)authorizationHeaders.nextElement();
                String scheme = header.split(" ")[0];
                log.debug("Header Authorization " + i + ": " + scheme);
                ++i;
            }
        }
        boolean isRestApiRestrictedToApiTokens = this.kerbConfManager.isRestApiRestrictedToApiTokens();
        boolean bl = clientAllowedBasicAuth = req.getAttribute("ksso.allowed.basic.auth") != null;
        if (this.hostApp.isRestApi(internalPath) && isRestApiRestrictedToApiTokens) {
            boolean shouldBlockRequest;
            log.debug("KSSO Rest API Access. isRestApiRestrictedToApiTokens => true");
            String sanitizedInternalPath = HttpUrlUtils.sanitizeUrlForTrailingSlashes(internalPath);
            log.debug("Requested URL: " + req.getRequestURL().toString());
            List<RestrictAPIEndpoint> restrictAPIEndpoints = this.tokenEndpointService.findAllRestApiTokenEndpoints();
            List<UnblockAPIEndpoint> unblockAPIEndpoints = this.tokenEndpointService.findAllUnblockedRestApiTokenEndpoints();
            log.debug("KSSO Rest API Access. restricted API endpoints: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List<String>)io.vavr.collection.List.ofAll(restrictAPIEndpoints).map(RestrictAPIEndpoint::getCompleteUrl), KssoStringUtils.StringLiteral.COMMA_AND_SPACE) + " unblocked API endpoints: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List<String>)io.vavr.collection.List.ofAll(unblockAPIEndpoints).map(UnblockAPIEndpoint::getCompleteUrl), KssoStringUtils.StringLiteral.COMMA_AND_SPACE));
            boolean urlIsApiTokenUnblocked = false;
            String remoteIp = this.kerbConfManager.getRemoteIpAddress(req);
            for (UnblockAPIEndpoint restEndpoint : unblockAPIEndpoints) {
                if (!StringUtils.isBlank((CharSequence)restEndpoint.getClientIP()) && !StringUtils.equals((CharSequence)restEndpoint.getClientIP(), (CharSequence)remoteIp) || sanitizedInternalPath == null || !sanitizedInternalPath.startsWith(HttpUrlUtils.urlDecode(restEndpoint.getInternalPathRest()))) continue;
                urlIsApiTokenUnblocked = true;
                break;
            }
            boolean urlIsApiTokenRestricted = restrictAPIEndpoints.stream().anyMatch(endpoint -> (Boolean)Try.of((CheckedFunction0 & Serializable)() -> endpoint).mapTry(RestrictAPIEndpoint::getInternalPathRest).mapTry(HttpUrlUtils::urlDecode).mapTry(sanitizedInternalPath::startsWith).getOrElse((Object)false));
            log.debug("KSSO Rest API Access. urlIsApiTokenRestricted: " + urlIsApiTokenRestricted);
            boolean isExternalCall = !this.hostApp.isRequestFromHostApp(req) && !this.hostApp.isRestPathInternalAtlassianFunctionality(req) && !this.hostApp.isJiraCrowdRequest(req);
            log.debug("KSSO REST API Access. isExternalCall: " + isExternalCall);
            boolean requestHasApiToken = this.apiTokenService.requestHasApiToken(req);
            log.debug("KSSO REST API Access. requestHasApiToken: " + requestHasApiToken);
            boolean isRestApiCompleteLockdown = this.kerbConfManager.isRestApiCompleteLockdown();
            log.debug("KSSO REST API Access. isRestApiCompleteLockdown: " + isRestApiCompleteLockdown);
            log.debug("KSSO REST API Access. clientAllowedBasicAuth: " + clientAllowedBasicAuth);
            if (isRestApiCompleteLockdown && clientAllowedBasicAuth) {
                log.debug("KSSO REST API Access. Client allowed basic auth will be blocked because complete lockdown is selected");
            } else if (isExternalCall && clientAllowedBasicAuth) {
                log.debug("KSSO REST API Access. Client allowed basic auth will be let through REST API access");
            }
            boolean bl2 = shouldBlockRequest = urlIsApiTokenRestricted && !urlIsApiTokenUnblocked && !requestHasApiToken && (isExternalCall && !clientAllowedBasicAuth || isRestApiCompleteLockdown);
            if (shouldBlockRequest) {
                log.debug("KSSO REST API Access. Blocked requested URL: " + req.getRequestURL().toString());
                String blockedMessage = (String)Option.of((Object)(this.kerbConfManager.getLockedRestApiErrorPageMessage() + " Requested URL: " + req.getRequestURI())).getOrElse((Object)this.kerbConfManager.getDefaultLockedRestApiErrorPageMessage(req.getRequestURI()));
                res.sendError(403, blockedMessage);
                String username = (String)HttpUrlUtils.credentialsWithBasicAuthSingleHeader(req).map(usernameAndPassword -> (String)usernameAndPassword._1()).getOrElse((Object)"<unknown>");
                log.debug("KSSO REST API Access. Blocked login for username: " + username);
                this.auditLogFacade.loginFailed(username, "REST API Basic Auth", "REST API access is restricted to API Token authentication only.");
                log.debug(blockedMessage);
                return;
            }
        }
        if (this.idpConfManager.isSamlSessionActive(req)) {
            log.debug("KSSO SAML session active for user " + (String)Option.of((Object)req.getSession(false).getAttribute("ksso.saml.session.user")).map(String.class::cast).getOrElse((Object)"<unknown>"));
        }
        if (this.idpConfManager.isOidcSessionActive(req)) {
            log.debug("KSSO OpenID connect session active for user " + (String)Option.of((Object)req.getSession(false).getAttribute("ksso.oidc.session.user")).map(String.class::cast).getOrElse((Object)"<unknown>"));
        }
        if (this.idpConfManager.isAuthenticatedAnonymousBrowsingSessionActive(req)) {
            HttpSession session = req.getSession(false);
            String sessionUser = (String)Option.of((Object)session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER")).map(String.class::cast).getOrElse((Object)"<anonymous>");
            String idpId = (String)Option.of((Object)session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID")).map(String.class::cast).getOrElse((Object)"");
            IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(idpId);
            if (this.hostApp.isMainLoginPage(req)) {
                log.debug("Invalidating session of authenticated anonymous browsing session for user: {} ", (Object)sessionUser);
                session.invalidate();
            } else if (configuration.isAuthenticatedAnonymousBrowsingEnabled()) {
                log.debug("Authenticated anonymous browsing session is enabled and user: {} has an active session. Aborting login.", (Object)sessionUser);
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
        }
        if (!this.isMappedRequest(req, res)) {
            log.trace("Request for {} is not mapped", (Object)requestURI);
            chain.doFilter(request, response);
            return;
        }
        if (this.isForwarded(req)) {
            SanitizedLogStatement.of(req.getAttribute("javax.servlet.forward.request_uri")).andThenLog(sanitizedAttribute -> log.debug("Initiating SSO on forwarded request from; {} to: {}", sanitizedAttribute, (Object)req.getRequestURI()));
        }
        if (this.loginScriptCondition.shouldAddLoginScripts(req)) {
            log.debug("Adding login scripts to page");
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
        }
        if (this.loginScriptCondition.shouldAddMSTeamsScripts(req)) {
            log.debug("Adding msteams scripts to page");
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-msteams-login");
        }
        log.debug("AtlasKerberosFilter processing requestUri {}, method {}", (Object)requestURI, (Object)req.getMethod());
        if (this.hostApp.isLoggedIn(req)) {
            log.debug("isLoggedIn(req) -> doFilter");
            if (this.hostApp.shouldTryApiTokenAuthentication(req) && this.apiTokenService.requestHasApiToken(req)) {
                chain.doFilter((ServletRequest)new AuthContextPreservableHttpServletRequest(req), (ServletResponse)res);
                log.debug("Request has KSSO API token but user is logged in. Avoid attempting normal login");
                return;
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        PluginLicense pluginLicense = null;
        try {
            if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
                pluginLicense = (PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get();
            }
        }
        catch (Exception e2) {
            log.error("Exception getting Kerberos plugin configuration", (Throwable)e2);
            chain.doFilter(request, response);
            return;
        }
        if (pluginLicense == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!pluginLicense.isValid()) {
            log.info("License is not valid" + ((LicenseError)pluginLicense.getError().get()).name());
            chain.doFilter(request, response);
            return;
        }
        String usernameFromHeader = this.getUsernameFromHeader(req);
        if (usernameFromHeader != null) {
            try {
                PrincipalEntry principalEntry = this.userLookupService.resolveUser(usernameFromHeader);
                if (principalEntry.getPrincipal().isPresent()) {
                    Principal principal = principalEntry.getPrincipal().get();
                    this.hostApp.publishUserAuthenticatedEvent(principal, req, res);
                    this.authenticateWithProduct(req, res, principal);
                    this.auditLogFacade.loginSuccess(principal.getName(), "HeaderUsername");
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    return;
                }
                this.auditLogFacade.loginFailed(null, "HeaderUsername", "Could not find username " + usernameFromHeader + " in any directory. Trying other mechanisms to log in user.");
            }
            catch (Exception e3) {
                this.auditLogFacade.loginFailed(null, "HeaderUsername", "Failed looking up " + usernameFromHeader + ". Trying other mechanisms to log in user.");
            }
        }
        if (this.hostApp.shouldTryApiTokenAuthentication(req) && this.apiTokenService.requestHasApiToken(req)) {
            log.debug("Attempting to authenticate KSSO API Token");
            Validation<String, UserProfile> validation = this.apiTokenService.validateApiToken(req);
            if (validation.isValid()) {
                UserProfile userProfile = (UserProfile)validation.get();
                String username = userProfile.getUsername();
                log.debug("KSSO API Token for user " + username + " is valid. Looking up user.");
                PrincipalEntry lookupFromUserManager = this.userLookupService.resolveUser(username);
                Option principalEntry = Option.of((Object)lookupFromUserManager).peek(_principal -> log.debug("PrincipalEntry.getPrincipal is present?: " + _principal.getPrincipal().isPresent())).onEmpty(() -> log.debug("PrincipalEntry empty for username " + username));
                if (principalEntry.isDefined()) {
                    if (((PrincipalEntry)principalEntry.get()).getUserState() == PrincipalEntry.UserState.FOUND) {
                        Optional<Principal> maybePrincipal = ((PrincipalEntry)principalEntry.get()).getPrincipal();
                        if (maybePrincipal.isPresent()) {
                            Principal principal = maybePrincipal.get();
                            log.debug("Principal: " + principal.getName());
                            log.debug("Successfully logged in " + username + ". ");
                            Try<Integer> maybeFailedLoginAttempts = this.hostApp.getFailedLoginAttempts(principal);
                            this.authenticateWithProduct(req, res, principal);
                            this.auditLogFacade.loginSuccess(username, "KANTEGA SSO API TOKEN");
                            req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
                            maybeFailedLoginAttempts.peek(failedLoginAttempts -> log.debug("Persisting failed login attempts for {}: {}", (Object)UserManagerUtils.nullsafeUsernameOrAnonymous(principal), failedLoginAttempts)).flatMapTry((CheckedFunction1 & Serializable)failedLoginAttempts -> this.hostApp.setFailedLoginAttempts(principal, (int)failedLoginAttempts)).onFailure(e -> log.warn("Failed to persist login attempts during API token authentication:", e));
                            chain.doFilter((ServletRequest)new AuthContextPreservableHttpServletRequest(req), (ServletResponse)new StatusPreservableHeaderAwareResponse(res));
                            return;
                        }
                        log.debug("Principal for user " + username + " not found. Could not complete API token authentication");
                        this.auditLogFacade.loginFailed(username, "KANTEGA SSO API TOKEN", "Principal not found");
                        res.sendError(401, "User principal not found during KSSO API Token authentication.");
                        return;
                    }
                    if (((PrincipalEntry)principalEntry.get()).getUserState() == PrincipalEntry.UserState.INACTIVE) {
                        log.debug("User " + username + " inactive. Could not complete API token authentication");
                        this.auditLogFacade.loginFailed(username, "KANTEGA SSO API TOKEN", "User inactive");
                        res.sendError(401, "User inactive. Could not complete KSSO API Token authentication.");
                        return;
                    }
                    log.debug("User " + username + " not found. Could not complete API token authentication");
                    this.auditLogFacade.loginFailed(username, "KANTEGA SSO API TOKEN", "User not found");
                    res.sendError(401, "User not found during KSSO API Token authentication.");
                    return;
                }
            } else {
                if (this.apiTokenService.requestHasApiToken(req) && validation.isInvalid()) {
                    log.debug("Invalid KSSO API Token");
                    res.sendError(403, "KSSO API Token not valid.");
                    return;
                }
                log.debug("KSSO API token not recognized. Passing down filter chain");
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
        }
        if (this.hostApp.isAuthTokenRequest(req)) {
            log.debug("Not processing request because it already has auth tokens");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (this.hostApp.isLoginRequest(req)) {
            if (this.kerbConfManager.isManualLoginLogEnabled()) {
                String username = this.hostApp.getLoginRequestUsername(req);
                manualLoginLog.warn("Username/password login attempt recorded: ip: " + this.kerbConfManager.getRemoteIpAddress(req) + ", username: " + username + ", userAgent: " + req.getHeader("User-Agent"));
            }
            CookieUtil.setTraditionalLoginCookie(req, res);
            req.getSession().setAttribute("hasUsedTraditionalLogin", (Object)true);
            log.debug("isLoginRequest(req) -> doFilter");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        CookieUtil.removeCookie(req, res, "has_used_traditional_login");
        if (this.shouldDoKerberos(req, res)) {
            byte[] serverToken;
            DecodedKerberosToken decodedKerberosToken;
            String atz = req.getHeader("Authorization");
            if (atz == null || !atz.startsWith("Negotiate ")) {
                this.kerbConfManager.getStats().attempt();
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Negotiate");
                log.debug("Sending WWW-Authenticate header to IP: " + req.getRemoteAddr() + ", X-forwarded-for: " + req.getHeader("x-forwarded-for") + ", UserAgent: " + req.getHeader("User-Agent"));
                this.dispatchToLogin(req, res, chain);
                return;
            }
            SpNego spNego = new SpNego();
            try {
                decodedKerberosToken = this.kerbConfManager.decodeKerberosToken(req);
            }
            catch (Exception e4) {
                if (e4 instanceof SpNego.NtlmTokenException) {
                    this.kerbConfManager.getStats().wrongTokenNtlm();
                    log.info("Negotiate token is an NTLM token from client " + this.kerbConfManager.getRemoteIpAddress(req));
                    this.failureListener.failed(LoginAttempt.attempt("Client sent SPNego token with wrapped NTLM token.", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e4), req.getRequestURI());
                } else if (e4 instanceof SpNego.DirectNtlmTokenException) {
                    this.kerbConfManager.getStats().wrongTokenNtlm();
                    log.info("Client sent an NTLM token from client " + this.kerbConfManager.getRemoteIpAddress(req));
                    this.failureListener.failed(LoginAttempt.attempt("Client sent an NTLM token instead of Kerberos/SPNEGO", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e4), req.getRequestURI());
                } else if (e4 instanceof SpNego.NoKerberosMechException) {
                    this.kerbConfManager.getStats().wrongTokenNotKerberos();
                    log.info("Negotiate token does not have any Kerberos tokens from client " + this.kerbConfManager.getRemoteIpAddress(req));
                    this.failureListener.failed(LoginAttempt.attempt("Client sent an SPNEGO token wrapping a non-Kerberos token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e4), req.getRequestURI());
                } else {
                    this.failureListener.failed(LoginAttempt.attempt("Failed to parse the client token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(e4), req.getRequestURI());
                    this.kerbConfManager.getStats().failedDecodingToken();
                    log.error("Exception decoding SPNEGO token from client " + this.kerbConfManager.getRemoteIpAddress(req), (Throwable)e4);
                }
                res.setStatus(401);
                log.debug("shouldDoKerberos() -> dispatchToLogin");
                this.dispatchToLogin(req, res, chain);
                return;
            }
            try {
                Subject subject = this.kerbConfManager.getSubject(decodedKerberosToken);
                serverToken = spNego.negotiate(subject, req, res);
            }
            catch (Throwable e5) {
                log.error("Unexpected error negotiating SPNEGO token", e5);
                this.auditLogFacade.loginFailed(null, "Kerberos", "Unexpected error negotiating SPNEGO token.");
                chain.doFilter(request, response);
                return;
            }
            if (spNego.getResult() == SpNegoResult.AUTHORIZED) {
                PrincipalEntry principalEntry = this.userLookupService.lookupUserForKerberos(spNego.getAuthorizedPrincipal(), true);
                if (!principalEntry.getPrincipal().isPresent()) {
                    this.failureListener.failed(LoginAttempt.attempt("User account not found", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(spNego.getAuthorizedPrincipal()), req.getRequestURI());
                    this.kerbConfManager.getStats().missingUser();
                    log.debug("Kerberos ticket OK -> User account not found");
                    this.auditLogFacade.loginFailed(spNego.getAuthorizedPrincipal(), "Kerberos", "User account not found.");
                    req.setAttribute(USERNAME_ANONYMOUS_USER, (Object)spNego.getAuthorizedPrincipal());
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                Principal principal = principalEntry.getPrincipal().get();
                this.hostApp.publishUserAuthenticatedEvent(principal, req, res);
                if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                    this.failureListener.failed(LoginAttempt.attempt("User account is not active", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(principal.getName()), req.getRequestURI());
                    this.kerbConfManager.getStats().lacksPermission();
                    log.debug("Kerberos ticket OK -> User account not active");
                    this.auditLogFacade.loginFailed(principal.getName(), "Kerberos", "User account not active.");
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                if (!this.hostApp.isUserInRequiredGroups(principal.getName())) {
                    this.failureListener.failed(LoginAttempt.attempt("User account lacks required group(s) " + StringUtils.join(this.kerbConfManager.getRequiredGroups(), (String)","), this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(principal.getName()), req.getRequestURI());
                    this.kerbConfManager.getStats().lacksRequiredGroup();
                    if (!this.kerbConfManager.isUserdetailsInCommentsEnabled()) {
                        this.refreshKerberosLockout(req);
                    }
                    log.debug("Kerberos ticket OK -> User account lacks required group(s)");
                    this.auditLogFacade.loginFailed(principal.getName(), "Kerberos", "User account lacks required group(s).");
                    req.setAttribute(USERNAME_ANONYMOUS_USER, (Object)principal.getName());
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                if (this.hostApp.shouldRequireCanLogin(req) && !this.hostApp.canLogin(principal, req)) {
                    this.failureListener.failed(LoginAttempt.attempt("User account lacks login permission", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).user(principal.getName()), req.getRequestURI());
                    this.kerbConfManager.getStats().lacksPermission();
                    log.debug("Kerberos ticket OK -> User account lacks canUse/canLogin");
                    this.auditLogFacade.loginFailed(principal.getName(), "Kerberos", "User account lacks canUse/canLogin.");
                    req.setAttribute(USERNAME_ANONYMOUS_USER, (Object)principal.getName());
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                if (this.kerbConfManager.isKerberosEnabled()) {
                    if (serverToken != null && serverToken.length > 0) {
                        res.setHeader("WWW-Authenticate", String.format("Negotiate %s", Base64.getEncoder().encodeToString(serverToken)));
                    }
                    this.finishSuccessfulKerberosLogin(req, res, principal, chain);
                } else {
                    ArrayList<Directory> dirsAllowing = new ArrayList();
                    try {
                        dirsAllowing = this.userLookupService.getDirectoriesAllowingKerberosLogin();
                    }
                    catch (RuntimeException e6) {
                        log.warn("Not able to search for directories: " + e6.getMessage());
                    }
                    if (this.userLookupService.isUserInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, this.kerbConfManager.getAllowKerberosLoginGroups(), this.kerbConfManager.getDisallowKerberosLoginGroups(), principal.getName(), AuthMethod.KERBEROS)) {
                        this.finishSuccessfulKerberosLogin(req, res, principal, chain);
                    } else {
                        this.dispatchToLogin(req, res, chain);
                    }
                }
            } else {
                if (spNego.getResult() == SpNegoResult.AUTHORIZATION_FAILED) {
                    this.failureListener.failed(LoginAttempt.attempt("Failed to validate client token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz).exception(spNego.getException()), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Failed to validate client token.");
                    this.kerbConfManager.getStats().authFailed();
                } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_BASIC) {
                    this.failureListener.failed(LoginAttempt.attempt("Client sent a Basic token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent a Basic token.");
                    this.kerbConfManager.getStats().wrongTokenBasic();
                } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NTLM) {
                    this.failureListener.failed(LoginAttempt.attempt("Client sent an NTLM token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent an NTLM token.");
                    this.kerbConfManager.getStats().wrongTokenNtlm();
                } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NOT_NEGOTIATE) {
                    this.failureListener.failed(LoginAttempt.attempt("Client sent a non-Negotiate token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent a non-Negotiate token.");
                    this.kerbConfManager.getStats().wrongTokenNotNegotiate();
                } else if (spNego.getResult() == SpNegoResult.FAILED_PARSING_TOKEN) {
                    this.failureListener.failed(LoginAttempt.attempt("Failed parsing token", this.kerbConfManager.getRemoteIpAddress(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Failed parsing token.");
                    this.kerbConfManager.getStats().failedParsingToken();
                }
                res.setStatus(401);
                log.debug("Kerberos ticket INVALID -> dispatchToLogin fallback");
                this.dispatchToLogin(req, res, chain);
            }
        } else if (this.loginScriptCondition.shouldDoFederatedSSO(req)) {
            log.debug("shouldAddLoginScript() -> dispatchToLogin");
            this.dispatchToLogin(req, res, chain);
        } else {
            log.debug("Should not do Kerberos or SAML doFilter");
            chain.doFilter(request, response);
        }
    }

    private void finishSuccessfulKerberosLogin(HttpServletRequest req, HttpServletResponse res, Principal principal, FilterChain chain) throws ServletException, IOException {
        this.authenticateWithProduct(req, res, principal);
        this.kerbConfManager.getStats().success();
        res.setHeader("Persistent-Auth", "false");
        log.debug("Kerberos ticket OK -> login success");
        this.auditLogFacade.loginSuccess(principal.getName(), "Kerberos");
        this.hostApp.postSuccessfulLoginWithKerberosAction(principal, req, res, chain);
    }

    private boolean isForceUIForTest(HttpServletRequest req) {
        String qry = req.getQueryString();
        return qry != null && qry.contains("forceUIForTest");
    }

    private void refreshKerberosLockout(HttpServletRequest req) {
        req.getSession(true).setAttribute(LOCKOUT_TIMESTAMP, (Object)System.nanoTime());
    }

    private boolean querystringHas(String queryStringPart, HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)queryStringPart);
    }

    private void setNokerberosSession(HttpServletRequest req) {
        if (this.querystringHas("nokerberosSession", req)) {
            req.getSession().setAttribute("nokerberosSession", (Object)true);
        } else if (this.querystringHas("kerberosSession", req)) {
            req.getSession().removeAttribute("nokerberosSession");
        }
    }

    private boolean shouldDoKerberos(HttpServletRequest req, HttpServletResponse res) {
        if (req.getSession().getAttribute("nokerberosSession") != null || this.querystringHas("nokerberos", req)) {
            return false;
        }
        if (!this.kerbConfManager.isKerberosEnabled() && this.userLookupService.getDirectoriesAllowingKerberosLogin().size() == 0 && this.kerbConfManager.getAllowKerberosLoginGroups().size() == 0 && this.kerbConfManager.getDisallowKerberosLoginGroups().size() == 0) {
            return false;
        }
        if (!this.kerbConfManager.isKeytabConfigured()) {
            return false;
        }
        if (!this.kerbConfManager.isUserAgentEnabled(req.getHeader("User-agent"))) {
            return false;
        }
        String internalPathOfReq = HttpUrlUtils.getInternalPath(req);
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        boolean isRestApi = this.hostApp.isRestApi(internalPathOfReq);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        if (!isRestApi && !ipRestrictionConfig.getGlobalIpFilter().isRemoteAddressEnabled(remoteIpAddress)) {
            return false;
        }
        if (isRestApi && !ipRestrictionConfig.getRestIpFilter().isRemoteAddressEnabled(remoteIpAddress)) {
            return false;
        }
        if (this.hostApp.shouldLoginManually(req, res) && !this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            return false;
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            long secondsSinceLockout;
            Long lockoutTime = (Long)session.getAttribute(LOCKOUT_TIMESTAMP);
            long l = secondsSinceLockout = lockoutTime == null ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - lockoutTime);
            if (secondsSinceLockout < 1800L) {
                if (log.isDebugEnabled()) {
                    log.debug("Not initiating SPNEGO/WWW-Authenticate for request to '{}': Previous lockout {} seconds ago.", (Object)req.getRequestURI(), (Object)secondsSinceLockout);
                }
                this.failureListener.failed(LoginAttempt.attempt("Client session in temporary Kerberos lockout (user missing required group(s))", this.kerbConfManager.getRemoteIpAddress(req)), req.getRequestURI());
                this.kerbConfManager.getStats().kerberosLockout();
                return false;
            }
        }
        return true;
    }

    private boolean isMappedRequest(HttpServletRequest req, HttpServletResponse resp) {
        String r = HttpUrlUtils.getInternalPath(req);
        if (this.hostApp.isRequestMapped(req, r)) {
            log.debug("hostApp.isRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isRESTRequestMapped(req, r)) {
            log.debug("hostApp.isRestRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isForceLoginRequestMapped(req) && this.kerbConfManager.isRequireLogin() && !this.isPreemptivePathExcluded(req)) {
            log.debug("hostApp.isRequireLogin({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLoginRequest(req)) {
            log.debug("hostApp.isLoginRequest({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.shouldLoginManually(req, resp) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            log.debug("hostApp.shouldLoginManually && idpConfManager.isAnyProviderForcingReLoginAfterLogout() ({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLogoutPage(req) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogout()) {
            log.debug("hostApp.isLogoutPage && idpConfManager.isAnyProviderForcingReLoginAfterLogout() ({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isServiceDeskLogout(req) && this.idpConfManager.isAnyProviderForcingReLoginAfterLogoutForJsm()) {
            return true;
        }
        if (this.hostApp.shouldTryApiTokenAuthentication(req)) {
            log.debug("AtlasKerberosFilter.shouldTryApiAuthentication({}) => true", (Object)r);
            return true;
        }
        if (this.getUsernameFromHeader(req) != null) {
            log.debug("AtlasKerberosFilter.getUsernameFromHeader({}) => true", (Object)r);
            return true;
        }
        log.debug("AtlasKerberosFilter.isMappedRequest({}) => FALSE", (Object)r);
        return false;
    }

    private String getUsernameFromHeader(HttpServletRequest req) {
        String remoteAddr = req.getRemoteAddr();
        if (this.kerbConfManager.isHeaderauthUseXForwardedFor()) {
            remoteAddr = AtlasKerberosFilter.getRemoteIpHeaderAuth(req);
        }
        String headerAttribute = this.kerbConfManager.getHeaderUsernameAttribute();
        String qs = req.getQueryString();
        boolean skipHeaderAuth = StringUtils.contains((CharSequence)qs, (CharSequence)"noheadersso") || StringUtils.contains((CharSequence)qs, (CharSequence)"noautosso") || StringUtils.contains((CharSequence)qs, (CharSequence)"noredirect");
        boolean headerUsernameIpUnblocked = InternetAddressUtils.isAddressPermissionMatch(remoteAddr, this.kerbConfManager.getHeaderUsernameIpUnblockedList());
        if (headerUsernameIpUnblocked && headerAttribute != null && !skipHeaderAuth) {
            return req.getHeader(headerAttribute);
        }
        return null;
    }

    private boolean isPreemptivePathExcluded(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length()).toLowerCase();
        if (req.getQueryString() != null) {
            r = r + "?" + req.getQueryString();
        }
        for (String excludedPath : this.kerbConfManager.getRequireLoginExcludedPaths()) {
            if (excludedPath != null && excludedPath.endsWith("*")) {
                excludedPath = excludedPath.substring(0, excludedPath.length() - 1);
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)r, (CharSequence)excludedPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isForwarded(HttpServletRequest req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    protected static String getRemoteIpHeaderAuth(HttpServletRequest req) {
        String forwardedFor = req.getHeader("[IP::client_addr]");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        return req.getRemoteAddr();
    }

    private void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws ServletException, IOException {
        log.debug("is response committed {}", (Object)resp.isCommitted());
        IdpConfiguration autoRedirect = this.hostApp.getInstantRedirectProvider(req, resp, this.loginScriptCondition);
        boolean hasCookie = false;
        if (this.kerbConfManager.isRemembermeCookieEnabled() && req.getCookies() != null) {
            for (Cookie cookie : req.getCookies()) {
                if (!"seraph.rememberme.cookie".equals(cookie.getName()) && !"seraph.confluence".equals(cookie.getName())) continue;
                hasCookie = true;
                break;
            }
        }
        if (autoRedirect != null && !hasCookie && (this.hostApp.isForceLoginRequestMapped(req) && this.kerbConfManager.isRequireLogin() && this.kerbConfManager.isForceLogin() || this.hostApp.isMainLoginPage(req))) {
            this.performInstantRedirect(req, resp, autoRedirect);
        } else {
            this.hostApp.dispatchToLogin(req, resp, chain);
        }
    }

    protected final void performInstantRedirect(HttpServletRequest req, HttpServletResponse resp, IdpConfiguration idpConfiguration) throws IOException {
        String url;
        String target = this.hostApp.getRedirectTarget(req);
        ContextAware pathHelper = ContextAware.of(req);
        resp.setContentType("text/html");
        if (target != null) {
            url = target;
        } else {
            String qs;
            String string = qs = req.getQueryString() != null ? "?" + req.getQueryString() : "";
            if (this.hostApp.isMainLoginPage(req)) {
                if (StringUtils.isNotBlank((CharSequence)qs) && !StringUtils.contains((CharSequence)qs, (CharSequence)this.hostApp.getTargetParameterName())) {
                    qs = qs + "&" + this.hostApp.getTargetParameterName() + "=/";
                } else if (StringUtils.isBlank((CharSequence)qs)) {
                    qs = "?" + this.hostApp.getTargetParameterName() + "=/";
                }
            }
            url = req.getRequestURI() + qs;
            log.debug("Instant redirect: Target value built from query string: " + url);
        }
        if (!StringUtils.contains((CharSequence)url, (CharSequence)pathHelper.path("/rest/"))) {
            req.getSession().setAttribute("samlInstantLoginUrl", (Object)url);
        }
        url = this.idpConfManager.getServiceProviderLoginUrl(req, idpConfiguration.getId()) + "?target=" + HttpUrlUtils.urlEncode(url);
        log.debug("Instant redirect: Return value sent to IdP: " + url);
        if (idpConfiguration.isHostedDomain() && idpConfiguration.getKnownDomains().iterator().hasNext()) {
            url = url + "&hd=" + (String)idpConfiguration.getKnownDomains().iterator().next();
        }
        resp.getWriter().print("<html><head><meta http-equiv=\"refresh\" content=\"1;URL='" + StringEscapeUtils.escapeHtml((String)url) + "'\" /></head><p>Redirecting to sign-on..</p></html>");
    }

    public void destroy() {
    }

    private Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        return AtlasKerberosFilter.authenticateWithProduct(req, res, user, this.kerbConfManager, this.hostApp);
    }

    public static Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user, KerbConfManager kerbConfManager, HostApp hostApp) {
        if (kerbConfManager.isRemembermeCookieEnabled()) {
            hostApp.setRememberMeCookie(req, res, user.getName());
        }
        return hostApp.authenticateWithProduct(req, res, user);
    }
}

