/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DateTimeUtil {
    public static Option<String> longToIsoTimestamp(long millis) {
        return Try.of((CheckedFunction0 & Serializable)() -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault())).mapTry((CheckedFunction1 & Serializable)dateTime -> dateTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME)).toOption();
    }

    public static String isoTimestamp() {
        return OffsetDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static long convertDaysToMillis(long days) {
        return TimeUnit.DAYS.toMillis(days);
    }

    public static Try<Long> convertDaysToMillis(String days) {
        return Try.of((CheckedFunction0 & Serializable)() -> Long.parseLong(days)).mapTry(TimeUnit.DAYS::toMillis);
    }

    public static Try<String> convertMillisToDays(long millis) {
        return Try.of((CheckedFunction0 & Serializable)() -> String.valueOf(TimeUnit.MILLISECONDS.toDays(millis)));
    }

    public static DateTimeFormatter dateTimeFormatter(FormatStyle formatStyle) {
        return DateTimeFormatter.ofLocalizedDateTime(formatStyle).withLocale(Locale.getDefault()).withChronology(Chronology.ofLocale(Locale.getDefault()));
    }

    public static Option<String> millisToDateTimeString(long millis) {
        return DateTimeUtil.longToIsoTimestamp(millis).flatMap(DateTimeUtil::getDateTimeString);
    }

    public static Option<ZonedDateTime> parseISOString(String isoString) {
        return Try.of((CheckedFunction0 & Serializable)() -> ZonedDateTime.parse(isoString)).orElse(Try.of((CheckedFunction0 & Serializable)() -> OffsetDateTime.parse(isoString).toZonedDateTime())).orElse(Try.of((CheckedFunction0 & Serializable)() -> LocalDateTime.parse(isoString).atOffset(ZoneOffset.UTC).toZonedDateTime())).toOption();
    }

    private static Option<String> formatString(String isoString, DateTimeFormatter dateTimeFormatter) {
        return DateTimeUtil.parseISOString(isoString).map(localDate -> localDate.format(dateTimeFormatter));
    }

    public static Option<String> getDateTimeString(String isoString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm");
        return DateTimeUtil.formatString(isoString, formatter);
    }

    public static Option<String> getDateString(String isoString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd, yyyy");
        return DateTimeUtil.formatString(isoString, formatter);
    }

    public static Option<String> getDetailedDateTimeString(String isoString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, MMM dd, yyyy HH:mm:ss z");
        return DateTimeUtil.formatString(isoString, formatter);
    }

    public static Option<String> getISODateString(String isoString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return DateTimeUtil.formatString(isoString, formatter);
    }
}

