/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.atlassian.auth.BearerTokenCredentials;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import io.vavr.API;
import io.vavr.Function4;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;

public class SetupScimAction
extends RequireAdminServlet {
    private static final List<String> steps = API.List((Object[])new String[]{"network", "tenant", "idp"});
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final ScimConfManager scimConfManager;

    public SetupScimAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.scimConfManager = bucket.getScimConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tenantId = (String)Option.of((Object)req.getParameter("tenantId")).getOrElse(() -> this.scimConfManager.nextId());
        SetupScimWizardState scimWizardState = (SetupScimWizardState)SetupScimWizardState.loadFromSession(req.getSession(), tenantId).getOrElse(() -> SetupScimWizardState.newWizardState(tenantId, this.scimConfManager.nextPassword(), ScimProviderKind.valueOf((String)req.getParameter("kind"))));
        SetupScimWizardState.storeInSession(req.getSession(), scimWizardState);
        Map<String, Object> model = this.newModel(req, scimWizardState);
        this.renderPage(req, resp, model);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        String tenantId = req.getParameter("tenantId");
        SetupScimWizardState wizardState = (SetupScimWizardState)SetupScimWizardState.loadFromSession(req.getSession(), tenantId).getOrElseThrow(() -> new IllegalStateException("No wizard state is stored in session"));
        String currentStep = wizardState.step;
        Map<String, Object> model = this.newModel(req, wizardState);
        if (currentStep.equals("network")) {
            if (this.hasParameter(req, "cancel")) {
                SetupScimWizardState.removeFromSession(req.getSession(), wizardState.tenantId);
                try {
                    this.scimConfManager.deleteScimDirectoryAndTenantConfig(tenantId);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                resp.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin/dashboard");
            } else if (this.hasParameter(req, "next")) {
                boolean scimBaseUrlEndpointEnabled = "on".equals(req.getParameter("scimBaseUrlEndpointEnabled"));
                this.scimConfManager.setscimBaseUrlEndpointEnabled(scimBaseUrlEndpointEnabled);
                SetupScimWizardState next = wizardState.nextStep();
                SetupScimWizardState.storeInSession(req.getSession(), next);
                this.reload(resp, tenantId);
            }
        } else if (currentStep.equals("tenant")) {
            SetupScimWizardState updatedState = wizardState.withName(StringUtils.trim((String)req.getParameter("directoryName"))).withSecret(req.getParameter("applicationSecret"));
            this.updateModel(model, updatedState);
            if (updatedState.validate().size() > 0) {
                this.addValidation(model, updatedState);
                this.renderPage(req, resp, model);
            } else if (this.hasParameter(req, "cancel")) {
                SetupScimWizardState.removeFromSession(req.getSession(), updatedState.tenantId);
                resp.sendRedirect(this.scimConfManager.getSCIMConfigUrl(req));
            } else if (this.hasParameter(req, "back")) {
                SetupScimWizardState next = updatedState.prevStep();
                SetupScimWizardState.storeInSession(req.getSession(), next);
                this.reload(resp, tenantId);
            } else {
                SetupScimWizardState next = updatedState.nextStep();
                SetupScimWizardState.storeInSession(req.getSession(), next);
                String salt = this.scimConfManager.nextId();
                BearerTokenCredentials saltedSecret = BearerTokenCredentials.createHash((String)salt, (String)updatedState.secret);
                ScimTenantConfig cfg = new ScimTenantConfig(tenantId, updatedState.directoryName, (Credentials)saltedSecret, ScimAuthMethod.BEARER, updatedState.kind, false);
                ScimDirectory existsAlready = (ScimDirectory)this.scimConfManager.getScimDirectories().filter(d -> updatedState.directoryName.equalsIgnoreCase(d.getTenantName())).getOrNull();
                if (existsAlready != null) {
                    model.put("nameExistsAlready", true);
                    model.put("step", currentStep);
                    SetupScimWizardState.storeInSession(req.getSession(), updatedState);
                    this.renderPage(req, resp, model);
                    return;
                }
                this.scimConfManager.saveOrUpdate(cfg);
                this.reload(resp, tenantId);
            }
        } else if (this.hasParameter(req, "back")) {
            this.scimConfManager.deleteScimDirectoryAndTenantConfig(wizardState.tenantId);
            SetupScimWizardState next = wizardState.prevStep();
            SetupScimWizardState.storeInSession(req.getSession(), next);
            this.reload(resp, tenantId);
        } else {
            SetupScimWizardState.removeFromSession(req.getSession(), wizardState.tenantId);
            resp.sendRedirect("directory/" + tenantId);
        }
    }

    private Map<String, Object> newModel(HttpServletRequest req, SetupScimWizardState state) {
        Map<String, Object> model = this.newModel(req);
        model.remove("topMenu");
        return this.updateModel(model, state);
    }

    private Map<String, Object> updateModel(Map<String, Object> model, SetupScimWizardState state) {
        ScimVersion version = this.getScimVersion(state.kind);
        model.put("tenantId", state.tenantId);
        model.put("kind", state.kind);
        model.put("directoryName", state.directoryName);
        model.put("applicationSecret", state.secret);
        model.put("step", state.step);
        model.put("scimApiServerEndpoint", this.scimConfManager.getApiServerEndpoint(state.tenantId, version));
        model.put("scimBaseUrlEndpoint", this.scimConfManager.getBaseUrlEndpoint(state.tenantId, version));
        model.put("scimBaseUrlEndpointEnabled", this.scimConfManager.isScimBaseUrlEndpointEnabled());
        return model;
    }

    private ScimVersion getScimVersion(ScimProviderKind kind) {
        if (kind == ScimProviderKind.OKTA_V1) {
            return ScimVersion.V1_1;
        }
        return ScimVersion.V2_0;
    }

    private Map<String, Object> addValidation(Map<String, Object> model, SetupScimWizardState state) {
        model.put("missingFields", state.validate());
        return model;
    }

    private boolean hasParameter(HttpServletRequest req, String param) {
        return req.getParameter(param) != null;
    }

    private void reload(HttpServletResponse resp, String tenantId) throws IOException {
        resp.sendRedirect("setup-scim?tenantId=" + tenantId);
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.templateRenderer.render("templates/atlaskerb/scim/setup-scim.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return false;
    }

    static class SetupScimWizardState {
        public final String tenantId;
        public final String directoryName;
        public final String secret;
        public final ScimProviderKind kind;
        public final String step;

        SetupScimWizardState(String tenantId, String directoryName, String secret, ScimProviderKind kind, String step) {
            this.tenantId = tenantId;
            this.directoryName = directoryName;
            this.secret = secret;
            this.kind = kind;
            this.step = step;
        }

        public static void storeInSession(HttpSession session, SetupScimWizardState state) {
            session.setAttribute(state.tenantId + ".name", (Object)state.directoryName);
            session.setAttribute(state.tenantId + ".secret", (Object)state.secret);
            session.setAttribute(state.tenantId + ".step", (Object)state.step);
            session.setAttribute(state.tenantId + ".kind", (Object)state.kind.name());
        }

        public static Option<SetupScimWizardState> loadFromSession(HttpSession session, String tenantId) {
            Option maybeName = Option.of((Object)((String)session.getAttribute(tenantId + ".name")));
            Option maybeSecret = Option.of((Object)((String)session.getAttribute(tenantId + ".secret")));
            Option maybeKind = Option.of((Object)((String)session.getAttribute(tenantId + ".kind"))).map(s -> ScimProviderKind.valueOf((String)s));
            Option maybeStep = Option.of((Object)((String)session.getAttribute(tenantId + ".step")));
            return API.For((Option)maybeName, (Option)maybeSecret, (Option)maybeKind, (Option)maybeStep).yield((Function4 & Serializable)(name, secret, kind, step) -> new SetupScimWizardState(tenantId, (String)name, (String)secret, (ScimProviderKind)kind, (String)step));
        }

        public static void removeFromSession(HttpSession session, String tenantId) {
            session.removeAttribute(tenantId + ".name");
            session.removeAttribute(tenantId + ".secret");
            session.removeAttribute(tenantId + ".kind");
            session.removeAttribute(tenantId + ".step");
        }

        public static SetupScimWizardState newWizardState(String tenantId, String applicationSecret, ScimProviderKind kind) {
            return new SetupScimWizardState(tenantId, kind.getName(), applicationSecret, kind, (String)steps.head());
        }

        public SetupScimWizardState withName(String name) {
            return new SetupScimWizardState(this.tenantId, (String)Option.of((Object)name).getOrElse((Object)""), this.secret, this.kind, this.step);
        }

        public SetupScimWizardState withSecret(String secret) {
            return new SetupScimWizardState(this.tenantId, this.directoryName, (String)Option.of((Object)secret).getOrElse((Object)""), this.kind, this.step);
        }

        public SetupScimWizardState nextStep() {
            return new SetupScimWizardState(this.tenantId, this.directoryName, this.secret, this.kind, this.getNextStep(this.step));
        }

        public SetupScimWizardState prevStep() {
            return new SetupScimWizardState(this.tenantId, this.directoryName, this.secret, this.kind, this.getPreviousStep(this.step));
        }

        public Map<String, String> validate() {
            TreeMap<String, String> validationInfo = new TreeMap<String, String>();
            if (StringUtils.isBlank((CharSequence)this.directoryName)) {
                validationInfo.put("directoryName", "missing");
            }
            if (StringUtils.isBlank((CharSequence)this.secret)) {
                validationInfo.put("applicationSecret", "missing");
            }
            if (StringUtils.length((CharSequence)this.secret) < 6) {
                validationInfo.put("applicationSecret", "tooshort");
            }
            return validationInfo;
        }

        private String getPreviousStep(String step) {
            return ((String)steps.head()).equals(step) ? (String)steps.head() : (String)steps.get(steps.indexOf((Object)step) - 1);
        }

        private String getNextStep(String step) {
            return ((String)steps.last()).equals(step) ? (String)steps.last() : (String)steps.get(steps.indexOf((Object)step) + 1);
        }
    }
}

