/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.springframework.stereotype.Component;

@Component
public class ErrorPageRenderer {
    ApplicationProperties applicationProperties;
    TemplateRenderer renderer;
    KerbConfManager kerbConfManager;

    @Inject
    public ErrorPageRenderer(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport TemplateRenderer renderer, KerbConfManager kerbConfManager) {
        this.applicationProperties = applicationProperties;
        this.renderer = renderer;
        this.kerbConfManager = kerbConfManager;
    }

    public void renderError(Response.Status statusCode, String message, String requestedUrl, HttpServletResponse resp) throws IOException {
        this.renderErrors(statusCode, Collections.singletonList(message), requestedUrl, resp);
    }

    public void renderErrors(Response.Status status, List<String> errors, SamlResponseValidationResult result) throws IOException {
        HttpServletResponse resp = result.getResponse();
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        resp.setStatus(status.getStatusCode());
        Map<String, Object> model = this.newModel();
        model.put("errors", errors);
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("requestURI", HttpUrlUtils.getTargetLinkUrl(result.getRelayState(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)));
        model.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.renderer.render("templates/saml/login-error.vm", model, (Writer)resp.getWriter());
    }

    public void renderErrors(Response.Status statusCode, List<String> messages, String requestedUrl, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        resp.setStatus(statusCode.getStatusCode());
        Map<String, Object> model = this.newModel();
        model.put("errors", messages);
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        if (requestedUrl != null) {
            model.put("requestURI", HttpUrlUtils.getTargetLinkUrl(requestedUrl, this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)));
        }
        model.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.renderer.render("templates/saml/login-error.vm", model, (Writer)resp.getWriter());
    }

    protected Map<String, Object> newModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        return model;
    }
}

