/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.crowd.embedded.api.Directory;
import io.vavr.collection.LinkedHashSet;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public abstract class IdpConfigurationBuilder<V, T extends IdpConfiguration> {
    private final String id;
    private final IdpConfiguration.Kind kind;
    boolean createAllIncomingGroups = false;
    boolean removeNonIdpGroupsFromUser = false;
    private String customEmailAttribute;
    private String customNameAttribute;
    private String customGivenNameAttribute;
    private String customSurnameAttribute;
    private IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping;
    private String customUsernameAttributeName;
    private Long jitDirectory;
    private boolean knownAutoRedirect;
    private boolean managedGroupsRequiredForJITCreation;
    private String name;
    private String notificationEmails;
    private boolean singleLogoutEnabled;
    private String singleLogoutReturnURL;
    private String mfaAttribute;
    private boolean mfaRequired;
    private Set<String> defaultGroups = Collections.emptySet();
    private Map<String, String> defaultGroupsRules = Collections.emptyMap();
    private Map<String, String> userProfileKeyMapping = Collections.emptyMap();
    private Set<String> idpGroupsAttributes = Collections.emptySet();
    private java.util.LinkedHashSet<String> knownDomains = new java.util.LinkedHashSet();
    private List<ManagedGroup> managedGroups = Collections.emptyList();
    private List<ManagedGroup> autoGroups = Collections.emptyList();
    private List<Pair<String, String>> userTransformationRegexes = Collections.emptyList();
    private List<Pair<UsernameAttribute, String>> usernameAttributePriority = new ArrayList<Pair<UsernameAttribute, String>>();
    private UsernameAttribute usernameAttribute;
    private boolean autoUpdateKnownDomains = false;
    private boolean enabled = true;
    private boolean hostedDomain = true;
    private IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.NONE;
    private IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
    private IdpConfiguration.UserActivatePolicy userActivatePolicy = IdpConfiguration.UserActivatePolicy.NONE;
    private IdpConfiguration.UsernamePolicy usernamePolicy = IdpConfiguration.UsernamePolicy.ANY;
    private IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.REJECT;
    private IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy = IdpConfiguration.UserUpdateNamePolicy.NONE;
    private IdpConfiguration.UserUpdateEmailPolicy userUpdateEmailPolicy = IdpConfiguration.UserUpdateEmailPolicy.NONE;
    private IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy = IdpConfiguration.AutoCreateUserPolicy.ALWAYS;
    private String serverName;
    private boolean authenticatedAnonymousBrowsingEnabled = false;
    private RedirectProperties redirectProperties = new RedirectProperties(IdpConfiguration.RedirectPolicy.ALL, Collections.emptySet(), true, false, true, false, Collections.emptySet(), false);
    private RedirectProperties jsmRedirectProperties = new RedirectProperties(this.redirectProperties);
    private String tlsFingerprint;

    protected IdpConfigurationBuilder(String id, IdpConfiguration.Kind kind) {
        this.id = (String)Option.of((Object)id).filter(IdpConfManager::isValidIdpId).getOrElseThrow(IllegalArgumentException::new);
        this.kind = kind;
    }

    protected IdpConfigurationBuilder(IdpConfiguration source) {
        this(source.getId(), source.getKind());
        this.mfaAttribute = source.getMfaAttribute();
        this.mfaRequired = source.mfaRequired();
        this.defaultGroups = source.getDefaultGroups();
        this.defaultGroupsRules = source.getDefaultGroupsRules();
        this.autoUpdateKnownDomains = source.isAutoUpdateKnownDomains();
        this.customEmailAttribute = source.getCustomEmailAttribute();
        this.customNameAttribute = source.getCustomNameAttribute();
        this.customGivenNameAttribute = source.getCustomGivenNameAttribute();
        this.customSurnameAttribute = source.getCustomSurnameAttribute();
        this.nameAttributeMapping = source.getNameAttributeMapping();
        this.enabled = source.isEnabled();
        this.jitDirectory = source.getJitDirectory().orElse(null);
        this.knownDomains = source.getKnownDomains();
        this.managedGroups = source.getManagedGroups();
        this.autoGroups = source.getAutoGroups();
        this.createAllIncomingGroups = source.isCreateAllIncomingGroups();
        this.removeNonIdpGroupsFromUser = source.isRemoveNonIdpGroupsFromUser();
        this.managedGroupsRequiredForJITCreation = source.isManagedGroupsRequiredForJITCreation();
        this.name = source.getName();
        this.notificationEmails = source.getNotificationEmails();
        this.userTransformationRegexes = source.getUserTransformationRegexes();
        this.usernameAttributePriority = source.getUsernameAttributePriority();
        this.singleLogoutEnabled = source.isSingleLogoutEnabled();
        this.singleLogoutReturnURL = source.getSingleLogoutReturnURL();
        this.userActivatePolicy = source.getUserActivatePolicy();
        this.userLookupAttribute = source.getUserLookupAttribute();
        this.userLookupTransform = source.getUserLookupTransform();
        this.usernamePolicy = source.getUsernamePolicy();
        this.userNotFoundPolicy = source.getUserNotFoundPolicy();
        this.userUpdateNamePolicy = source.getUserUpdateNamePolicy();
        this.userUpdateEmailPolicy = source.getUserUpdateEmailPolicy();
        this.autoCreateUserPolicy = source.getAutoCreateUserPolicy();
        this.hostedDomain = source.isHostedDomain();
        this.idpGroupsAttributes = source.getIdpGroupsAttributes();
        this.authenticatedAnonymousBrowsingEnabled = source.isAuthenticatedAnonymousBrowsingEnabled();
        this.redirectProperties = source.getRedirectProperties();
        this.jsmRedirectProperties = source.getJsmRedirectProperties();
        this.tlsFingerprint = source.getTlsFingerprint();
    }

    public static Saml saml(String id, IdpConfiguration.Kind kind) {
        return new Saml(id, kind);
    }

    public static Oidc oidc(String id, IdpConfiguration.Kind kind) {
        return new Oidc(id, kind);
    }

    public static Oidc of(OidcIdpConfiguration source) {
        return new Oidc(source);
    }

    public static Saml of(SamlIdpConfiguration source) {
        return new Saml(source);
    }

    public static IdpConfigurationBuilder<?, ?> ofGeneric(IdpConfiguration config) {
        return config.fold(IdpConfigurationBuilder::of, IdpConfigurationBuilder::of);
    }

    public T build() {
        return this.buildInternal();
    }

    abstract T buildInternal();

    abstract V getThis();

    public Optional<Long> getJitDirectory() {
        return Optional.ofNullable(this.jitDirectory);
    }

    public String getId() {
        return this.id;
    }

    public IdpConfiguration.Kind getKind() {
        return this.kind;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public V setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this.getThis();
    }

    public boolean isMfaRequired() {
        return this.mfaRequired;
    }

    public V setMfaRequired(boolean mfaRequired) {
        this.mfaRequired = mfaRequired;
        return this.getThis();
    }

    public String getMfaAttribute() {
        return this.mfaAttribute;
    }

    public V setMfaAttribute(String mfaAttribute) {
        this.mfaAttribute = mfaAttribute;
        return this.getThis();
    }

    public Set<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public V setDefaultGroups(Set<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
        return this.getThis();
    }

    public Map<String, String> getDefaultGroupsRules() {
        return this.defaultGroupsRules;
    }

    public V setDefaultGroupsRules(Map<String, String> defaultGroupsRules) {
        this.defaultGroupsRules = defaultGroupsRules;
        return this.getThis();
    }

    public Map<String, String> getUserProfileKeyMapping() {
        return this.userProfileKeyMapping;
    }

    public V setUserProfileKeyMapping(Map<String, String> userProfileKeyMapping) {
        this.userProfileKeyMapping = userProfileKeyMapping;
        return this.getThis();
    }

    public boolean isAutoUpdateKnownDomains() {
        return this.autoUpdateKnownDomains;
    }

    public V setAutoUpdateKnownDomains(boolean autoUpdateKnownDomains) {
        this.autoUpdateKnownDomains = autoUpdateKnownDomains;
        return this.getThis();
    }

    public boolean isCreateAllIncomingGroups() {
        return this.createAllIncomingGroups;
    }

    public V setCreateAllIncomingGroups(boolean createAllIncomingGroups) {
        this.createAllIncomingGroups = createAllIncomingGroups;
        return this.getThis();
    }

    public boolean isRemoveNonIdpGroupsFromUser() {
        return this.removeNonIdpGroupsFromUser;
    }

    public V setremoveNonIdpGroupsFromUser(boolean removeNonIdpGroupsFromUser) {
        this.removeNonIdpGroupsFromUser = removeNonIdpGroupsFromUser;
        return this.getThis();
    }

    public String getCustomEmailAttribute() {
        return this.customEmailAttribute;
    }

    public V setCustomEmailAttribute(String customEmailAttribute) {
        this.customEmailAttribute = customEmailAttribute;
        return this.getThis();
    }

    public String getCustomNameAttribute() {
        return this.customNameAttribute;
    }

    public V setCustomNameAttribute(String customNameAttribute) {
        this.customNameAttribute = customNameAttribute;
        return this.getThis();
    }

    public V setCustomGivenNameAttribute(String customGivenNameAttribute) {
        this.customGivenNameAttribute = customGivenNameAttribute;
        return this.getThis();
    }

    public String getCustomGivenNameAttribute() {
        return this.customGivenNameAttribute;
    }

    public V setCustomSurnameAttribute(String customSurnameAttribute) {
        this.customSurnameAttribute = customSurnameAttribute;
        return this.getThis();
    }

    public String getCustomSurnameAttribute() {
        return this.customSurnameAttribute;
    }

    public V setNameAttributeMapping(IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping) {
        this.nameAttributeMapping = nameAttributeMapping;
        return this.getThis();
    }

    public IdpConfManager.NAME_ATTRIBUTE_MAPPING getNameAttributeMapping() {
        return this.nameAttributeMapping;
    }

    public String getCustomUsernameAttributeName() {
        return this.customUsernameAttributeName;
    }

    public V setCustomUsernameAttributeName(String customUsernameAttributeName) {
        this.customUsernameAttributeName = customUsernameAttributeName;
        return this.getThis();
    }

    public Set<String> getIdpGroupsAttributes() {
        return this.idpGroupsAttributes;
    }

    public V setIdpGroupsAttributes(Set<String> idpGroupsAttributes) {
        this.idpGroupsAttributes = idpGroupsAttributes;
        return this.getThis();
    }

    public V setJitDirectory(Long jitDirectory) {
        this.jitDirectory = jitDirectory;
        return this.getThis();
    }

    public V setJitDirectoryIfPresent(Optional<Directory> maybeJitDirectory) {
        return (V)maybeJitDirectory.map(directory -> this.setJitDirectory(directory.getId())).orElseGet(this::getThis);
    }

    public java.util.LinkedHashSet<String> getKnownDomains() {
        return this.knownDomains;
    }

    public V setKnownDomains(java.util.LinkedHashSet<String> knownDomains) {
        this.knownDomains = knownDomains;
        return this.getThis();
    }

    public boolean isKnownAutoRedirect() {
        return this.knownAutoRedirect;
    }

    public V setKnownAutoRedirect(boolean knownAutoRedirect) {
        this.knownAutoRedirect = knownAutoRedirect;
        return this.getThis();
    }

    public List<ManagedGroup> getManagedGroups() {
        return this.managedGroups;
    }

    public V setManagedGroups(List<ManagedGroup> managedGroups) {
        this.managedGroups = managedGroups;
        return this.getThis();
    }

    public List<ManagedGroup> getAutoGroups() {
        return this.autoGroups;
    }

    public V setAutoGroups(List<ManagedGroup> autoGroups) {
        this.autoGroups = autoGroups;
        return this.getThis();
    }

    public boolean isManagedGroupsRequiredForJITCreation() {
        return this.managedGroupsRequiredForJITCreation;
    }

    public V setManagedGroupsRequiredForJITCreation(boolean managedGroupsRequiredForJITCreation) {
        this.managedGroupsRequiredForJITCreation = managedGroupsRequiredForJITCreation;
        return this.getThis();
    }

    public String getName() {
        return this.name;
    }

    public V setName(String name) {
        this.name = name;
        return this.getThis();
    }

    public String getNotificationEmails() {
        return this.notificationEmails;
    }

    public V setNotificationEmails(String notificationEmails) {
        this.notificationEmails = notificationEmails;
        return this.getThis();
    }

    public List<Pair<String, String>> getUserTransformationRegexes() {
        return this.userTransformationRegexes;
    }

    public V setUserTransformationRegexes(List<Pair<String, String>> userTransformationRegexes) {
        this.userTransformationRegexes = userTransformationRegexes;
        return this.getThis();
    }

    public List<Pair<UsernameAttribute, String>> getUsernameAttributePriority() {
        return this.usernameAttributePriority;
    }

    public V setUsernameAttributePriority(List<Pair<UsernameAttribute, String>> usernameAttributePriority) {
        this.usernameAttributePriority = usernameAttributePriority;
        return this.getThis();
    }

    public boolean isSingleLogoutEnabled() {
        return this.singleLogoutEnabled;
    }

    public V setSingleLogoutEnabled(boolean singleLogoutEnabled) {
        this.singleLogoutEnabled = singleLogoutEnabled;
        return this.getThis();
    }

    public Optional<String> getSingleLogoutReturnURL() {
        return Optional.ofNullable(this.singleLogoutReturnURL);
    }

    public V setSingleLogoutReturnURL(String singleLogoutReturnURL) {
        this.singleLogoutReturnURL = singleLogoutReturnURL;
        return this.getThis();
    }

    public IdpConfiguration.UserActivatePolicy getUserActivatePolicy() {
        return this.userActivatePolicy;
    }

    public V setUserActivatePolicy(IdpConfiguration.UserActivatePolicy userActivatePolicy) {
        this.userActivatePolicy = userActivatePolicy;
        return this.getThis();
    }

    public void setRemoveNonIdpGroupsFromUser(boolean removeNonIdpGroupsFromUser) {
        this.removeNonIdpGroupsFromUser = removeNonIdpGroupsFromUser;
    }

    public IdpConfiguration.AutoCreateUserPolicy getAutoCreateUserPolicy() {
        return this.autoCreateUserPolicy;
    }

    public V setAutoCreateUserPolicy(IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy) {
        this.autoCreateUserPolicy = autoCreateUserPolicy;
        return this.getThis();
    }

    public IdpConfiguration.UserLookupAttribute getUserLookupAttribute() {
        return this.userLookupAttribute;
    }

    public V setUserLookupAttribute(IdpConfiguration.UserLookupAttribute userLookupAttribute) {
        this.userLookupAttribute = userLookupAttribute;
        return this.getThis();
    }

    public IdpConfiguration.UserLookupTransform getUserLookupTransform() {
        return this.userLookupTransform;
    }

    public V setUserLookupTransform(IdpConfiguration.UserLookupTransform userLookupTransform) {
        this.userLookupTransform = userLookupTransform;
        return this.getThis();
    }

    public IdpConfiguration.UsernamePolicy getUsernamePolicy() {
        return this.usernamePolicy;
    }

    public V setUsernamePolicy(IdpConfiguration.UsernamePolicy usernamePolicy) {
        this.usernamePolicy = usernamePolicy;
        return this.getThis();
    }

    public boolean isHostedDomain() {
        return this.hostedDomain;
    }

    public V setHostedDomain(boolean hostedDomain) {
        this.hostedDomain = hostedDomain;
        return this.getThis();
    }

    public IdpConfiguration.UserNotFoundPolicy getUserNotFoundPolicy() {
        return this.userNotFoundPolicy;
    }

    public V setUserNotFoundPolicy(IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy) {
        this.userNotFoundPolicy = userNotFoundPolicy;
        return this.getThis();
    }

    public IdpConfiguration.UserUpdateNamePolicy getUserUpdateNamePolicy() {
        return this.userUpdateNamePolicy;
    }

    public V setUserUpdateNamePolicy(IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy) {
        this.userUpdateNamePolicy = userUpdateNamePolicy;
        return this.getThis();
    }

    public IdpConfiguration.UserUpdateEmailPolicy getUserUpdateEmailPolicy() {
        return this.userUpdateEmailPolicy;
    }

    public V setUserUpdateEmailPolicy(IdpConfiguration.UserUpdateEmailPolicy userUpdatePolicy) {
        this.userUpdateEmailPolicy = userUpdatePolicy;
        return this.getThis();
    }

    public V setAuthenticatedAnonymousBrowsingEnabled(boolean authenticatedAnonymousBrowsingEnabled) {
        this.authenticatedAnonymousBrowsingEnabled = authenticatedAnonymousBrowsingEnabled;
        return this.getThis();
    }

    public boolean isAuthenticatedAnonymousBrowsingEnabled() {
        return this.authenticatedAnonymousBrowsingEnabled;
    }

    public V setServerName(String serverName) {
        this.serverName = serverName;
        return this.getThis();
    }

    public RedirectProperties getRedirectProperties() {
        return this.redirectProperties;
    }

    public V setRedirectProperties(RedirectProperties redirectProperties) {
        this.redirectProperties = redirectProperties;
        return this.getThis();
    }

    public RedirectProperties getJsmRedirectProperties() {
        return this.jsmRedirectProperties;
    }

    public V setJsmRedirectProperties(RedirectProperties jsmRedirectProperties) {
        this.jsmRedirectProperties = jsmRedirectProperties;
        return this.getThis();
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getTlsFingerprint() {
        return this.tlsFingerprint;
    }

    public V setTlsFingerprint(String tlsFingerprint) {
        this.tlsFingerprint = tlsFingerprint;
        return this.getThis();
    }

    public static class Saml
    extends IdpConfigurationBuilder<Saml, SamlIdpConfiguration> {
        private String idpUrl;
        private String idpSingleLogoutServiceURL;
        private List<byte[]> signingCerts;
        private String metadataURL;
        private String customNameIdFormat;
        private String issuer;
        private boolean encryptedAssertionsRequired = false;
        private boolean instantLoginUrlInSession = false;
        private boolean usePostBinding = false;
        private boolean autoRefreshMetadataEnabled = false;
        private String authnCtxClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
        private IdpConfiguration.AllowCreate allowCreate = IdpConfiguration.AllowCreate.TRUE;
        private SamlIdpConfiguration.IssuerPolicy issuerPolicy = SamlIdpConfiguration.IssuerPolicy.DEFAULT;
        private IdpConfiguration.NameIdFormat nameIdFormat = IdpConfiguration.NameIdFormat.DEFAULT;
        private SAMLSessionIdentification.ValidationPolicy sessionIdValidationPolicy = SAMLSessionIdentification.ValidationPolicy.getDefault();
        private SamlIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison = SamlIdpConfiguration.RequestedAuthnContextComparison.EXACT;
        private SamlIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy = SamlIdpConfiguration.RequestedAuthnContextPolicy.DO_NOT_SEND;

        public Saml(SamlIdpConfiguration source) {
            super(source);
            this.idpUrl = source.getIdpURL();
            this.signingCerts = source.getSigningCerts();
            this.encryptedAssertionsRequired = source.isEncryptedAssertionsRequired();
            this.instantLoginUrlInSession = source.isInstantLoginUrlInSession();
            this.usePostBinding = source.isUsePostBinding();
            this.metadataURL = source.getMetadataUrl();
            this.idpSingleLogoutServiceURL = source.getSingleLogoutServiceURL();
            this.requestedAuthnContextPolicy = source.getRequestedAuthnContextPolicy();
            this.requestedAuthnContextComparison = source.getRequestedAuthnContextComparison();
            this.authnCtxClassRef = source.getAuthnContextClassRef();
            this.issuerPolicy = source.getIssuerPolicy();
            this.issuer = source.getIssuer();
            this.allowCreate = source.getAllowCreate();
            this.customNameIdFormat = source.getCustomNameIdFormat();
            this.sessionIdValidationPolicy = source.getSessionIdentificationValidationPolicy();
            this.autoRefreshMetadataEnabled = source.isAutoRefreshMetadataEnabled();
        }

        public Saml(String id, IdpConfiguration.Kind kind) {
            super(id, kind);
        }

        @Override
        protected SamlIdpConfiguration buildInternal() {
            return new SamlIdpConfiguration(this.isMfaRequired(), this.getMfaAttribute(), this.getAllowCreate(), this.getDefaultGroups(), this.getDefaultGroupsRules(), this.isAutoUpdateKnownDomains(), this.getCustomEmailAttribute(), this.getCustomNameAttribute(), this.getCustomGivenNameAttribute(), this.getCustomSurnameAttribute(), this.getNameAttributeMapping(), this.isEnabled(), this.getId(), this.getJitDirectory(), this.getKind(), this.getKnownDomains(), this.isCreateAllIncomingGroups(), this.isRemoveNonIdpGroupsFromUser(), this.getManagedGroups(), this.getAutoGroups(), this.isManagedGroupsRequiredForJITCreation(), this.getName(), this.getNotificationEmails(), this.getUserTransformationRegexes(), this.getUsernameAttributePriority(), this.isSingleLogoutEnabled(), this.getUserActivatePolicy(), this.getUserLookupAttribute(), this.getUserLookupTransform(), this.getUsernamePolicy(), this.getUserNotFoundPolicy(), this.getUserUpdateNamePolicy(), this.getUserUpdateEmailPolicy(), this.getAutoCreateUserPolicy(), this.isHostedDomain(), this.getIdpGroupsAttributes(), this.getUserProfileKeyMapping(), this.isAuthenticatedAnonymousBrowsingEnabled(), this.getTlsFingerprint(), this.getAuthnCtxClassRef(), this.getCustomNameIdFormat().orElse(null), this.isEncryptedAssertionsRequired(), this.isInstantLoginUrlInSession(), this.isUsePostBinding(), this.getIdpUrl(), this.getIssuer().orElse(null), this.getIssuerPolicy(), this.getMetadataURL().orElse(null), this.getNameIdFormat(), this.getSessionIdValidationPolicy().orElse(null), this.getSigningCerts(), this.getIdpSingleLogoutServiceURL().orElse(null), this.getSingleLogoutReturnURL().orElse(null), this.getRequestedAuthnContextComparison(), this.getRequestedAuthnContextPolicy(), this.isAutoRefreshMetadataEnabled(), this.getRedirectProperties(), this.getJsmRedirectProperties());
        }

        @Override
        Saml getThis() {
            return this;
        }

        public String getIdpUrl() {
            return this.idpUrl;
        }

        public Saml setIdpUrl(String idpUrl) {
            this.idpUrl = idpUrl;
            return this;
        }

        public Optional<String> getIdpSingleLogoutServiceURL() {
            return Optional.ofNullable(this.idpSingleLogoutServiceURL);
        }

        public Saml setIdpSingleLogoutServiceURL(String idpSingleLogoutServiceURL) {
            this.idpSingleLogoutServiceURL = idpSingleLogoutServiceURL;
            return this;
        }

        public List<byte[]> getSigningCerts() {
            return this.signingCerts;
        }

        public Saml setSigningCerts(List<byte[]> signingCerts) {
            this.signingCerts = signingCerts;
            return this;
        }

        public boolean isEncryptedAssertionsRequired() {
            return this.encryptedAssertionsRequired;
        }

        public Saml setEncryptedAssertionsRequired(boolean encryptedAssertionsRequired) {
            this.encryptedAssertionsRequired = encryptedAssertionsRequired;
            return this;
        }

        public boolean isInstantLoginUrlInSession() {
            return this.instantLoginUrlInSession;
        }

        public Saml setInstantLoginUrlInSession(boolean instantLoginUrlInSession) {
            this.instantLoginUrlInSession = instantLoginUrlInSession;
            return this;
        }

        public boolean isUsePostBinding() {
            return this.usePostBinding;
        }

        public Saml setUsePostBinding(boolean userPostBinding) {
            this.usePostBinding = userPostBinding;
            return this;
        }

        public Optional<String> getMetadataURL() {
            return Optional.ofNullable(this.metadataURL);
        }

        public Saml setMetadataURL(String metadataURL) {
            this.metadataURL = metadataURL;
            return this;
        }

        public IdpConfiguration.AllowCreate getAllowCreate() {
            return this.allowCreate;
        }

        public Saml setAllowCreate(IdpConfiguration.AllowCreate allowCreate) {
            this.allowCreate = allowCreate;
            return this;
        }

        public String getAuthnCtxClassRef() {
            return this.authnCtxClassRef;
        }

        public Saml setAuthnCtxClassRef(String authnCtxClassRef) {
            this.authnCtxClassRef = authnCtxClassRef;
            return this;
        }

        public Optional<String> getCustomNameIdFormat() {
            return Optional.ofNullable(this.customNameIdFormat);
        }

        public Saml setCustomNameIdFormat(String customNameIdFormat) {
            this.customNameIdFormat = customNameIdFormat;
            return this;
        }

        public Optional<String> getIssuer() {
            return Optional.ofNullable(this.issuer);
        }

        public Saml setIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public SamlIdpConfiguration.IssuerPolicy getIssuerPolicy() {
            return this.issuerPolicy;
        }

        public Saml setIssuerPolicy(SamlIdpConfiguration.IssuerPolicy issuerPolicy) {
            this.issuerPolicy = issuerPolicy;
            return this;
        }

        public IdpConfiguration.NameIdFormat getNameIdFormat() {
            return this.nameIdFormat;
        }

        public Saml setNameIdFormat(IdpConfiguration.NameIdFormat nameIdFormat) {
            this.nameIdFormat = nameIdFormat;
            return this;
        }

        public Optional<SAMLSessionIdentification.ValidationPolicy> getSessionIdValidationPolicy() {
            return Optional.ofNullable(this.sessionIdValidationPolicy);
        }

        public Saml setSessionIdValidationPolicy(SAMLSessionIdentification.ValidationPolicy sessionIdValidationPolicy) {
            this.sessionIdValidationPolicy = sessionIdValidationPolicy;
            return this;
        }

        public SamlIdpConfiguration.RequestedAuthnContextComparison getRequestedAuthnContextComparison() {
            return this.requestedAuthnContextComparison;
        }

        public Saml setRequestedAuthnContextComparison(SamlIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison) {
            this.requestedAuthnContextComparison = requestedAuthnContextComparison;
            return this;
        }

        public SamlIdpConfiguration.RequestedAuthnContextPolicy getRequestedAuthnContextPolicy() {
            return this.requestedAuthnContextPolicy;
        }

        public Saml setRequestedAuthnContextPolicy(SamlIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy) {
            this.requestedAuthnContextPolicy = requestedAuthnContextPolicy;
            return this;
        }

        public boolean isAutoRefreshMetadataEnabled() {
            return this.autoRefreshMetadataEnabled;
        }

        public Saml setAutoRefreshMetadataEnabled(boolean autoRefreshMetadataEnabled) {
            this.autoRefreshMetadataEnabled = autoRefreshMetadataEnabled;
            return this;
        }
    }

    public static class Oidc
    extends IdpConfigurationBuilder<Oidc, OidcIdpConfiguration> {
        private String[] issuerAllowList;
        private String oidcDiscoveryUrl;
        private String oidcClientId;
        private String oidcClientSecret;
        private Long clientSecretExpiry = 0L;
        private Set<String> scopes;

        public Oidc(OidcIdpConfiguration source) {
            super(source);
            this.oidcDiscoveryUrl = source.getDiscoveryUrl();
            this.oidcClientId = source.getClientId();
            this.oidcClientSecret = source.getClientSecret();
            this.clientSecretExpiry = source.getClientSecretExpiry();
            this.scopes = source.getScope();
            this.issuerAllowList = source.getIssuerAllowList();
        }

        public Oidc(String id, IdpConfiguration.Kind kind) {
            super(id, kind);
        }

        @Override
        OidcIdpConfiguration buildInternal() {
            return new OidcIdpConfiguration(this.isMfaRequired(), this.getMfaAttribute(), this.getDefaultGroups(), this.getDefaultGroupsRules(), this.isAutoUpdateKnownDomains(), this.getCustomEmailAttribute(), this.getCustomNameAttribute(), this.getCustomGivenNameAttribute(), this.getCustomSurnameAttribute(), this.getNameAttributeMapping(), this.isEnabled(), this.getId(), this.getJitDirectory(), this.getKind(), this.getKnownDomains(), this.isCreateAllIncomingGroups(), this.isRemoveNonIdpGroupsFromUser(), this.getManagedGroups(), this.getAutoGroups(), this.isManagedGroupsRequiredForJITCreation(), this.getName(), this.getNotificationEmails(), this.getUserTransformationRegexes(), this.getUsernameAttributePriority(), this.isSingleLogoutEnabled(), this.getSingleLogoutReturnURL().orElse(null), this.getUserActivatePolicy(), this.getUserLookupAttribute(), this.getUserLookupTransform(), this.getUsernamePolicy(), this.getUserNotFoundPolicy(), this.getUserUpdateNamePolicy(), this.getUserUpdateEmailPolicy(), this.getAutoCreateUserPolicy(), this.isHostedDomain(), this.getIdpGroupsAttributes(), this.getUserProfileKeyMapping(), this.isAuthenticatedAnonymousBrowsingEnabled(), this.getTlsFingerprint(), this.getOidcClientId(), this.getOidcClientSecret(), this.getClientSecretExpiry(), this.getOidcDiscoveryUrl(), this.getScopes(), this.getIssuerAllowList(), this.getRedirectProperties(), this.getJsmRedirectProperties());
        }

        @Override
        Oidc getThis() {
            return this;
        }

        public String getOidcDiscoveryUrl() {
            return this.oidcDiscoveryUrl;
        }

        public Oidc setOidcDiscoveryUrl(String oidcDiscoveryUrl) {
            this.oidcDiscoveryUrl = oidcDiscoveryUrl;
            return this;
        }

        public String getOidcClientId() {
            return this.oidcClientId;
        }

        public Oidc setOidcClientId(String oidcClientId) {
            this.oidcClientId = oidcClientId;
            return this;
        }

        public String getOidcClientSecret() {
            return this.oidcClientSecret;
        }

        public Oidc setOidcClientSecret(String oidcClientSecret) {
            this.oidcClientSecret = oidcClientSecret;
            return this;
        }

        public Long getClientSecretExpiry() {
            return this.clientSecretExpiry;
        }

        public Oidc setClientSecretExpiry(Long clientSecretExpiry) {
            this.clientSecretExpiry = clientSecretExpiry;
            return this;
        }

        public Set<String> getScopes() {
            return this.scopes;
        }

        public Oidc setScopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Oidc setScopes(JSONArray scopes) {
            this.scopes = LinkedHashSet.ofAll((Iterable)scopes).map(Object::toString).toJavaSet();
            return this;
        }

        public String[] getIssuerAllowList() {
            return this.issuerAllowList;
        }

        public Oidc setIssuerAllowList(String[] issuerAllowList) {
            this.issuerAllowList = issuerAllowList;
            return this;
        }
    }
}

