/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.confluence.event.events.security.LoginDetails;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.security.login.HistoricalLoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.security.persistence.dao.hibernate.HibernateUserLoginInfoDao;
import com.atlassian.confluence.security.persistence.dao.hibernate.UserLoginInfo;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.LoginDetailsHelper;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.user.rememberme.ConfluenceRememberMeTokenDao;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RemembermeUtils;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservableHeaderAwareResponse;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfluenceHostApp
extends DefaultHostApp {
    private final Method onSuccessfulLoginAttemptMethod;
    private final LoginManager loginManager;
    private ConfluenceAccessManager confluenceAccessManager;
    private UserDetailsManager userDetailsManager;
    private UserManager userManager;
    private PermissionManager permissionManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Class<?> confluenceLoginManagerClass = null;
    private Method getLoginInfoMethod;
    private Method getLastSuccessfulLoginDateMethod;
    HibernateUserLoginInfoDao hibernateUserLoginInfoDao;
    UserAccessor userAccessor;

    public ConfluenceHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        this.hasRestApi = true;
        Method onSuccessfulLoginAttemptMethod = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader().getParent();
            if (classLoader != null) {
                this.confluenceLoginManagerClass = LoginManager.class;
                onSuccessfulLoginAttemptMethod = this.confluenceLoginManagerClass.getMethod("onSuccessfulLoginAttempt", String.class, HttpServletRequest.class);
            }
        }
        catch (Exception e) {
            this.log.warn("Could not load Confluence LoginManager. Login count / time update disabled", (Throwable)e);
        }
        this.onSuccessfulLoginAttemptMethod = onSuccessfulLoginAttemptMethod;
        this.loginManager = (LoginManager)ComponentLocator.getComponent(LoginManager.class);
        try {
            this.getLoginInfoMethod = this.loginManager.getClass().getMethod("getLoginInfo", String.class);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Couldn't find method getLoginInfo for class loginManager");
        }
        try {
            this.getLastSuccessfulLoginDateMethod = HistoricalLoginInfo.class.getMethod("getLastSuccessfulLoginDate", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Couldn't find method getLastSuccessfulLoginDateMethod for class HistoricalLoginInfo");
        }
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/index.action*");
        this.preemptivePathMappings.add("/dashboard*");
        this.preemptivePathMappings.add("/display/*");
        this.preemptivePathMappings.add("/dosearchsite.action*");
        this.preemptivePathMappings.add("/labels/*");
        this.preemptivePathMappings.add("/mail/archive/viewmailarchive.action*");
        this.preemptivePathMappings.add("/pages/*");
        this.preemptivePathMappings.add("/spaces/*");
        this.preemptivePathMappings.add("/spacedirectory/*");
        this.preemptivePathMappings.add("/users/*");
        this.preemptivePathMappings.add("/viewpage.action*");
        this.preemptivePathMappings.add("/plugins/inlinetasks/mytasks.action*");
        this.preemptivePathMappings.add("/plugins/servlet/sitemapservlet*");
        this.confluenceAccessManager = this.tryToGetConfluenceAccessManager();
        this.permissionManager = (PermissionManager)ComponentLocator.getComponent(PermissionManager.class);
        this.userDetailsManager = (UserDetailsManager)ComponentLocator.getComponent(UserDetailsManager.class);
        this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        this.userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        this.hibernateUserLoginInfoDao = (HibernateUserLoginInfoDao)ComponentLocator.getComponent(HibernateUserLoginInfoDao.class);
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String remoteIP = httpServletRequest.getRemoteAddr();
        String remoteHost = httpServletRequest.getRemoteHost();
        Boolean ssoLoginObj = (Boolean)httpServletRequest.getSession().getAttribute("com.atlassian.plugins.authentication.userLoggedInWithSso");
        LoginDetails.CaptchaState captchaState = httpServletRequest.getParameterValues("captchaId") != null ? LoginDetails.CaptchaState.PASSED : LoginDetails.CaptchaState.NOT_SHOWN;
        LoginDetails loginDetails = new LoginDetails(LoginDetailsHelper.isDirectLogin((HttpServletRequest)httpServletRequest) ? LoginDetails.LoginSource.DIRECT : LoginDetails.LoginSource.SSO, captchaState);
        this.log.debug(String.format("Confluence LoginEvent: %s, isSso: %s", user.getName(), ssoLoginObj));
        this.eventPublisher.publish((Object)new LoginEvent((Object)this, user.getName(), httpServletRequest.getSession().getId(), remoteHost, remoteIP, loginDetails));
        super.publishUserAuthenticatedEvent(user, httpServletRequest, httpServletResponse);
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return super.isForceLoginRequestMapped(req) || r.equals("/") || r.startsWith("/index.action") || r.startsWith("/dashboard") || r.startsWith("/display/") || r.startsWith("/labels/") || r.startsWith("/mail/archive/viewmailarchive.action") || r.startsWith("/pages/") || r.startsWith("/spaces/") || r.startsWith("/spacedirectory/") || r.startsWith("/users/") || r.startsWith("/viewpage.action") || r.startsWith("/plugins/inlinetasks/mytasks.action") || r.startsWith("/plugins/servlet/sitemapservlet") || r.startsWith("/dosearchsite.action");
    }

    @Override
    public Try<Integer> getFailedLoginAttempts(Principal principal) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.userAccessor.getUserByName(principal.getName())).mapTry((CheckedFunction1 & Serializable)userByName -> this.hibernateUserLoginInfoDao.findOrCreateUserLoginInfoForUser((User)userByName).getCurrentFailedLoginCount()).onFailure(e -> this.log.warn("An exception occurred while retrieving the currentFailedLoginCount for user " + UserManagerUtils.nullsafeUsernameOrAnonymous(principal), e));
    }

    @Override
    public Try<Void> setFailedLoginAttempts(Principal principal, int count) {
        return Try.run(() -> this.transactionTemplate.execute(() -> {
            ConfluenceUser user = this.userAccessor.getUserByName(principal.getName());
            UserLoginInfo orCreateUserLoginInfoForUser = this.hibernateUserLoginInfoDao.findOrCreateUserLoginInfoForUser((User)user);
            orCreateUserLoginInfoForUser.setCurrentFailedLoginCount(count);
            this.hibernateUserLoginInfoDao.saveOrUpdate(orCreateUserLoginInfoForUser);
            return null;
        })).onFailure(e -> this.log.warn("An exception occurred while setting the currentFailedLoginCount for user " + UserManagerUtils.nullsafeUsernameOrAnonymous(principal), e));
    }

    @Override
    public boolean shouldEnableHardRedirect(HttpServletRequest req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (requestPath.startsWith("/plugins/servlet/remotepageview")) {
            return true;
        }
        return super.shouldEnableHardRedirect(req);
    }

    private ConfluenceAccessManager tryToGetConfluenceAccessManager() {
        try {
            Class<?> camClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.security.access.ConfluenceAccessManager");
            return (ConfluenceAccessManager)ComponentLocator.getComponent(camClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"confluence", (CharSequence)product);
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return this.isPageWithLoginForm(req) || this.isWebdavRequest(req) && this.kerbConfManager.isKeytabConfigured() && this.kerbConfManager.isKerberosEnabled() && this.kerbConfManager.isWebdavEnabled() || this.kerbConfManager.isKerberosKnowledgeBaseEnabled() && r.startsWith("/plugins/servlet/remotepageview");
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req) {
        String requestUri = HttpUrlUtils.getInternalPath(req);
        String qs = req.getQueryString();
        return (this.isMainLoginPage(req) || requestUri.startsWith("/m/login/login.action")) && this.avoidSSOForUserAvatar(qs);
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequest request) {
        String internalPath = HttpUrlUtils.getInternalPath(request);
        return internalPath.startsWith("/login.action");
    }

    private boolean avoidSSOForUserAvatar(String qs) {
        return this.kerbConfManager.isSSOEnabledForUserAvatar() || !this.isUserAvatar(qs);
    }

    private boolean isUserAvatar(String qs) {
        return StringUtils.isNotBlank((CharSequence)qs) && qs.matches(".*%2Fdownload%2Fattachments%2F.*%2Fuser-avatar.*");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        Boolean logout = (Boolean)Option.of((Object)req.getParameter("logout")).map(Boolean::parseBoolean).getOrElse((Object)false);
        Boolean webdavRequestButDisabled = this.isWebdavRequest(req) && !this.kerbConfManager.isWebdavEnabled();
        return logout != false || webdavRequestButDisabled != false;
    }

    private boolean isWebdavRequest(HttpServletRequest req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        return requestPath.startsWith("/plugins/servlet/confluence");
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return "/dologin.action".equals(r) && "POST".equals(req.getMethod());
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("os_username");
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        String qs = Optional.ofNullable(req.getQueryString()).orElse("");
        if (requestPath.startsWith("/plugins/servlet/remotepageview")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else if (this.isWebdavRequest(req)) {
            this.log.debug("Doing nothing on Webdav request");
        } else if (this.isRestApi(requestPath)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservableHeaderAwareResponse(resp));
        } else if (requestPath.startsWith("/login.action") || requestPath.startsWith("/m/login/login.action")) {
            if (qs.contains("logout%3FSAMLResponse")) {
                resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=");
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        } else if (ConfluenceHostApp.shouldDispatchToLoginPage(this.kerbConfManager)) {
            String returnUrl = requestPath;
            returnUrl = returnUrl + (StringUtils.isNotBlank((CharSequence)qs) ? "?" + qs : "");
            resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=" + HttpUrlUtils.urlEncode(returnUrl));
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    @Override
    public Option<String> getAnonymousBrowsingSettingsUrl() {
        return Option.of((Object)"/admin/permissions/globalpermissions.action");
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.seraphLikeInvalidateSession(req);
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)ConfluenceUserPrincipal.of((Principal)user));
        req.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        this.recordSuccessfulLoginEventWithLoginManager(user, req);
        return user;
    }

    private void recordSuccessfulLoginEventWithLoginManager(Principal user, HttpServletRequest req) {
        try {
            this.loginManager.onSuccessfulLoginAttempt(user.getName(), req);
        }
        catch (Exception e) {
            this.log.warn("Failing registering successful login in Confluence", (Throwable)e);
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (this.isWebdavRequest(req) || this.isRestApi(requestPath)) {
            UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
            ConfluenceUser confluenceUser = accessor.getUserByName(user.getName());
            AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            super.postSuccessfulLoginWithKerberosAction(user, req, res, chain);
        }
    }

    @Override
    public boolean isPublicAccessEnabled() {
        if (this.confluenceAccessManager == null) {
            this.log.warn("No ConfluenceAccessManager available, unable to determine public access");
            return super.isPublicAccessEnabled();
        }
        AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(null);
        return userAccessStatus.hasAnonymousAccess() || userAccessStatus.hasUnlicensedAuthenticatedAccess();
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.confluence.user.ConfluenceAuthenticator";
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequest request) {
        UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        User confluenceUser = accessor.getUser(user.getName());
        if (this.confluenceAccessManager != null) {
            AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(confluenceUser);
            return userAccessStatus.canUseConfluence();
        }
        if (this.permissionManager != null) {
            return this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
        }
        return false;
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/users/browseusers.action";
    }

    @Override
    public boolean supportsRemoveAllRememberMeTokens() {
        return true;
    }

    @Override
    public void removeAllRememberMeTokens() {
        ConfluenceRememberMeTokenDao component = (ConfluenceRememberMeTokenDao)ComponentLocator.getComponent(ConfluenceRememberMeTokenDao.class);
        component.removeAll();
    }

    @Override
    public void addUser(Directory directory, final String username, final String fullName, final String email, Set<String> groups, boolean isActive) throws UserAlreadyExistsException {
        super.addUser(directory, username, fullName, email, groups, isActive);
        User user = new User(){

            public String getFullName() {
                return fullName;
            }

            public String getEmail() {
                return email;
            }

            public String getName() {
                return username;
            }
        };
        UserCreateEvent event = new UserCreateEvent((Object)this, user);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public UserWithAttributes getUserForCleanup(com.atlassian.crowd.embedded.api.User user) {
        return UserTemplateWithAttributes.toUserWithNoAttributes((com.atlassian.crowd.embedded.api.User)user);
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        try {
            Date lastLogin;
            this.log.debug("Calling getLastSuccessfulLoginDate");
            if (this.getLoginInfoMethod == null) {
                throw new RuntimeException("getLoginInfo method is null");
            }
            Object loginInfo = this.getLoginInfoMethod.invoke((Object)this.loginManager, user.getName());
            if (this.getLastSuccessfulLoginDateMethod != null) {
                lastLogin = (Date)this.getLastSuccessfulLoginDateMethod.invoke(loginInfo, new Object[0]);
            } else {
                Method getLastSuccessfulLoginDate = loginInfo.getClass().getMethod("getLastSuccessfulLoginDate", new Class[0]);
                getLastSuccessfulLoginDate.setAccessible(true);
                lastLogin = (Date)getLastSuccessfulLoginDate.invoke(loginInfo, new Object[0]);
            }
            this.log.debug("getLastSuccessfulLoginDate for user {} was {}", (Object)user.getName(), (Object)lastLogin);
            if (lastLogin != null) {
                return String.format("%d", lastLogin.getTime());
            }
            return null;
        }
        catch (Exception e) {
            this.log.error("Problems calling getLastSuccessfulLoginDate", (Throwable)e);
            return String.format("%d", new Date().getTime());
        }
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticated";
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("confluence-administrators"))) {
            return "confluence-administrators";
        }
        return null;
    }

    @Override
    public String getLoginPage() {
        return "/login.action";
    }

    @Override
    public String getLogoutPage() {
        return "/login.action?logout=true";
    }

    @Override
    public boolean isLogoutPage(HttpServletRequest req) {
        return this.getLogoutPage().equalsIgnoreCase(HttpUrlUtils.getInternalPath(req));
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5502;
    }

    @Override
    public void setRememberMeCookie(HttpServletRequest request, HttpServletResponse response, String username) {
        RemembermeUtils.setRememberMeCookie(request, response, username);
    }

    @Override
    public io.vavr.collection.List<String> getUserProfileKeys() {
        return io.vavr.collection.List.ofAll((Iterable)this.userDetailsManager.getProfileGroups()).map(arg_0 -> ((UserDetailsManager)this.userDetailsManager).getProfileKeys(arg_0)).flatMap(io.vavr.collection.List::ofAll);
    }

    @Override
    public void setUserProfileValue(String username, String key, String value) {
        Try.of((CheckedFunction0 & Serializable)() -> username).mapTry(arg_0 -> ((UserManager)this.userManager).getUser(arg_0)).peek(user -> Try.run(() -> this.userDetailsManager.setStringProperty(user, key, value))).peek(user -> Try.run(() -> this.userManager.saveUser(user)));
    }

    @Override
    public String getUserProfileValue(String username, String key) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> username).mapTry(arg_0 -> ((UserManager)this.userManager).getUser(arg_0)).mapTry((CheckedFunction1 & Serializable)user -> this.userDetailsManager.getStringProperty(user, key)).getOrElse((Object)"");
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequest request) {
        return super.isRestPathInternalAtlassianFunctionality(request) || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/api/content") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/prototype/1/search.json") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath(request), (CharSequence)"/rest/mywork");
    }

    @Override
    public boolean isMsTeamsSecurityHeadersEnabled() {
        return this.kerbConfManager.isMsTeamsSecurityHeadersEnabled();
    }

    @Override
    public Map<String, String> mapNameToExternalId(List<com.atlassian.crowd.embedded.api.User> userBatch, Map<String, String> userData) {
        if (userBatch.size() == 0) {
            return userData;
        }
        if (!userBatch.get(0).getClass().equals(InternalUser.class)) {
            userBatch.forEach(user -> userData.put(user.getName(), ((TimestampedUser)user).getExternalId()));
        } else {
            userBatch.forEach(user -> userData.put(user.getName(), ((InternalUser)user).getExternalId()));
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUsersProfilePicture(List<com.atlassian.crowd.embedded.api.User> users) {
        HashMap<String, String> usernameAvatarUriMap = new HashMap<String, String>();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        for (com.atlassian.crowd.embedded.api.User user : users) {
            String uri = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/images/icons/profilepics/default.svg";
            try {
                User atlassianUser = this.userManager.getUser(user.getName());
                uri = userAccessor.getUserProfilePicture(atlassianUser).getUriReference();
                usernameAvatarUriMap.put(user.getName(), uri);
            }
            catch (EntityException entityException) {}
            continue;
            finally {
                usernameAvatarUriMap.put(user.getName(), uri);
            }
        }
        return usernameAvatarUriMap;
    }
}

