/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.kantega.atlaskerb.DnsRecord;

public class DnsUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnsRecord lookup(String hostname) throws NamingException {
        try (Context context = null;){
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            context = new InitialDirContext(env);
            String name = hostname;
            String CNAMEalias = null;
            for (int i = 0; i < 10; ++i) {
                Attributes attributes = context.getAttributes(name, new String[]{"A", "CNAME"});
                Attribute aAttribute = attributes.get("A");
                Attribute cAttribute = attributes.get("CNAME");
                if (aAttribute != null) {
                    if (CNAMEalias != null) {
                        DnsRecord dnsRecord = new DnsRecord(null, CNAMEalias);
                        return dnsRecord;
                    }
                    DnsRecord dnsRecord = new DnsRecord(aAttribute.get(0) != null ? aAttribute.get(0).toString() : null, null);
                    return dnsRecord;
                }
                if (cAttribute == null) continue;
                CNAMEalias = cAttribute.get(0).toString();
                while (CNAMEalias.endsWith(".")) {
                    CNAMEalias = CNAMEalias.substring(0, CNAMEalias.length() - 1);
                }
                name = CNAMEalias;
            }
            DnsRecord dnsRecord = new DnsRecord(hostname, null);
            return dnsRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getARecordFromDns(String hostname) throws NamingException {
        try (Context context = null;){
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            context = new InitialDirContext(env);
            Attributes attributes = context.getAttributes(hostname, new String[]{"A"});
            Attribute a = attributes.get("A");
            String string = a != null && a.get(0) != null ? a.get(0).toString() : null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCNAMEaliasFromDns(String hostname) throws NamingException {
        try (Context context = null;){
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            context = new InitialDirContext(env);
            Attributes attributes = context.getAttributes(hostname, new String[]{"CNAME"});
            Attribute CNAMEalias = attributes.get("CNAME");
            if (CNAMEalias != null) {
                String c = CNAMEalias.get(0).toString();
                while (c.endsWith(".")) {
                    c = c.substring(0, c.length() - 1);
                }
                String string = c;
                return string;
            }
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPtrRecordFromDns(String ip) throws NamingException {
        try (Context context = null;){
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            context = new InitialDirContext(env);
            ArrayList<String> comps = new ArrayList<String>();
            for (String c : ip.split("\\.")) {
                comps.add(0, c);
            }
            StringBuilder sb = new StringBuilder();
            for (String comp : comps) {
                if (sb.length() != 0) {
                    sb.append(".");
                }
                sb.append(comp);
            }
            sb.append(".in-addr.arpa.");
            Attributes attributes = context.getAttributes(sb.toString(), new String[]{"PTR"});
            Attribute a = attributes.get("PTR");
            String string = DnsUtils.stripTrailingDot(a.get(0) != null ? a.get(0).toString() : null);
            return string;
        }
    }

    private static String stripTrailingDot(String address) {
        if (address != null) {
            while (address.endsWith(".")) {
                address = address.substring(0, address.length() - 1);
            }
        }
        return address;
    }
}

