/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class SSOScriptLoginHookCondition
implements Condition {
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final HttpContext httpContext;
    private Set<String> products;

    @Inject
    public SSOScriptLoginHookCondition(@ComponentImport HttpContext httpContext, RequireAdminServletDependencyBucket bucket) {
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String products = params.get("products");
        if (products != null) {
            this.products = new HashSet<String>();
            for (String product : products.split(",")) {
                if ((product = product.trim()).isEmpty()) continue;
                this.products.add(product);
            }
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        HttpServletRequest request = this.httpContext.getRequest();
        return this.shouldAddLoginScripts(request);
    }

    public boolean shouldDoFederatedSSO(HttpServletRequest request) {
        return !this.querystringHasNoSso(request) && !this.hostApp.isRestApi(HttpUrlUtils.getInternalPath(request)) && this.isProductMatch() && this.idpConfManager.isFederatedSsoEnabled() && this.idpConfManager.isLicenseValid() && this.idpConfManager.countActiveProviders() > 0;
    }

    public boolean shouldAddLoginScripts(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String requestAddress = HttpUrlUtils.getInternalPath(request);
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(request);
        boolean isLogoutPage = this.hostApp.getLogoutPage().replaceAll("!default", "").equals(requestAddress.replaceAll("!default", ""));
        return (isLogoutPage || isLoginPage) && this.shouldDoFederatedSSO(request);
    }

    public boolean shouldAddMSTeamsScripts(HttpServletRequest request) {
        return this.hostApp.isPageWithLoginForm(request) && this.kerbConfManager.isMsTeamsAuthenticationEnabled();
    }

    private boolean querystringHasNoSaml(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"nosaml");
    }

    private boolean querystringHasNoSso(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"nosso");
    }

    public static boolean querystringHasNoredirect(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)"noredirect");
    }

    private boolean isProductMatch() {
        if (this.products == null) {
            return true;
        }
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }
}

