/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.inject.Inject;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.DnsRecord;
import org.kantega.atlaskerb.DnsUtils;
import org.kantega.atlaskerb.ExceptionTool;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.kerberos.keytab.EncryptionType;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.userlookup.UsernameTransformAction;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.SpNegoResult;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKerberosAction
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(TestKerberosAction.class);
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;

    @Inject
    public TestKerberosAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("exceptionTool", new ExceptionTool());
        ArrayList<String> errors = new ArrayList<String>();
        model.put("errors", errors);
        this.checkNonstandardSeraphAuthenticator(model, errors);
        this.checkPublicAccessVsPreemptive(model);
        this.checkPublicAccessVsRequiredGroups(model);
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, "Kerberos");
        this.checkLicensing(model);
        this.checkRequestUrlStartsWithBaseUrl(req, model);
        this.addHostAndDomainName(model, req.getHeader("Host"));
        this.checkIpRestrictions(req, model);
        this.checkDisabledUserAgent(req, model);
        this.checkJavaVersion(model);
        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
        this.checkGitCnameSetup(model);
        this.checkUsingIpAddress(model, req);
        model.put("keytab", new Keytab(this.kerbConfManager.getKeytabInfos()));
        SpNego result = null;
        boolean policyFilesValid = TestKerberosAction.checkMaxKeyLength(model);
        model.put("policyFilesValid", policyFilesValid);
        if (policyFilesValid && (result = this.tryNegotiation(model, req, resp)) != null && result.getResult() == SpNegoResult.AUTHORIZED) {
            this.findUser(result, model, req);
        }
        if (req.getParameter("keytab") != null && Boolean.TRUE.equals(model.get("canLogin"))) {
            resp.sendRedirect("config");
            return;
        }
        resp.setContentType("text/html");
        if (req.getParameter("ajax") != null) {
            if (errors.isEmpty() && result != null && result.getResult() == SpNegoResult.AUTHORIZED) {
                UserProfile userProfile = (UserProfile)model.get("userProfile");
                if (userProfile != null) {
                    resp.setHeader("X-Kerberos-Success", "true");
                    resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
                    resp.getWriter().print(userProfile.getFullName() + " (Principal: " + result.getAuthorizedPrincipal() + ")");
                } else {
                    resp.sendError(404);
                }
            }
        } else {
            StringWriter debuginfo = new StringWriter();
            this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
            model.put("debugInfo", debuginfo);
            this.renderer.render("templates/atlaskerb/testresult.vm", model, (Writer)resp.getWriter());
        }
    }

    private void checkRequestUrlStartsWithBaseUrl(HttpServletRequest req, Map<String, Object> model) {
        String reqBaseUrl = HttpUrlUtils.getRequestBaseUrl(req);
        boolean isBaseUrlEqualToRequestUrl = reqBaseUrl.equals(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL));
        model.put("reqBaseUrl", reqBaseUrl);
        model.put("reqUrlStartsWithBaseUrl", isBaseUrlEqualToRequestUrl);
    }

    private void checkGitCnameSetup(Map<String, Object> model) {
        block2: {
            Iterator<KeytabInfo> iterator;
            if (!this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled()) break block2;
            model.put("gitEnabled", this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled());
            Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
            model.put("cnameFoundInKeytab", false);
            Boolean isCNAME = (Boolean)Option.of((Object)model.get("isCNAME")).flatMap((Function)CheckedFunction1.lift(Boolean.class::cast)).getOrElse((Object)false);
            if (isCNAME.booleanValue() && (iterator = keytab.getEntries().iterator()).hasNext()) {
                KeytabInfo info = iterator.next();
                Boolean isHost = (Boolean)Option.of((Object)model.get("host")).flatMap((Function)CheckedFunction1.lift(String.class::cast)).map(info.getHostPart()::equalsIgnoreCase).getOrElse((Object)false);
                if (isHost.booleanValue()) {
                    model.put("cnameFoundInKeytab", true);
                }
            }
        }
    }

    private void checkNonstandardSeraphAuthenticator(Map<String, Object> model, List<String> errors) {
        String nonStandardAuthenticator = this.hostApp.hasNonStandardAuthenticator();
        if (nonStandardAuthenticator != null) {
            errors.add("Non standard authenticator");
            model.put("nonStandardSeraphAuthenticator", nonStandardAuthenticator);
            model.put("standardSeraphAuthenticator", this.hostApp.getStandardAuthenticatorClassName());
        }
    }

    private void checkPublicAccessVsRequiredGroups(Map<String, Object> model) {
        model.put("shouldEnableRequiredGroups", this.kerbConfManager.getRequiredGroups().isEmpty() && this.hostApp.isPublicAccessEnabled());
    }

    private void checkPublicAccessVsPreemptive(Map<String, Object> model) {
        model.put("shouldEnablePreemptive", !this.kerbConfManager.isRequireLogin() && this.hostApp.isPublicAccessEnabled());
    }

    public static void checkUserDirectories(Map<String, Object> model, UserLookupService userLookupService) {
        model.put("activeUserDirectories", userLookupService.getActiveUserDirectories());
        model.put("userLookupService", userLookupService);
        StringBuilder list = new StringBuilder();
        for (Directory directory : userLookupService.getActiveUserDirectories()) {
            if (list.length() != 0) {
                list.append(", ");
            }
            list.append(directory.getName());
        }
        model.put("activeUserDirectoriesList", list.toString());
        model.put("directoryDescriber", new DirectoryDescriber());
    }

    private void checkUsingIpAddress(Map<String, Object> model, HttpServletRequest req) {
        String serverName = req.getServerName();
        for (char c : serverName.toCharArray()) {
            if (Character.isDigit(c) || c == '.') continue;
            return;
        }
        model.put("usingIpAddress", true);
    }

    public static boolean checkMaxKeyLength(Map<String, Object> model) {
        try {
            File libSecurityDir = new File(new File(System.getProperty("java.home"), "lib"), "security");
            File usExportPolicyFile = new File(libSecurityDir, "US_export_policy.jar");
            File localPolicyFile = new File(libSecurityDir, "local_policy.jar");
            model.put("usExportPolicyFile", usExportPolicyFile);
            model.put("localPolicyFile", localPolicyFile);
            model.put("libSecurity", System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator);
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.8")) {
                model.put("policyLink", "http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html");
            } else {
                model.put("policyLink", "http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html");
            }
            if (TestKerberosAction.existsAndIsNotReadable(localPolicyFile) || TestKerberosAction.existsAndIsNotReadable(usExportPolicyFile)) {
                return false;
            }
            try {
                int maxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
                if (maxKeyLength == 128) {
                    model.put("limitedKeyLength", true);
                }
            }
            catch (NoClassDefFoundError e) {
                model.put("noClassDefGettingMaxAllowedKeyLength", true);
                return false;
            }
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        return true;
    }

    private static boolean existsAndIsNotReadable(File policyFile) {
        return policyFile.exists() && !policyFile.canRead();
    }

    public static void addDebugInfo(HttpServletRequest req, Map<String, Object> model, ConnectorConfManager connectorConfManager, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, ApplicationProperties applicationProperties, UserLookupService userLookupService, String authThisTest) {
        model.put("javaVersion", System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
        model.put("isPreemptiveAuthEnabled", kerbConfManager.isRequireLogin());
        model.put("isRestAuthEnabled", kerbConfManager.isKerberosRestAuthEnabled());
        model.put("isTraditionalLoginDisabled", kerbConfManager.isTraditionalLoginPrevented());
        model.put("isTraditionalLoginJsmDisabled", kerbConfManager.isTraditionalLoginJsmPrevented());
        model.put("isBasicAuthEnabled", kerbConfManager.isBasicAuthEnabled());
        model.put("isRemembermeCookieEnabled", kerbConfManager.isRemembermeCookieEnabled());
        model.put("authNameThisTest", authThisTest);
        model.put("kerberosEnabled", kerbConfManager.isKerberosEnabled());
        model.put("kerberosConfigured", kerbConfManager.isKeytabConfigured());
        model.put("canonicalBaseUrl", applicationProperties.getBaseUrl(UrlMode.CANONICAL));
        model.put("samlEnabled", idpConfManager.isFederatedSsoEnabled());
        model.put("activeProviders", idpConfManager.countActiveProviders());
        model.put("connectorsEnabled", !connectorConfManager.getDirectories().isEmpty());
        model.put("osName", System.getProperty("os.name"));
        model.put("osVersion", System.getProperty("os.version"));
        model.put("isWindows", System.getProperty("os.name").toLowerCase().contains("windows"));
        model.put("javaHome", System.getProperty("java.home"));
        model.put("userAgent", req.getHeader("User-Agent"));
        model.put("requestURL", req.getRequestURL().toString());
        String remoteAddr = req.getRemoteAddr();
        model.put("remoteAddr", remoteAddr);
        Set<String> localIpAddresses = TestKerberosAction.getLocalIpAddresses();
        model.put("localIpAddresses", localIpAddresses);
        model.put("isLocalAccess", localIpAddresses.contains(kerbConfManager.getRemoteIpAddress(req)));
        model.put("displayName", applicationProperties.getDisplayName());
        model.put("applicationVersion", applicationProperties.getVersion());
        model.put("applicationProperties", applicationProperties);
        model.put("sessionMaxInactiveInterval", req.getSession().getMaxInactiveInterval());
        model.put("sessionLastAccessedTime", new Date(req.getSession().getLastAccessedTime()));
        TestKerberosAction.checkAuthorizationHeader(req, model);
        TestKerberosAction.checkUserDirectories(model, userLookupService);
        TestKerberosAction.checkDns(model, req);
        TestKerberosAction.addPluginVersion(model);
        TreeMap<String, String> xForwardedHeaders = new TreeMap<String, String>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!name.toLowerCase().startsWith("x-forwarded-")) continue;
            xForwardedHeaders.put(name, req.getHeader(name));
        }
        model.put("xForwardedHeaders", xForwardedHeaders);
    }

    private static Set<String> getLocalIpAddresses() {
        TreeSet<String> addresses = null;
        try {
            addresses = new TreeSet<String>();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress inetAddress = addrs.nextElement();
                    addresses.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return addresses;
    }

    private static void addPluginVersion(Map<String, Object> model) {
        Properties props = new Properties();
        try (InputStream resourceStream = TestKerberosAction.class.getResourceAsStream("/META-INF/maven/no.kantega.kerberosauth/kerberosauth-plugin/pom.properties");){
            props.load(resourceStream);
            model.put("pluginVersion", props.getProperty("version"));
        }
        catch (IOException e) {
            log.error("Could not load plugin version", (Throwable)e);
        }
    }

    private void checkLicensing(Map<String, Object> model) {
        if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get();
            model.put("licenseValid", license.isValid());
        } else {
            model.put("licenseMissing", Boolean.TRUE);
        }
    }

    private void addHostAndDomainName(Map<String, Object> model, String host) {
        String address = host;
        if (address.contains(":")) {
            address = address.substring(0, address.indexOf(":"));
        }
        int lastDot = address.lastIndexOf(".");
        for (int i = 0; i < address.length(); ++i) {
            if (address.indexOf(".", i) != lastDot) continue;
            model.put("domain", address.substring(i));
            break;
        }
        model.put("address", address);
    }

    public static void checkSupportedBrowser(Map<String, Object> model, String userAgent) {
        if (userAgent != null) {
            String lcAgent = userAgent.toLowerCase();
            if (lcAgent.contains("edge/")) {
                model.put("usingEdge", Boolean.TRUE);
            } else if (lcAgent.contains("opera") || lcAgent.contains("opr/")) {
                model.put("usingOpera", Boolean.TRUE);
            } else if (lcAgent.contains("firefox")) {
                model.put("usingFirefox", Boolean.TRUE);
            } else if (lcAgent.contains("chrom")) {
                model.put("usingChrome", Boolean.TRUE);
            } else if (lcAgent.contains("safari")) {
                model.put("usingSafari", Boolean.TRUE);
            } else if (lcAgent.contains("explorer") || lcAgent.contains("msie") || lcAgent.contains("trident/") && lcAgent.contains("rv:11")) {
                model.put("usingInternetExplorer", Boolean.TRUE);
            }
            if (lcAgent.contains("macintosh")) {
                model.put("usingMac", Boolean.TRUE);
            }
        }
    }

    private void checkIpRestrictions(HttpServletRequest req, Map<String, Object> model) {
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        String ipAddress = this.kerbConfManager.getRemoteIpAddress(req);
        IpRestrictionFilter ipRestrictionFilter = restrictionCfg.getGlobalIpFilter();
        model.put("ipRestrictionType", restrictionCfg.getGlobalRestrictionType().name());
        model.put("isGlobalIpEnabled", ipRestrictionFilter.isRemoteAddressEnabled(ipAddress));
        model.put("remoteAddr", ipAddress);
    }

    private void checkDisabledUserAgent(HttpServletRequest req, Map<String, Object> model) {
        String userAgent = req.getHeader("User-agent");
        model.put("isUserAgentEnabledByCustomList", this.kerbConfManager.isUserAgentEnabledByCustomList(userAgent));
        model.put("isUserAgentEnabledByDefaultList", this.kerbConfManager.isUserAgentEnabledByDefaultList(userAgent));
    }

    private Map<String, List<String>> getSortedDirectoryLookupNames(String userPrincipalName) {
        List<Directory> dirs = this.userLookupService.getActiveUserDirectories();
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Directory dir : dirs) {
            Map<UsernameTransformAction, String> lookupNames = this.userLookupService.findLookupNamesInDir(userPrincipalName, dir);
            List orderedTransformations = this.userLookupService.sortAndFilterUTAs(lookupNames, this.kerbConfManager.isOnlyRegexTransformationLookup()).stream().map(lookupNames::get).collect(Collectors.toList());
            result.put(dir.getName(), orderedTransformations);
        }
        return result;
    }

    private void findUser(SpNego spNego, Map<String, Object> model, HttpServletRequest req) {
        if (spNego.getResult() == SpNegoResult.AUTHORIZED) {
            String authorizedPrincipal = spNego.getAuthorizedPrincipal();
            StringBuilder list = new StringBuilder();
            Map<UsernameTransformAction, String> lookupNames = this.userLookupService.getAccountNamesForLookup(authorizedPrincipal);
            for (UsernameTransformAction action : lookupNames.keySet()) {
                if (list.length() != 0) {
                    list.append(", ");
                }
                list.append(lookupNames.get((Object)action));
            }
            model.put("sortedDirectoryLookupNames", this.getSortedDirectoryLookupNames(spNego.getAuthorizedPrincipal()));
            PrincipalEntry principalEntry = this.userLookupService.lookupUserForKerberos(authorizedPrincipal, false);
            String contextPath = req.getContextPath();
            model.put("contextPath", contextPath);
            model.put("isActive", principalEntry.getUserState() != PrincipalEntry.UserState.INACTIVE);
            if (principalEntry.getUserState() == PrincipalEntry.UserState.FOUND && principalEntry.getPrincipal().isPresent()) {
                Principal principal = principalEntry.getPrincipal().get();
                model.put("usersDirectory", this.hostApp.getDirectoryForUser(principal.getName()));
                model.put("userPrincipal", principal);
                model.put("userProfile", this.userManager.getUserProfile(principal.getName()));
                model.put("canLogin", this.hostApp.canLogin(principal, req));
                if (!this.hostApp.isUserInRequiredGroups(principal.getName())) {
                    model.put("requiredGroup", StringUtils.join(this.kerbConfManager.getRequiredGroups(), (String)","));
                }
                ArrayList<Directory> dirsAllowing = new ArrayList();
                try {
                    dirsAllowing = this.userLookupService.getDirectoriesAllowingKerberosLogin();
                }
                catch (RuntimeException e) {
                    log.warn("Not able to search for directories: " + e.getMessage());
                }
                model.put("kerberosEnabled", this.kerbConfManager.isKerberosEnabled());
                model.put("kerberosDisabledForAll", this.userLookupService.getDirectoriesAllowingKerberosLogin().size() == 0 && this.kerbConfManager.getAllowKerberosLoginGroups().size() == 0 && this.kerbConfManager.getDisallowKerberosLoginGroups().size() == 0);
                model.put("kerberosDisabledForUser", !this.userLookupService.isUserInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, this.kerbConfManager.getAllowKerberosLoginGroups(), this.kerbConfManager.getDisallowKerberosLoginGroups(), principal.getName()));
            } else {
                model.put("userManagerLink", contextPath + this.hostApp.getUserManagerLink());
                model.put("canLogin", false);
            }
        }
    }

    private void checkJavaVersion(Map<String, Object> model) {
        float specificationVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        if (specificationVersion < 1.7f) {
            model.put("outdatedJava", System.getProperty("java.specification.version"));
        }
    }

    private SpNego tryNegotiation(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        DecodedKerberosToken decodedKerberosToken;
        String atz = request.getHeader("Authorization");
        if (atz == null || !atz.startsWith("Negotiate ")) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Negotiate");
            return null;
        }
        SpNego spNego = new SpNego();
        model.put("spNego", spNego);
        try {
            decodedKerberosToken = this.kerbConfManager.decodeKerberosToken(request);
        }
        catch (Exception e) {
            model.put("decodeKerberosTokenException", e);
            if (e instanceof SpNego.NtlmTokenException || e instanceof SpNego.DirectNtlmTokenException) {
                response.setStatus(401);
            }
            return spNego;
        }
        Subject subject = this.kerbConfManager.getSubject(decodedKerberosToken);
        for (KerberosPrincipal principal : subject.getPrincipals(KerberosPrincipal.class)) {
            model.put("subjectPrincipal", principal);
            for (KeyTab cred : subject.getPrivateCredentials(KeyTab.class)) {
                KerberosKey[] keys = cred.getKeys(principal);
                if (keys == null) continue;
                model.put("subjectKeys", Arrays.asList(keys));
            }
        }
        spNego.negotiate(subject, request, response);
        if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NTLM) {
            response.setStatus(401);
        }
        this.checkSpNegoResult(spNego, model);
        this.checkChannelBindingMismatch(spNego, model);
        this.checkAES256NotPermitted(spNego, model);
        this.checkChecksumFailed(spNego, model);
        this.checkOutdatedVersion(spNego, model);
        this.decodeKerberosToken(spNego, model);
        return spNego;
    }

    private void decodeKerberosToken(SpNego spNego, Map<String, Object> model) {
        try {
            byte[] kerberosToken = spNego.getKerberosToken();
            if (kerberosToken != null) {
                DecodedKerberosToken decodedKerberosToken = DecodedKerberosToken.fromToken((byte[])kerberosToken);
                model.put("decodedKerberosToken", decodedKerberosToken);
                model.put("decodedKerberosEnctype", EncryptionType.byEncType(decodedKerberosToken.getEncType()));
                Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
                String decodedPrincipal = decodedKerberosToken.getService() + "/" + decodedKerberosToken.getHost() + "@" + decodedKerberosToken.getRealm();
                model.put("decodedKerberosPrincipal", decodedPrincipal);
                for (KeytabInfo info : keytab.getEntries()) {
                    String keyRealm;
                    if (keytab.nameOf(info).equalsIgnoreCase(decodedPrincipal)) {
                        if (!keytab.nameOf(info).equals(decodedPrincipal)) {
                            model.put("showCaseSensitiveWarning", true);
                            model.put("caseSensitiveWarningKeytab", keytab.nameOf(info));
                        }
                        model.put("keytabHasMatchingName", true);
                        if (info.getEncType() == decodedKerberosToken.getEncType()) {
                            if (info.getKvno() == decodedKerberosToken.getKvno()) {
                                model.put("keytabHasMatchingKey", true);
                            } else if (info.getKvno() > decodedKerberosToken.getKvno()) {
                                model.put("keytabHasNewerKey", true);
                            } else if (info.getKvno() < decodedKerberosToken.getKvno()) {
                                model.put("keytabHasOlderKey", true);
                            }
                        } else if (info.getEncType() == 17) {
                            model.put("keytabHas128", true);
                        } else if (info.getEncType() == 18) {
                            model.put("keytabHas256", true);
                        }
                    }
                    if (info.getEncType() == decodedKerberosToken.getEncType()) {
                        model.put("keytabHasMatchingEnctype", true);
                    }
                    if (StringUtils.equals((CharSequence)(keyRealm = StringUtils.substringAfter((String)keytab.nameOf(info), (String)"@")), (CharSequence)keyRealm.toUpperCase())) continue;
                    model.put("realmContainsLowercase", true);
                }
            }
        }
        catch (Exception e) {
            model.put("decodeTokenException", e);
        }
    }

    private void checkChecksumFailed(SpNego spNego, Map<String, Object> model) {
        if (this.failedWithExceptionMessageContaining(spNego, "Checksum failed")) {
            model.put("checkSumFailed", true);
        }
    }

    private void checkSpNegoResult(SpNego spNego, Map<String, Object> model) {
        model.put("spNegoResult", spNego.getResult().name());
        if (spNego.getException() != null) {
            StringWriter out = new StringWriter();
            spNego.getException().printStackTrace(new PrintWriter(out));
            String t = out.toString();
            model.put("spNegoException", t.substring(0, Math.min(t.length(), 1200)) + "...");
        }
    }

    private static void checkAuthorizationHeader(HttpServletRequest request, Map<String, Object> model) {
        String atz = request.getHeader("Authorization");
        if (atz != null) {
            model.put("authorizationHeader", atz);
        }
    }

    private void checkOutdatedVersion(SpNego spNego, Map<String, Object> model) {
        if (this.failedWithExceptionMessageContaining(spNego, "Specified version of key is not available")) {
            model.put("keyVersionNotAvailable", Boolean.TRUE);
        }
    }

    private void checkChannelBindingMismatch(SpNego spNego, Map<String, Object> model) {
        if (this.failedWithExceptionMessageContaining(spNego, "Channel binding mismatch")) {
            model.put("channelBindingMismatch", Boolean.TRUE);
            model.put("javaVersion", System.getProperty("java.version"));
        }
    }

    private void checkAES256NotPermitted(SpNego spNego, Map<String, Object> model) {
        if (this.failedWithExceptionMessageContaining(spNego, "AES256") && (this.failedWithExceptionMessageContaining(spNego, "encryption type not in permitted_enctypes list") || this.failedWithExceptionMessageContaining(spNego, "is not supported/enabled"))) {
            model.put("aesNotPermitted", Boolean.TRUE);
        }
    }

    private boolean failedWithExceptionMessageContaining(SpNego spNego, String substring) {
        return spNego.getResult() == SpNegoResult.AUTHORIZATION_FAILED && spNego.getException() != null && spNego.getException().getMessage() != null && spNego.getException().getMessage().contains(substring);
    }

    public static void checkDns(Map<String, Object> model, HttpServletRequest request) {
        try {
            String host = new URI(request.getRequestURL().toString()).getHost();
            model.put("host", host);
            try {
                DnsRecord record = DnsUtils.lookup(host);
                model.put("dnsRecord", record);
                model.put("canonicalName", record.isCNAMEalias() ? record.getCNAMEalias() : host);
                model.put("isCNAMEalias", record.isCNAMEalias());
            }
            catch (NamingException e) {
                model.put("dnsFailed", true);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static class DirectoryDescriber {
        public static String describe(Directory directory) {
            if (directory.getType() == DirectoryType.INTERNAL) {
                return "Internal";
            }
            if (directory.getType() == DirectoryType.CONNECTOR) {
                StringBuilder sb = new StringBuilder();
                if (directory.getImplementationClass() != null && directory.getImplementationClass().contains("MicrosoftActiveDirectory")) {
                    sb.append("Microsoft Active Directory ");
                } else {
                    sb.append(directory.getImplementationClass());
                }
                sb.append(" ");
                if ("true".equals(directory.getAttributes().get("ldap.propogate.changes"))) {
                    sb.append("(Read/Write)");
                } else if ("true".equals(directory.getAttributes().get("ldap.local.groups"))) {
                    sb.append("(Read Only, with Local Groups");
                    String autoAddGroups = (String)directory.getAttributes().get("autoAddGroups");
                    if (autoAddGroups != null && autoAddGroups.trim().length() > 0) {
                        sb.append(", default group(s): ").append(autoAddGroups);
                    } else {
                        sb.append(", no default groups ");
                    }
                    sb.append(")");
                } else {
                    sb.append("(Read Only)");
                }
                sb.append(", usernameAttr: ").append((String)directory.getAttributes().get("ldap.user.username"));
                sb.append(", followReferrals: ").append((String)directory.getAttributes().get("ldap.referral"));
                sb.append(", baseDn: ").append((String)directory.getAttributes().get("ldap.basedn"));
                sb.append(", userDn: ").append((String)directory.getAttributes().get("ldap.user.dn"));
                return sb.toString();
            }
            return directory.getType() + " (" + directory.getImplementationClass() + ")";
        }
    }
}

