/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdatePluginSettingsEntryResult;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;

public class ConfigureIpRestrictionsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final KssoUpdateManager kssoUpdateManager;

    @Inject
    public ConfigureIpRestrictionsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kssoUpdateManager = bucket.getKssoUpdateManager();
    }

    public static void populateModel(Map<String, Object> model, IpRestrictionConfig restrictionCfg) {
        model.putIfAbsent("globalIpRestrictionType", restrictionCfg.getGlobalRestrictionType().name());
        model.putIfAbsent("globalIpUnblockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(restrictionCfg.getGlobalIpUnblockedList())));
        model.putIfAbsent("globalIpBlockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(restrictionCfg.getGlobalIpBlockedList())));
        model.putIfAbsent("restIpRestrictionType", restrictionCfg.getRestRestrictionType().name());
        model.putIfAbsent("restIpUnblockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(restrictionCfg.getRestIpUnblockedList())));
        model.putIfAbsent("restIpBlockedlist", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(restrictionCfg.getRestIpBlockedList())));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.doCommonModelSetup(req, model);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip-restrict.vm", model, (Writer)resp.getWriter());
    }

    private boolean hasUpdateFailures() {
        return this.kssoUpdateManager.getUpdateFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.REST_IP_BLOCKEDLIST);
    }

    protected void doCommonModelSetup(HttpServletRequest req, Map<String, Object> model) {
        String enforceIP = this.kerbConfManager.getRemoteIpAddress(req);
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        model.putIfAbsent("isIpValidGlobal", restrictionCfg.getGlobalIpFilter().isRemoteAddressEnabled(enforceIP));
        model.putIfAbsent("isIpValidRest", restrictionCfg.getRestIpFilter().isRemoteAddressEnabled(enforceIP));
        ConfigureIpRestrictionsAction.populateModel(model, restrictionCfg);
        model.putIfAbsent("restAuthEnabled", this.kerbConfManager.isKerberosRestAuthEnabled());
        model.putIfAbsent("isProxied", this.kerbConfManager.getPreferredProxyHeader() != null);
        model.putIfAbsent("enforceIP", enforceIP);
        model.putIfAbsent("userIP", req.getRemoteAddr());
        model.putIfAbsent("xForwardedFor", req.getHeader("X-Forwarded-For"));
        model.putIfAbsent("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        model.putIfAbsent("displayName", this.applicationProperties.getDisplayName());
        model.putIfAbsent("hasUpgradeFailures", this.hasUpdateFailures());
        if (this.hasUpdateFailures()) {
            this.addDataFromUpdateOfConfig(model);
        }
    }

    private void addDataFromUpdateOfConfig(Map<String, Object> model) {
        List<UpdatePluginSettingsEntryResult> upgradeFailures = this.kssoUpdateManager.getUpdateFailures();
        model.put("upgradedGlobalUnblockedListWithErrorMessages", KssoUpdateManager.dataWithErrorMessages(upgradeFailures, KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST));
        model.put("globalUnblockedListUpgradeErrors", KssoUpdateManager.onlyIpRestrictErrorMessagesCommaSeparated(upgradeFailures, KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST));
        model.put("upgradedGlobalBlockedListWithErrorMessages", KssoUpdateManager.dataWithErrorMessages(upgradeFailures, KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST));
        model.put("globalBlockedListUpgradeErrors", KssoUpdateManager.onlyIpRestrictErrorMessagesCommaSeparated(upgradeFailures, KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST));
        model.put("upgradedRestUnblockedListWithErrorMessages", KssoUpdateManager.dataWithErrorMessages(upgradeFailures, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST));
        model.put("restUnblockedListUpgradeErrors", KssoUpdateManager.onlyIpRestrictErrorMessagesCommaSeparated(upgradeFailures, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST));
        model.put("upgradedRestBlockedListWithErrorMessages", KssoUpdateManager.dataWithErrorMessages(upgradeFailures, KerbConfManager.KEYS.REST_IP_BLOCKEDLIST));
        model.put("restBlockedListUpgradeErrors", KssoUpdateManager.onlyIpRestrictErrorMessagesCommaSeparated(upgradeFailures, KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST));
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("iprestrict") != null) {
            Map<String, Object> model = this.newModel(req);
            String globalType = req.getParameter("global_type");
            String globalUnblockedList = req.getParameter("global_unblockedlist");
            String globalBlockedList = req.getParameter("global_blockedlist");
            Option.of((Object)globalType).toTry().mapTry(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).peek(this.kerbConfManager::setGlobalIpRestrictionType);
            Option globalUnblockedPermissions = Option.of((Object)globalUnblockedList).filter(InternetAddressUtils::isValidPermissionList).onEmpty(() -> model.put("globalRegexError", "true")).onEmpty(() -> model.put("globalIpUnblockedlist", globalUnblockedList)).onEmpty(() -> model.put("globalRegexFailedUnblockedList", true)).onEmpty(() -> model.put("invalidDataInGlobalIpUnblockedlist", Option.of((Object)globalUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull())).peek(_list -> {
                if (this.hasUpdateFailures()) {
                    this.kssoUpdateManager.removeUpdateFailureAfterFix(KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setGlobalIpUnblockedList);
            Option globalBlockedPermissions = Option.of((Object)globalBlockedList).filter(InternetAddressUtils::isValidPermissionList).onEmpty(() -> model.put("globalRegexError", "true")).onEmpty(() -> model.put("globalIpBlockedlist", globalBlockedList)).onEmpty(() -> model.put("globalRegexFailedBlockedList", "global blocked list")).onEmpty(() -> model.put("invalidDataInGlobalIpBlockedlist", Option.of((Object)globalBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull())).peek(_list -> {
                if (this.hasUpdateFailures()) {
                    this.kssoUpdateManager.removeUpdateFailureAfterFix(KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setGlobalIpBlockedList);
            String restType = req.getParameter("rest_type");
            String restUnblockedList = req.getParameter("rest_unblockedlist");
            String restBlockedList = req.getParameter("rest_blockedlist");
            Option.of((Object)restType).toTry().mapTry(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).peek(this.kerbConfManager::setRestIpRestrictionType);
            Option restUnblockedPermissions = Option.of((Object)restUnblockedList).filter(InternetAddressUtils::isValidPermissionList).onEmpty(() -> model.put("restRegexError", "true")).onEmpty(() -> model.put("restIpUnblockedlist", restUnblockedList)).onEmpty(() -> model.put("invalidDataInRestIpUnblockedlist", Option.of((Object)restUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull())).onEmpty(() -> model.put("restRegexFailedUnblockedList", true)).peek(_list -> {
                if (this.hasUpdateFailures()) {
                    this.kssoUpdateManager.removeUpdateFailureAfterFix(KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setRestIpUnblockedList);
            Option restBlockedPermissions = Option.of((Object)restBlockedList).filter(InternetAddressUtils::isValidPermissionList).onEmpty(() -> model.put("restRegexError", "true")).onEmpty(() -> model.put("restIpBlockedlist", restBlockedList)).onEmpty(() -> model.put("restRegexFailedBlockedList", true)).onEmpty(() -> model.put("invalidDataInRestIpBlockedlist", Option.of((Object)restBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull())).peek(_list -> {
                if (this.hasUpdateFailures()) {
                    this.kssoUpdateManager.removeUpdateFailureAfterFix(KerbConfManager.KEYS.REST_IP_BLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setRestIpBlockedlist);
            boolean success = List.of((Object[])new Option[]{globalBlockedPermissions, globalUnblockedPermissions, restBlockedPermissions, restUnblockedPermissions}).forAll(Option::isDefined);
            if (success) {
                resp.sendRedirect("iprestrict");
            } else {
                this.doCommonModelSetup(req, model);
                resp.setContentType("text/html");
                this.renderer.render("templates/atlaskerb/ip-restrict.vm", model, (Writer)resp.getWriter());
            }
            return;
        }
        String forwarded = req.getParameter("forwarded");
        if (forwarded != null) {
            this.kerbConfManager.setPreferredProxyHeader("YES".equals(forwarded) ? "x-forwarded-for" : null);
            resp.sendRedirect("iprestrict");
        }
    }
}

