/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.util.Option;
import com.kantegasso.runtimetrust.Fingerprint;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.RequireLoggedInUserServlet;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.kerberos.servlet.ConfigureIpRestrictionsAction;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdateMessage;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequireAdminServlet
extends RequireLoggedInUserServlet {
    private static final Logger log = LoggerFactory.getLogger(RequireAdminServlet.class);
    public final UserManager userManager;
    public final TemplateRenderer templateRenderer;
    public final WebSudoManager webSudoManager;
    final PluginLicenseManager pluginLicenseManager;
    final HostApp hostApp;
    final UserLookupService userLookupService;
    final ApplicationProperties applicationProperties;
    final PluginAccessor pluginAccessor;
    final KerbConfManager kerbConfManager;
    final ScimConfManager scimConfManager;
    final IdpConfManager idpConfManager;
    final ConnectorConfManager connectorConfManager;
    final OidcLibWrapper oidcLibWrapper;
    final KssoUpdateManager kssoUpdateManager;
    private final SecureRandom random = new SecureRandom();

    public RequireAdminServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket.getUserManager(), bucket.getLoginUriProvider());
        this.userManager = bucket.getUserManager();
        this.templateRenderer = bucket.getTemplateRenderer();
        this.webSudoManager = bucket.getWebSudoManager();
        this.pluginLicenseManager = bucket.getPluginLicenseManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.userLookupService = bucket.getUserLookupService();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.scimConfManager = bucket.getScimConfManager();
        this.oidcLibWrapper = bucket.getOidcFactory().createOidcLibWrapper(bucket.getJsonWrapper());
        this.applicationProperties = bucket.getApplicationProperties();
        this.pluginAccessor = bucket.getPluginAccessor();
        this.kssoUpdateManager = bucket.getKssoUpdateManager();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            if (this.kssoUpdateManager.isKssoConfigUpdateNeeded() && !this.kssoUpdateManager.hasUpdateFailures()) {
                List<UpdateMessage> list = this.kssoUpdateManager.doUpdate();
            } else if (this.kerbConfManager.getSavedKssoVersion().isEmpty()) {
                this.kerbConfManager.updateKssoVersionInConfig();
            }
        }
        catch (Exception e) {
            log.error("Encountered an error during upgrade.", (Throwable)e);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        UserKey remoteUserKey = this.userManager.getRemoteUserKey(request);
        if (remoteUserKey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isSystemAdmin(remoteUserKey)) {
            response.setContentType("text/html");
            response.sendError(401, "Page requires system administrator access");
            return;
        }
        this.ensureCsrfTokenInSession(request);
        try {
            if (!this.expectsMultipart() && !this.checkCsrf(request)) {
                this.renderCsrfFailed(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            super.service(request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (CsrfException e) {
            this.renderCsrfFailed(request, response);
        }
    }

    private void renderCsrfFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(400);
        this.templateRenderer.render("templates/atlaskerb/csrf-failed.vm", this.newModel(request), (Writer)response.getWriter());
    }

    private boolean checkCsrf(HttpServletRequest request) {
        boolean tokenIsValid;
        HttpSession httpSession = request.getSession();
        if (this.isSafeHttpMethod(request)) {
            return true;
        }
        this.ensureCsrfTokenInSession(request);
        String token_param = request.getParameter("krb_token");
        String token = (String)httpSession.getAttribute("krb_csrf_token");
        boolean bl = tokenIsValid = token != null && token.equals(token_param);
        if (this.kerbConfManager.isCsrfOriginCheckEnabled()) {
            return tokenIsValid && this.isSameOriginOrReferer(request);
        }
        return tokenIsValid;
    }

    private boolean isSameOriginOrReferer(HttpServletRequest request) {
        Try expectedOrigin = Try.of((CheckedFunction0 & Serializable)() -> new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getAuthority());
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> (String)List.of((Object[])new String[]{"Origin", "Referer"}).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).peek()).mapTry((CheckedFunction1 & Serializable)requestOrigin -> new URI((String)requestOrigin).getAuthority().equals(expectedOrigin.get())).onFailure(throwable -> log.warn("[KSSO CSRF] NOT OK | " + String.format("Origin: %s | Referer: %s | Expected: %s | Application Base URL: %s", request.getHeader("Origin"), request.getHeader("Referer"), expectedOrigin.getOrElse((Object)"Not able to parse."), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)))).getOrElse((Object)true);
    }

    private boolean isSafeHttpMethod(HttpServletRequest request) {
        return List.of((Object[])new String[]{"GET", "HEAD", "OPTIONS", "TRACE"}).contains((Object)request.getMethod());
    }

    private void ensureCsrfTokenInSession(HttpServletRequest request) {
        if (request.getSession().getAttribute("krb_csrf_token") == null) {
            byte[] passwordBytes = new byte[32];
            this.random.nextBytes(passwordBytes);
            String token = Fingerprint.sha1Fingerprint((byte[])passwordBytes);
            request.getSession().setAttribute("krb_csrf_token", (Object)token);
        }
    }

    @Override
    protected Map<String, Object> newModel(HttpServletRequest req) {
        boolean isSamlEnabled;
        Map<String, Object> model = super.newModel(req);
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("pluginAdminPath", contextPath + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin");
        model.put("pluginKey", PluginKey.getPluginKey());
        model.put("pluginResource", PluginKey.getPluginKey() + ":entrypoint-atlaskerb");
        String basePath = (String)Try.of((CheckedFunction0 & Serializable)() -> new URL(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getPath()).getOrElse((Object)"");
        model.put("basePath", basePath);
        Option maybeLicense = this.pluginLicenseManager.getLicense();
        if (maybeLicense.isDefined()) {
            model.put("pluginLicense", maybeLicense.get());
        }
        String installedPluginVersion = (String)io.vavr.control.Option.of((Object)this.pluginAccessor).map(pluginAccessor -> pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey())).map(Plugin::getPluginInformation).map(PluginInformation::getVersion).getOrElse((Object)"UNKNOWN");
        model.put("installedPluginVersion", installedPluginVersion);
        String requestURI = req.getRequestURI();
        if (requestURI.contains("/saml/")) {
            model.put("topMenu", "SAML");
            model.put("samlEnabled", this.idpConfManager.isFederatedSsoEnabled());
            model.put("connectorTool", new ConnectorTool(this.connectorConfManager));
        } else {
            model.put("topMenu", "Kerberos");
            model.put("supportsRemoveAllRememberMeTokens", this.hostApp.supportsRemoveAllRememberMeTokens());
            model.put("hasRestApi", this.hostApp.hasRestApi());
            model.put("hasWritableCrowd", this.userLookupService.hasWritableCrowdDirectory());
            model.put("kerberosEnabled", this.kerbConfManager.isKerberosEnabled());
            model.put("preemptivePaths", this.hostApp.getRequireLoginPathMappings());
            IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
            ConfigureIpRestrictionsAction.populateModel(model, restrictionCfg);
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("displaySingleLogout", !this.hostApp.isProductMatch("fecru"));
        model.put("applicationProperties", this.kerbConfManager.getApplicationProperties());
        model.put("isKerberosConfigured", this.kerbConfManager.isKeytabConfigured());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("isIdpConfigured", !this.idpConfManager.getIdentityProviders().isEmpty());
        model.put("hasIdpDrafts", !this.idpConfManager.getDrafts().isEmpty());
        model.put("hasKssoUpgradeErrors", this.kssoUpdateManager.hasUpdateFailures());
        model.put("hasApiTokenUpgradeErrors", this.kssoUpdateManager.getUpdateFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST));
        model.put("hasIpRestrictUpgradeErrors", this.kssoUpdateManager.getUpdateFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.REST_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST));
        model.put("hasHeaderAuthUpgradeErrors", this.kssoUpdateManager.getUpdateFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST));
        model.put("kssoConfigUpdateNeeded", this.kssoUpdateManager.isKssoConfigUpdateNeeded());
        model.put("isCloudConnectorsConfigured", !this.connectorConfManager.getDirectories().isEmpty() || !this.scimConfManager.getTenantConfigs().isEmpty());
        model.put("crowdDirectoryFinder", new CrowdDirectoryFinder(this.hostApp));
        model.put("isScimEnabled", this.scimConfManager.isScimEnabled());
        String page = requestURI.substring(requestURI.lastIndexOf("/") + 1);
        if (!page.isEmpty()) {
            model.put("menuItem", page);
        }
        model.put("backUrl", this.validateURLInput(req.getParameter("backUrl")));
        model.put("backLinkDescription", req.getParameter("backLinkDescription"));
        model.put("isJsdInstalled", this.kerbConfManager.isJsmInstalled());
        boolean bl = isSamlEnabled = this.idpConfManager.hasEnabledSamlProviders() && this.idpConfManager.isFederatedSsoEnabled();
        if (isSamlEnabled) {
            try {
                X509Certificate activeCert = this.idpConfManager.parseCert(this.idpConfManager.getSigningCert());
                model.put("isValidCertificate", CertTool.isValidCertificate(activeCert, 0));
                model.put("isExpiringSoonCertificate", CertTool.isExpiringSoon(activeCert));
            }
            catch (Exception e) {
                log.debug("Failed to obtain certificates for checking expiry: ", (Throwable)e);
            }
        }
        model.put("isSamlEnabled", isSamlEnabled);
        model.put("warnSamlKeyExpires", this.idpConfManager.isWarnSamlKeyExpires());
        return model;
    }

    private String validateURLInput(String backUrl) {
        if (backUrl != null) {
            try {
                URI uri = new URI(backUrl);
                return uri.getQuery() != null ? uri.getPath() + "?" + uri.getQuery() : uri.getPath();
            }
            catch (URISyntaxException e) {
                log.error("Not valid backlink url", (Throwable)e);
            }
        }
        return null;
    }

    protected TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    protected boolean expectsMultipart() {
        return false;
    }

    protected MultipartHttpRequest getMultipartRequest(HttpServletRequest request, long maxSize) throws IOException {
        if (!this.expectsMultipart()) {
            throw new IllegalArgumentException("Servlet has not declared that it expects multipart/form-data");
        }
        MultipartHttpRequest multipartRequest = this.hostApp.getMultipartRequest(request, maxSize);
        if (!this.checkCsrf((HttpServletRequest)multipartRequest)) {
            throw new CsrfException();
        }
        return multipartRequest;
    }

    protected io.vavr.control.Option<String> getSafeParameter(String parameter, HttpServletRequest request) {
        return io.vavr.control.Option.of((Object)request.getParameter(parameter)).map(StringUtils::trim).filter(StringUtils::isNotBlank);
    }

    public static class ConnectorTool {
        private final ConnectorConfManager connectorConfManager;

        ConnectorTool(ConnectorConfManager connectorConfManager) {
            this.connectorConfManager = connectorConfManager;
        }

        public boolean hasConnectorForKind(IdpConfiguration.Kind kind) {
            for (ConnectorType connectorType : this.connectorConfManager.getConnectorTypes().values()) {
                if (connectorType.getIdentityProviderKind() != kind) continue;
                return true;
            }
            return false;
        }
    }

    private static class CsrfException
    extends SecurityException {
        private CsrfException() {
        }
    }
}

