/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityHeadersFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SecurityHeadersFilter.class);
    private final KerbConfManager kerbConfManager;

    @Inject
    public SecurityHeadersFilter(RequireAdminServletDependencyBucket bucket) {
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (response != null) {
            String origin;
            String referer = request.getHeader("referer");
            if (StringUtils.endsWith((CharSequence)referer, (CharSequence)"/")) {
                referer = StringUtils.substringBeforeLast((String)referer, (String)"/");
            }
            if (StringUtils.endsWith((CharSequence)(origin = request.getHeader("origin")), (CharSequence)"/")) {
                origin = StringUtils.substringBeforeLast((String)origin, (String)"/");
            }
            for (String hostName : this.kerbConfManager.getSecurityHeaderAllowedHostNames()) {
                boolean licenseValid;
                if (StringUtils.endsWith((CharSequence)hostName, (CharSequence)"/")) {
                    hostName = StringUtils.substringBeforeLast((String)hostName, (String)"/");
                }
                if (!StringUtils.equals((CharSequence)referer, (CharSequence)hostName) && !StringUtils.equals((CharSequence)origin, (CharSequence)hostName)) continue;
                boolean bl = licenseValid = this.kerbConfManager.getLicenseManager().getLicense().isDefined() && ((PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get()).isValid();
                if (!licenseValid) break;
                response.setHeader("Access-Control-Allow-Origin", hostName);
                response.setHeader("Access-Control-Allow-Credentials", "true");
                break;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

