/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class ConfigureForceLoginServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;

    @Inject
    public ConfigureForceLoginServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "force-login");
        model.put("require_login", this.kerbConfManager.isRequireLogin());
        model.put("login_mode", this.kerbConfManager.isForceLogin() ? "force_login" : "attempt_login");
        model.put("requireLoginPathMappings", this.hostApp.getRequireLoginPathMappings());
        model.put("forcedSsoUrls", this.kerbConfManager.getForcedSsoUrls());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("excludedPaths", this.kerbConfManager.getRequireLoginExcludedPaths());
        model.put("displayName", this.applicationProperties.getDisplayName());
        if (this.idpConfManager.hasEnabledIdentityProviders() && !this.kerbConfManager.isForceLogin()) {
            Optional<IdpConfiguration> optional = this.idpConfManager.getIdentityProviders().stream().filter(IdpConfiguration::isEnabled).filter(idpConfig -> idpConfig.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.HARD).findFirst();
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/force-login.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        if (req.getParameter("require_login_saved") != null) {
            this.kerbConfManager.setRequireLogin("on".equals(req.getParameter("require_login")));
            this.kerbConfManager.setForceLogin(!"attempt_login".equals(req.getParameter("login_mode")));
            ConfigureForceLoginServlet.sendSuccess(resp);
        } else {
            String baseUrl;
            String addUrl;
            String removeUrl = req.getParameter("removeUrl");
            if (StringUtils.isNotBlank((String)removeUrl)) {
                this.kerbConfManager.removeForcedSsoUrls(removeUrl);
            }
            if (StringUtils.isNotBlank((String)(removeUrl = req.getParameter("removeExcludedUrl")))) {
                this.kerbConfManager.removePreemptiveAuthExcludedPaths(removeUrl);
            }
            if (StringUtils.isNotBlank((String)(addUrl = req.getParameter("addUrl")))) {
                addUrl = addUrl.trim();
                baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
                addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
                addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
                if (!StringUtils.startsWith((String)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (String)"/")) {
                    addUrl = "/" + addUrl;
                }
                this.kerbConfManager.addForcedSsoUrls(addUrl);
            }
            if (StringUtils.isNotBlank((String)(addUrl = req.getParameter("excludedUrl")))) {
                addUrl = addUrl.trim();
                baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
                addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
                addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
                if (!StringUtils.startsWith((String)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (String)"/")) {
                    addUrl = "/" + addUrl;
                }
                this.kerbConfManager.addPreemptiveAuthExcludedPaths(addUrl);
            }
            resp.sendRedirect("force-login");
        }
    }

    private static void sendSuccess(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().print("<html>Settings was saved</html>");
    }
}

