/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;

public class CrowdPermissionsAction
extends RequireAdminServlet {
    private final TransactionTemplate transactionTemplate;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public CrowdPermissionsAction(RequireAdminServletDependencyBucket bucket, @ComponentImport TransactionTemplate transactionTemplate) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.transactionTemplate = transactionTemplate;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        model.put("platformSupportsAvatars", this.hostApp.supportsAvatars(this.applicationProperties));
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "localGroups");
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        com.atlassian.crowd.embedded.api.Directory cwd = new CrowdDirectoryFinder(this.hostApp).findDirectory(id);
        model.put("crowdDirectory", cwd);
        if (cwd != null) {
            Set allowed = cwd.getAllowedOperations();
            model.put("canWriteGroups", allowed.contains(OperationType.CREATE_GROUP) && allowed.contains(OperationType.UPDATE_GROUP) && allowed.contains(OperationType.DELETE_GROUP));
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/crowd-permissions.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("id");
        final String permissionMode = req.getParameter("permission_mode");
        Directory directory = this.connectorConfManager.getDirectory(id);
        if (directory != null) {
            final com.atlassian.crowd.embedded.api.Directory cwd = new CrowdDirectoryFinder(this.hostApp).findDirectory(directory.getId());
            if (permissionMode != null) {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<com.atlassian.crowd.embedded.api.Directory>(){

                    public com.atlassian.crowd.embedded.api.Directory doInTransaction() {
                        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((com.atlassian.crowd.embedded.api.Directory)cwd);
                        HashMap<String, String> attrs = new HashMap<String, String>(cwd.getAttributes());
                        if ("READ_ONLY_LOCAL_GROUPS".equals(permissionMode)) {
                            builder.setAllowedOperations(EnumSet.of(OperationType.UPDATE_GROUP, OperationType.CREATE_GROUP, OperationType.DELETE_GROUP, OperationType.UPDATE_GROUP_ATTRIBUTE, OperationType.UPDATE_USER_ATTRIBUTE));
                            attrs.put("ldap.local.groups", "true");
                        } else {
                            builder.setAllowedOperations(new HashSet<OperationType>(Arrays.asList(OperationType.UPDATE_GROUP_ATTRIBUTE, OperationType.UPDATE_USER_ATTRIBUTE)));
                            attrs.remove("ldap.local.groups");
                        }
                        builder.setAttributes(attrs);
                        return CrowdPermissionsAction.this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
                    }
                });
            }
            resp.sendRedirect("crowd-permissions?id=" + id);
        } else {
            resp.sendError(404);
        }
    }
}

