/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.kantega.atlaskerb.kerberos.keytab.EncryptionType;
import org.simplericity.serberuhs.keytab.KeytabInfo;

public class Keytab {
    private final List<KeytabInfo> entries;

    public Keytab(List<KeytabInfo> entries) {
        this.entries = entries;
    }

    public List<KeytabInfo> getEntries() {
        return this.entries;
    }

    public EncryptionType getEncryptionType(KeytabInfo info) {
        return EncryptionType.byEncType(info.getEncType());
    }

    public boolean hasEntryForHost(String host) {
        if (host == null) {
            return false;
        }
        for (KeytabInfo entry : this.entries) {
            if (!"HTTP".equalsIgnoreCase(entry.getServicePart()) || entry.getHostPart() == null || !entry.getHostPart().equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAES256() {
        for (KeytabInfo entry : this.entries) {
            if (entry.getEncType() != 18) continue;
            return true;
        }
        return false;
    }

    public boolean supportsEncryptionTypeForSPN(String spn, int encType) {
        for (KeytabInfo entry : this.entries) {
            String entrySpn = this.nameWithoutRealm(entry);
            if (!entrySpn.equals(spn) || encType != entry.getEncType()) continue;
            return true;
        }
        return false;
    }

    public boolean supportsKvnoForSPN(String spn, int kvno) {
        for (KeytabInfo entry : this.entries) {
            String entrySpn = this.nameWithoutRealm(entry);
            if (!entrySpn.equals(spn) || kvno != entry.getKvno()) continue;
            return true;
        }
        return false;
    }

    public Set<Integer> kvnosForSPN(String spn) {
        TreeSet<Integer> kvnos = new TreeSet<Integer>();
        for (KeytabInfo entry : this.entries) {
            String entrySpn = this.nameWithoutRealm(entry);
            if (!entrySpn.equals(spn)) continue;
            kvnos.add(entry.getKvno());
        }
        return kvnos;
    }

    public String entryKey(KeytabInfo info) {
        return this.nameWithoutRealm(info) + "@" + info.getRealm() + ":" + info.getEncType() + ":" + info.getKvno();
    }

    public String nameOf(KeytabInfo info) {
        return this.nameWithoutRealm(info) + "@" + info.getRealm();
    }

    public String nameWithoutRealm(KeytabInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append(info.getServicePart());
        if (info.getHostPart() != null) {
            sb.append("/").append(info.getHostPart());
        }
        return sb.toString();
    }

    public Set<String> realms() {
        LinkedHashSet<String> realms = new LinkedHashSet<String>();
        for (KeytabInfo entry : this.entries) {
            realms.add(entry.getRealm());
        }
        return realms;
    }
}

