/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.StorageRecord;

public class AtlassianCacheStorageService
extends AbstractStorageService {
    private final Cache<String, Long> cache;

    public AtlassianCacheStorageService(CacheManager cacheManager) {
        this.setContextSize(Integer.MAX_VALUE);
        this.setKeySize(Integer.MAX_VALUE);
        this.setValueSize(Integer.MAX_VALUE);
        String name = AtlassianCacheStorageService.class.getName() + ".samlReplayCache";
        this.cache = cacheManager.getCache(name, null, new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterWrite(1L, TimeUnit.HOURS).maxEntries(Integer.parseInt(System.getProperty(name, "25000"))).build());
    }

    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) {
        String k = this.getKey(context, key);
        Long stored = (Long)this.cache.get((Object)k);
        if (stored != null) {
            if (System.currentTimeMillis() < stored) {
                return false;
            }
            this.cache.remove((Object)k);
        }
        this.cache.put((Object)k, (Object)expiration);
        return true;
    }

    private String getKey(String context, String key) {
        return context + ":" + key;
    }

    @Nullable
    public StorageRecord read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) {
        Long expiration = (Long)this.cache.get((Object)this.getKey(context, key));
        if (expiration == null) {
            return null;
        }
        return new StorageRecord("x", expiration);
    }

    @Nonnull
    public Pair<Long, StorageRecord> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive long version) {
        throw new IllegalArgumentException("Not implemented");
    }

    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) {
        throw new IllegalArgumentException("Not implemented");
    }

    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) {
        throw new IllegalArgumentException("Not implemented");
    }

    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) {
        throw new IllegalArgumentException("Not implemented");
    }

    public boolean deleteWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) {
        throw new IllegalArgumentException("Not implemented");
    }

    public void reap(@Nonnull @NotEmpty String context) {
        throw new IllegalArgumentException("Not implemented");
    }

    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable Long expiration) {
        throw new IllegalArgumentException("Not implemented");
    }

    public void deleteContext(@Nonnull @NotEmpty String context) {
        throw new IllegalArgumentException("Not implemented");
    }
}

