/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.DnsRecord;
import org.kantega.atlaskerb.DnsUtils;
import org.kantega.atlaskerb.DomainDirectory;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.LdapPrincipalSearcher;
import org.kantega.atlaskerb.LdapTestResult;
import org.kantega.atlaskerb.LdapTestTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.kerberos.AtlDirectoryManager;
import org.kantega.atlaskerb.kerberos.keytab.EncryptionType;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupAction
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final LdapPrincipalSearcher ldapPrincipalSearcher;
    private final AtlDirectoryManager directoryManager;
    private final UserLookupService userLookupService;
    private final KerbConfManager kerbConfManager;
    private final List<Step> steps = new ArrayList<Step>();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public SetupAction(RequireAdminServletDependencyBucket bucket, LdapPrincipalSearcher ldapPrincipalSearcher, AtlDirectoryManager directoryManager) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.userLookupService = bucket.getUserLookupService();
        this.ldapPrincipalSearcher = ldapPrincipalSearcher;
        this.directoryManager = directoryManager;
        this.steps.add(new StartStep());
        this.steps.add(new AdConnectStep());
        this.steps.add(new ServiceNameStep());
        this.steps.add(new RealmStep());
        this.steps.add(new AccountStep());
        this.steps.add(new EncryptionStep());
        this.steps.add(new SummaryStep());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        Map<String, Object> guess = this.newModel(req);
        model.put("canGuess", this.canGuess(req, guess));
        model.put("guess", guess);
        Step firstStep = this.steps.get(0);
        this.showStep(req, resp, model, firstStep);
    }

    private void showStep(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model, Step step) throws IOException {
        model.put("step", step.getName());
        step.show(req, model);
        model.put("serviceNameFilename", StringUtils.replace((String)((String)model.get("serviceName")), (String)":", (String)"_"));
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.templateRenderer.render("templates/atlaskerb/setup.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model;
        boolean canGuess;
        super.doPost(req, resp);
        boolean bl = canGuess = req.getParameter("guess") != null;
        if (canGuess) {
            model = this.newModel(req);
            if (!this.canGuess(req, model)) {
                canGuess = false;
            }
            if (canGuess) {
                Step lastStep = this.steps.get(this.steps.size() - 1);
                this.showStep(req, resp, model, lastStep);
                return;
            }
        }
        model = this.newModel(req);
        this.copyParams(req, model);
        Step step = this.getStep(req.getParameter("step"));
        if (step != null) {
            if (req.getParameter("showStep") != null) {
                this.showStep(req, resp, model, step);
                return;
            }
            Step nextStep = null;
            nextStep = req.getParameter("back") != null ? this.getPreviousStep(step) : (step.process(req, model) ? this.getNextStep(step) : step);
            if (nextStep == null) {
                nextStep = step;
            }
            this.showStep(req, resp, model, nextStep);
            return;
        }
        resp.sendRedirect("setup");
    }

    private boolean canGuess(HttpServletRequest req, Map<String, Object> model) {
        for (Step step : this.steps) {
            if (step.guess(req, model)) continue;
            return false;
        }
        return true;
    }

    private Step getPreviousStep(Step step) {
        for (int i = this.steps.size() - 1; i >= 1; --i) {
            Step next = this.steps.get(i);
            if (next != step) continue;
            return this.steps.get(i - 1);
        }
        return null;
    }

    private Step getNextStep(Step step) {
        Iterator<Step> iterator = this.steps.iterator();
        while (iterator.hasNext()) {
            Step next = iterator.next();
            if (next != step || !iterator.hasNext()) continue;
            return iterator.next();
        }
        return null;
    }

    private Step getStep(String name) {
        for (Step step : this.steps) {
            if (!step.getName().equals(name)) continue;
            return step;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void guessRealmUsingDns(Map<String, Object> model, String serverName) {
        String domain = serverName;
        while (domain.contains(".") && domain.indexOf(".", domain.indexOf(".") + 1) != -1) {
            domain = domain.substring(domain.indexOf(".") + 1);
        }
        model.put("realmDomain", domain);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext context = null;
        String providerUrl = null;
        String kerberosRecord = null;
        context = new InitialDirContext(env);
        providerUrl = context.getEnvironment().get("java.naming.provider.url").toString();
        kerberosRecord = "_kerberos." + domain;
        Attributes enumeration = context.getAttributes(kerberosRecord, new String[]{"TXT"});
        if (enumeration.size() > 0) {
            String value = enumeration.get("TXT").get().toString();
            String realm = value.toUpperCase();
            model.put("suggestedRealm", realm);
            model.put("realmGuessedFromRecord", kerberosRecord);
            model.put("realmGuessedFromRecordValue", value);
            model.put("realmGuessedFromDnsProvider", providerUrl);
        }
        if (context == null) return;
        try {
            context.close();
            return;
        }
        catch (NamingException e) {
            this.log.error("Failed to lookup realm guessed from record '" + (String)Option.of((Object)kerberosRecord).getOrElse((Object)"") + "' using providerUrl '" + (String)Option.of((Object)providerUrl).getOrElse((Object)"") + "' with context " + context);
            model.put("ldapServerNotFound", true);
        }
        return;
        catch (NameNotFoundException e) {
            model.put("ldapServerNotFound", true);
            if (context == null) return;
            try {
                context.close();
                return;
            }
            catch (NamingException e2) {
                this.log.error("Failed to lookup realm guessed from record '" + (String)Option.of((Object)kerberosRecord).getOrElse((Object)"") + "' using providerUrl '" + (String)Option.of((Object)providerUrl).getOrElse((Object)"") + "' with context " + context);
                model.put("ldapServerNotFound", true);
            }
            return;
        }
        catch (NamingException e2) {
            this.log.error("Failed to lookup realm guessed from record '" + (String)Option.of(kerberosRecord).getOrElse((Object)"") + "' using providerUrl '" + (String)Option.of((Object)providerUrl).getOrElse((Object)"") + "'");
            model.put("ldapServerNotFound", true);
            if (context == null) return;
            {
                catch (Throwable throwable) {
                    if (context == null) throw throwable;
                    try {
                        context.close();
                        throw throwable;
                    }
                    catch (NamingException e3) {
                        this.log.error("Failed to lookup realm guessed from record '" + (String)Option.of(kerberosRecord).getOrElse((Object)"") + "' using providerUrl '" + (String)Option.of((Object)providerUrl).getOrElse((Object)"") + "' with context " + context);
                        model.put("ldapServerNotFound", true);
                    }
                    throw throwable;
                }
            }
            try {
                context.close();
                return;
            }
            catch (NamingException e4) {
                this.log.error("Failed to lookup realm guessed from record '" + (String)Option.of((Object)kerberosRecord).getOrElse((Object)"") + "' using providerUrl '" + (String)Option.of((Object)providerUrl).getOrElse((Object)"") + "' with context " + context);
                model.put("ldapServerNotFound", true);
            }
            return;
        }
    }

    private boolean isManual(Map<String, Object> model) {
        return "manual".equals(model.get("directory"));
    }

    private void accountParams(Map<String, Object> model) {
        model.put("displayName", this.applicationProperties.getDisplayName());
        try {
            this.lookupSpn(model);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ldapConnect(Map<String, Object> model) throws NamingException {
        InitialContext context = null;
        try {
            Hashtable<String, String> env = this.getEnvForDirectoryOrConnectionDetails(model);
            context = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = ((InitialDirContext)context).search("", "(objectClass=*)", sc).next().getAttributes();
            boolean bl = rootAttrs.get("forestfunctionality") != null && rootAttrs.get("defaultNamingContext") != null;
            return bl;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void validateAccountInfo(HttpServletRequest req, Map<String, Object> model) {
        LdapTestResult accountInfo = (LdapTestResult)model.get("accountInfo");
        if (accountInfo != null) {
            model.put("accountValid", true);
            if ("AES128-SHA1".equalsIgnoreCase((String)model.get("enctype"))) {
                if (!accountInfo.isEncryptionTypeSupported("AES128-SHA1")) {
                    model.put("needAES128", true);
                    model.put("accountValid", false);
                }
                if (accountInfo.isEncryptionTypeSupported("AES256-SHA1")) {
                    model.put("disableAES256", true);
                    model.put("accountValid", false);
                }
            }
            if ("AES256-SHA1".equalsIgnoreCase((String)model.get("enctype")) && !accountInfo.isEncryptionTypeSupported("AES256-SHA1")) {
                model.put("needAES256", true);
                model.put("accountValid", false);
            }
            if ("RC4-HMAC-NT".equalsIgnoreCase((String)model.get("enctype"))) {
                if (accountInfo.isEncryptionTypeSupported("AES256-SHA1")) {
                    model.put("disableAES256", true);
                    model.put("accountValid", false);
                }
                if (accountInfo.isEncryptionTypeSupported("AES128-SHA1")) {
                    model.put("disableAES128", true);
                    model.put("accountValid", false);
                }
            }
            if (accountInfo.getUnreadableAttributes().contains("userAccountControl")) {
                model.put("misisingUserAccountControl", true);
            } else if (accountInfo.isAccountDesOnly() || accountInfo.isAccountDisabled() || accountInfo.isAccountPasswordHasExpired() || !accountInfo.isAccountPasswordNeverExpires()) {
                model.put("accountValid", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LdapTestResult> lookupAccount(Map<String, Object> model) throws NamingException {
        Context context = null;
        try {
            Hashtable<String, String> env = this.getEnvForDirectoryOrConnectionDetails(model);
            context = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = context.search("", "(objectClass=*)", sc).next().getAttributes();
            String defaultNamingContext = (String)rootAttrs.get("defaultNamingContext").get();
            model.put("AESUnsupported", !new LdapTestTool().functionalLevelSupportsAES((String)rootAttrs.get("domainFunctionality").get(0)));
            String lookupAccount = model.get("account").toString().trim();
            List<LdapTestResult> accountResult = this.ldapPrincipalSearcher.findAccountsForAccountName((DirContext)context, defaultNamingContext, lookupAccount, this.kerbConfManager.isLdapFilterEncoding());
            if (!accountResult.isEmpty()) {
                model.put("accountInfo", accountResult.get(0));
            }
            List<LdapTestResult> list = accountResult;
            return list;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LdapTestResult> lookupSpn(Map<String, Object> model) throws NamingException {
        String lookupSpn = "HTTP/" + model.get("serviceName");
        Context context = null;
        try {
            Hashtable<String, String> env = this.getEnvForDirectoryOrConnectionDetails(model);
            context = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = context.search("", "(objectClass=*)", sc).next().getAttributes();
            String defaultNamingContext = (String)rootAttrs.get("defaultNamingContext").get();
            List<LdapTestResult> result = this.ldapPrincipalSearcher.findAccountsForSpn((DirContext)context, defaultNamingContext, lookupSpn, true);
            model.put("spnMatches", result);
            List<LdapTestResult> list = result;
            return list;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void copyParams(HttpServletRequest req, Map<String, Object> model) {
        model.put("serviceName", this.lowercase(req, "serviceName"));
        model.put("directory", req.getParameter("directory"));
        model.put("ldap_baseurl", req.getParameter("ldap_baseurl"));
        model.put("ldap_username", req.getParameter("ldap_username"));
        model.put("ldap_password", req.getParameter("ldap_password"));
        model.put("realm", this.uppercase(req, "realm"));
        model.put("account", req.getParameter("account"));
        model.put("enctype", req.getParameter("enctype"));
    }

    private String lowercase(HttpServletRequest req, String paramName) {
        String value = req.getParameter(paramName);
        return value == null ? null : value.toLowerCase();
    }

    private String uppercase(HttpServletRequest req, String paramName) {
        String value = req.getParameter(paramName);
        return value == null ? null : value.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupRealm(Map<String, Object> model) throws NamingException {
        Context context = null;
        try {
            Hashtable<String, String> env = this.getEnvForDirectoryOrConnectionDetails(model);
            context = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = context.search("", "(objectClass=*)", sc).next().getAttributes();
            Attribute dncAttr = rootAttrs.get("defaultNamingContext");
            if (dncAttr == null) {
                String string = null;
                return string;
            }
            String defaultNamingContext = (String)dncAttr.get();
            String realm = defaultNamingContext.toLowerCase().replace("dc=", "").replace(',', '.').toUpperCase();
            model.put("suggestedRealm", realm);
            model.put("defaultNamingContext", defaultNamingContext);
            String string = realm;
            return string;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Hashtable<String, String> getEnvForDirectoryOrConnectionDetails(Map<String, Object> model) {
        String dirId = (String)model.get("directory");
        if (dirId != null && !"custom".equals(dirId)) {
            for (Directory directory : this.directoryManager.getActiveLdapDirectories()) {
                if (!directory.getId().toString().equals(dirId)) continue;
                return this.directoryManager.getEnvForDirectory(directory);
            }
        }
        String baseUrl = (String)model.get("ldap_baseurl");
        return this.directoryManager.getLdapEnv(SetupAction.addLdapProtocol(baseUrl), (String)model.get("ldap_username"), (String)model.get("ldap_password"));
    }

    public static String addLdapProtocol(String baseUrl) {
        if (baseUrl != null && !baseUrl.startsWith("ldap://") && !baseUrl.startsWith("ldaps://")) {
            baseUrl = baseUrl.endsWith(":636") ? "ldaps://" + baseUrl : "ldap://" + baseUrl;
        }
        return baseUrl;
    }

    private boolean isBlank(String ldap_baseurl) {
        return ldap_baseurl == null || ldap_baseurl.trim().isEmpty();
    }

    class SummaryStep
    extends Step {
        public SummaryStep() {
            super("summary");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            return true;
        }

        @Override
        boolean process(HttpServletRequest req, Map<String, Object> model) {
            return true;
        }

        @Override
        public void show(HttpServletRequest req, Map<String, Object> model) {
            model.put("displayName", SetupAction.this.applicationProperties.getDisplayName());
            model.put("host", req.getServerName());
            model.put("manageKeytab", SetupAction.this.kerbConfManager.isKeytabConfigured());
            TestKerberosAction.checkMaxKeyLength(model);
            if (!SetupAction.this.isManual(model)) {
                Hashtable env = SetupAction.this.getEnvForDirectoryOrConnectionDetails(model);
                try {
                    URI providerUrl = new URI(env.get("java.naming.provider.url").toString());
                    model.put("suggestedADServer", providerUrl.getHost());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                try {
                    SetupAction.this.lookupAccount(model);
                    SetupAction.this.validateAccountInfo(req, model);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }

    class EncryptionStep
    extends Step {
        public EncryptionStep() {
            super("encryption");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            HashMap<String, Object> tempModel = new HashMap<String, Object>();
            tempModel.putAll(model);
            this.show(req, tempModel);
            EncryptionType encType = (EncryptionType)tempModel.get("recommendedEncType");
            model.put("enctype", encType.getKtpassName());
            return true;
        }

        @Override
        boolean process(HttpServletRequest req, Map<String, Object> model) {
            return true;
        }

        @Override
        public void show(HttpServletRequest reqs, Map<String, Object> model) {
            TestKerberosAction.checkMaxKeyLength(model);
            model.put("availableEncTypes", Arrays.asList(EncryptionType.byEncType(18), EncryptionType.byEncType(17), EncryptionType.byEncType(23)));
            EncryptionType accountEncryptionType = null;
            Boolean aesUnSupported = null;
            boolean limitedKeyLength = Boolean.TRUE.equals(model.get("limitedKeyLength"));
            if (!SetupAction.this.isManual(model)) {
                try {
                    List ldapTestResults = SetupAction.this.lookupAccount(model);
                    if (ldapTestResults.size() == 1) {
                        LdapTestResult result = (LdapTestResult)ldapTestResults.get(0);
                        model.put("accountInfo", result);
                        accountEncryptionType = result.getStrongestEncryptionType();
                    }
                    if (Boolean.TRUE.equals(model.get("AESUnsupported"))) {
                        aesUnSupported = true;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            model.put("recommendedEncType", this.recommendEncryptionType(accountEncryptionType, aesUnSupported, limitedKeyLength));
        }

        private EncryptionType recommendEncryptionType(EncryptionType accountEncryptionType, Boolean aesUnSupported, boolean limitedKeyLength) {
            EncryptionType rc4 = EncryptionType.byEncType(23);
            EncryptionType aes128 = EncryptionType.byEncType(17);
            EncryptionType aes256 = EncryptionType.byEncType(18);
            if (Boolean.TRUE.equals(aesUnSupported)) {
                return rc4;
            }
            if (accountEncryptionType == null) {
                return limitedKeyLength ? aes128 : aes256;
            }
            if (accountEncryptionType.getEnctype() == aes256.getEnctype() && limitedKeyLength) {
                return aes128;
            }
            return accountEncryptionType;
        }
    }

    class AccountStep
    extends Step {
        public AccountStep() {
            super("account");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            block4: {
                try {
                    List spnMatches = SetupAction.this.lookupSpn(model);
                    if (spnMatches.size() == 1) {
                        model.put("account", ((LdapTestResult)spnMatches.get(0)).getServicePrincipalUsername());
                        break block4;
                    }
                    if (spnMatches.size() == 0) {
                        model.put("account", this.defaultUsername((String)model.get("serviceName")));
                        break block4;
                    }
                    return false;
                }
                catch (NamingException e) {
                    return false;
                }
            }
            return true;
        }

        @Override
        boolean process(HttpServletRequest req, Map<String, Object> model) {
            if (SetupAction.this.isBlank(req.getParameter("account"))) {
                model.put("required", true);
                return false;
            }
            if (!SetupAction.this.isManual(model)) {
                if (req.getParameter("change_account") != null) {
                    return false;
                }
                if (req.getParameter("reload_account") != null) {
                    return false;
                }
                try {
                    List ldapTestResults = SetupAction.this.lookupAccount(model);
                    if (ldapTestResults.size() == 1) {
                        LdapTestResult result = (LdapTestResult)ldapTestResults.get(0);
                        String expectedSpn = "HTTP/" + req.getParameter("serviceName");
                        if (result.getServicePrincipalAliases().stream().noneMatch(spn -> spn.equalsIgnoreCase(expectedSpn)) && req.getParameter("use_existing_account") == null) {
                            model.put("existingAccount", result);
                            return false;
                        }
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return true;
        }

        @Override
        public void show(HttpServletRequest req, Map<String, Object> model) {
            model.put("suggestedAccount", this.defaultUsername((String)model.get("serviceName")));
            model.put("displayName", SetupAction.this.applicationProperties.getDisplayName());
            if (!SetupAction.this.isManual(model)) {
                SetupAction.this.accountParams(model);
            }
        }

        private String defaultUsername(String serviceName) {
            StringBuilder sb = new StringBuilder("svc-");
            String prodName = SetupAction.this.applicationProperties.getDisplayName().toLowerCase();
            if (prodName.length() > 4) {
                prodName = prodName.substring(0, 4);
            }
            if (serviceName == null || !serviceName.toLowerCase().contains(prodName)) {
                sb.append(prodName);
            }
            sb.append("sso");
            if (serviceName != null) {
                String instance;
                String string = instance = serviceName.contains(".") ? serviceName.substring(0, serviceName.indexOf(".")) : serviceName;
                if (instance.length() > 8) {
                    instance = instance.substring(0, 8);
                    while (instance.endsWith("-")) {
                        instance = instance.substring(0, instance.length() - 1);
                    }
                }
                sb.append("-").append(instance);
            }
            return sb.toString();
        }
    }

    class RealmStep
    extends Step {
        public RealmStep() {
            super("realm");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            try {
                HashMap<String, Object> copy = new HashMap<String, Object>();
                copy.putAll(model);
                String realm = SetupAction.this.lookupRealm(copy);
                if (realm == null) {
                    return false;
                }
                model.put("realm", realm);
                return true;
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        boolean process(HttpServletRequest req, Map<String, Object> model) {
            if (SetupAction.this.isBlank(req.getParameter("realm"))) {
                model.put("required", true);
                return false;
            }
            return true;
        }

        @Override
        public void show(HttpServletRequest req, Map<String, Object> model) {
            if (!SetupAction.this.isManual(model)) {
                try {
                    SetupAction.this.lookupRealm(model);
                }
                catch (NamingException namingException) {}
            } else {
                SetupAction.this.guessRealmUsingDns(model, req.getServerName());
            }
        }
    }

    class ServiceNameStep
    extends Step {
        public ServiceNameStep() {
            super("serviceName");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            try {
                String serverName = req.getServerName();
                DnsRecord dnsRecord = DnsUtils.lookup(serverName);
                if (dnsRecord.isCNAMEalias()) {
                    model.put("serviceName", dnsRecord.getCNAMEalias());
                } else {
                    model.put("serviceName", serverName);
                }
                return true;
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        boolean process(HttpServletRequest req, Map<String, Object> model) {
            String serviceName = req.getParameter("serviceName");
            if (SetupAction.this.isBlank(serviceName)) {
                model.put("required", true);
                return false;
            }
            if (!serviceName.contains(".")) {
                model.put("fqdnRequired", true);
                return false;
            }
            return true;
        }

        @Override
        public void show(HttpServletRequest req, Map<String, Object> model) {
            String serverName = req.getServerName();
            model.put("host", serverName);
            model.put("shortForm", !serverName.contains("."));
            model.put("guessedName", serverName);
            try {
                DnsRecord dnsRecord = DnsUtils.lookup(serverName);
                if (dnsRecord.isCNAMEalias()) {
                    model.put("canonicalName", dnsRecord.getCNAMEalias());
                    model.put("guessedName", dnsRecord.getCNAMEalias());
                } else {
                    model.put("aRecord", dnsRecord.getaRecord());
                }
            }
            catch (NamingException e) {
                model.put("dnsFailed", true);
            }
        }
    }

    class AdConnectStep
    extends Step {
        public AdConnectStep() {
            super("ad");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            List<DomainDirectory> activeLdapDirectories = SetupAction.this.directoryManager.getActiveMsAdDirectories();
            if (activeLdapDirectories.size() == 1) {
                model.put("directory", activeLdapDirectories.get(0).getDirectory().getId().toString());
                return true;
            }
            return false;
        }

        @Override
        public boolean process(HttpServletRequest req, Map<String, Object> model) {
            block20: {
                if ("Fetch values from AD".equals(req.getParameter("ad_connect"))) {
                    if ("custom".equals(model.get("directory"))) {
                        String ldap_baseurl = (String)model.get("ldap_baseurl");
                        String ldap_username = (String)model.get("ldap_username");
                        String ldap_password = (String)model.get("ldap_password");
                        boolean formValid = true;
                        if (SetupAction.this.isBlank(ldap_baseurl)) {
                            model.put("hostRequired", true);
                            formValid = false;
                        }
                        if (SetupAction.this.isBlank(ldap_username)) {
                            model.put("usernameRequired", true);
                            formValid = false;
                        }
                        if (SetupAction.this.isBlank(ldap_password)) {
                            model.put("passwordRequired", true);
                            formValid = false;
                        }
                        if (!formValid) {
                            return false;
                        }
                    }
                    try {
                        if (!SetupAction.this.ldapConnect(model)) {
                            model.put("notActiveDirectory", true);
                            return false;
                        }
                        break block20;
                    }
                    catch (NamingException e) {
                        if (e instanceof AuthenticationException) {
                            model.put("authError", "Wrong usename or password");
                        } else if (e instanceof CommunicationException && e.getRootCause() != null) {
                            if (e.getRootCause().getClass() == UnknownHostException.class) {
                                model.put("serverError", "Unknown host");
                            } else if (e.getRootCause().getClass() == ConnectException.class) {
                                if (e.getRootCause().getMessage().toLowerCase().contains("operation timed")) {
                                    model.put("serverError", "Connection timed out");
                                } else if (e.getRootCause().getMessage().toLowerCase().contains("refused")) {
                                    model.put("serverError", "Connection refused");
                                }
                            } else if (e.getRootCause().getClass() == SocketTimeoutException.class) {
                                model.put("serverError", "Connection timed out");
                            }
                        }
                        model.put("connectionFailed", true);
                        return false;
                    }
                }
                model.put("directory", "manual");
            }
            return true;
        }

        @Override
        public void show(HttpServletRequest req, Map<String, Object> model) {
            model.put("step", "ad");
            model.put("displayName", SetupAction.this.applicationProperties.getDisplayName());
            model.put("userDirectories", SetupAction.this.directoryManager.getActiveMsAdDirectories());
        }
    }

    class StartStep
    extends Step {
        public StartStep() {
            super("start");
        }

        @Override
        public boolean guess(HttpServletRequest req, Map<String, Object> model) {
            return true;
        }

        @Override
        boolean process(HttpServletRequest req, Map<String, Object> model) {
            return true;
        }

        @Override
        public void show(HttpServletRequest req, Map<String, Object> model) {
            model.put("displayName", SetupAction.this.applicationProperties.getDisplayName());
            model.put("host", req.getServerName());
            String baseUrl = SetupAction.this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
            model.put("configuredBaseUrl", baseUrl);
            String actualUrl = SetupAction.this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            model.put("actualBaseUrl", actualUrl);
            model.put("activeUserDirectories", SetupAction.this.userLookupService.getActiveUserDirectories());
        }
    }

    abstract class Step {
        private final String name;

        public Step(String name) {
            this.name = name;
        }

        abstract boolean process(HttpServletRequest var1, Map<String, Object> var2);

        public String getName() {
            return this.name;
        }

        public abstract void show(HttpServletRequest var1, Map<String, Object> var2);

        public abstract boolean guess(HttpServletRequest var1, Map<String, Object> var2);
    }
}

