/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.DomainDirectory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlDirectoryManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HostApp hostApp;

    @Inject
    public AtlDirectoryManager(HostAppFactory hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
    }

    public List<Directory> getActiveLdapDirectories() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (!directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public List<DomainDirectory> getActiveMsAdDirectories() {
        ArrayList<DomainDirectory> result = new ArrayList<DomainDirectory>();
        for (Directory directory : this.getActiveLdapDirectories()) {
            try {
                DomainDirectory domainDirectory = this.getDomainDirectory(directory);
                if (!domainDirectory.isActiveDirectory()) continue;
                result.add(domainDirectory);
            }
            catch (NamingException domainDirectory) {
            }
            catch (RuntimeException r) {
                this.log.warn(r.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainDirectory getDomainDirectory(Directory directory) throws NamingException {
        Context context = null;
        try {
            Hashtable<String, String> env = this.getEnvForDirectory(directory);
            context = new InitialDirContext(env);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = context.search("", "(objectClass=*)", sc).next().getAttributes();
            Attribute defaultNamingContext = rootAttrs.get("defaultNamingContext");
            Attribute forestfunctionality = rootAttrs.get("forestfunctionality");
            DomainDirectory domainDirectory = new DomainDirectory(directory, defaultNamingContext == null ? null : defaultNamingContext.get().toString(), forestfunctionality == null ? null : forestfunctionality.get().toString());
            return domainDirectory;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Hashtable<String, String> getEnvForDirectory(Directory directory) {
        Map attributes = directory.getAttributes();
        String ldapUrl = (String)attributes.get("ldap.url");
        String ldapUserDn = (String)attributes.get("ldap.userdn");
        String ldapPassword = this.hostApp.optionallyDecryptLdapPassword((String)attributes.get("ldap.password"));
        return this.getLdapEnv(ldapUrl, ldapUserDn, ldapPassword);
    }

    public Hashtable<String, String> getLdapEnv(String ldapUrl, String ldapUserDn, String ldapPassword) {
        if (StringUtils.isBlank((CharSequence)ldapUrl)) {
            throw new IllegalArgumentException("LDAP URL must be non empty.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        env.put("com.sun.jndi.ldap.read.timeout", "15000");
        env.put("java.naming.security.principal", (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trim((String)ldapUserDn), (CharSequence)""));
        env.put("java.naming.security.credentials", (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trim((String)ldapPassword), (CharSequence)""));
        return env;
    }
}

