/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import io.vavr.CheckedFunction0;
import io.vavr.collection.HashMap;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;

public class TestRecord
implements DebugInfo {
    protected final String id;
    protected final Date lastModified;
    protected final Properties props;

    public TestRecord(String id, Date lastModified, Properties props) {
        this.id = id;
        this.lastModified = new Date(lastModified.getTime());
        this.props = props;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastModified() {
        return new Date(this.lastModified.getTime());
    }

    public Properties getProps() {
        return new Properties(this.props);
    }

    public String getRequestAddress() {
        return this.props.getProperty("requestAddress");
    }

    public String getResponseAddress() {
        return this.props.getProperty("responseAddress");
    }

    public Date getRequestTime() {
        return ISODateTimeFormat.dateTimeParser().parseDateTime(this.props.getProperty("requestTime")).toDate();
    }

    public Date getResponseTime() {
        String responseTime = this.props.getProperty("responseTime");
        return responseTime == null ? null : ISODateTimeFormat.dateTimeParser().parseDateTime(responseTime).toDate();
    }

    public ResponseEvaluationCode getCode() {
        String code = this.props.getProperty("code");
        if (code == null) {
            return ResponseEvaluationCode.WAITING_FOR_RESPONSE;
        }
        return ResponseEvaluationCode.valueOf(code);
    }

    public IdpConfiguration.SSOProtocol getSsoProtocol() {
        return (IdpConfiguration.SSOProtocol)((Object)Try.of((CheckedFunction0 & Serializable)() -> this.props.getProperty("ssoProtocol")).mapTry(IdpConfiguration.SSOProtocol::valueOf).getOrElse((Object)IdpConfiguration.SSOProtocol.UNKNOWN));
    }

    public String getUsername() {
        return this.props.getProperty("username");
    }

    public String getFullname() {
        return this.props.getProperty("fullname");
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        HashMap record = HashMap.of((Object)"id", (Object)this.id, (Object)"lastModified", (Object)this.lastModified, (Object)"ssoProtocol", (Object)((Object)this.getSsoProtocol()), (Object)"username", (Object)this.getUsername(), (Object)"fullName", (Object)this.getFullname(), (Object)"code", (Object)(this.getCode().toString() + "(" + this.getCode().getDisplayName() + ")"), (Object)"requestTime", (Object)this.getRequestTime(), (Object)"responseTime", (Object)this.getResponseTime(), (Object)"requestAddress", (Object)this.getRequestAddress(), (Object)"responseAddress", (Object)this.getResponseAddress());
        json.put("testRecord[" + this.id + "]", record.toJavaMap());
        return json;
    }
}

