/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.control.Option;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ErrorUtils {
    public static KssoError createKssoError(String code, String message) {
        return new KssoError(code, message);
    }

    public static String createErrorMessage(String code, String message) {
        return String.format("[%s] %s", code, message);
    }

    public static class KssoException
    extends RuntimeException {
        public KssoException(String msg) {
            super(msg);
        }

        public KssoException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class KssoError {
        public final String code;
        public final String message;

        KssoError(String code, String message) {
            this.code = (String)Option.of((Object)code).getOrElse((Object)"");
            this.message = (String)Option.of((Object)message).getOrElse((Object)"");
        }

        public String toString() {
            return ErrorUtils.createErrorMessage(this.code, this.message);
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((CharSequence)this.code) && StringUtils.isEmpty((CharSequence)this.message);
        }

        public String asMessage() {
            return ErrorUtils.createErrorMessage(this.code, this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KssoError that = (KssoError)o;
            return Objects.equals(this.code, that.code) && Objects.equals(this.message, that.message);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.message);
        }
    }
}

